/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.logging.PaxLoggingService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class LogSystemConfigurator {
    public static final String SYSTEM_PROPERTY_KEY_RELOCATION_SUCCESSFUL = "rce.logFileRelocationSuccessful";
    private static final String RECONFIGURATION_TARGET_CLASS = "de.rcenvironment.core.configuration.logging.SelectableLocationFileAppender";
    private static final String STATIC_RECONFIGURATION_METHOD = "configureFinalLogEnvironment";
    private static final String STATIC_FINALIZATION_METHOD = "finalizeLogRelocationForAllAppenders";
    private final BundleContext bundleContext;
    private Log log = LogFactory.getLog(this.getClass());

    public LogSystemConfigurator() {
        this.bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        if (this.bundleContext == null) {
            throw new IllegalStateException("Failed to acquire a BundleContext for class " + this.getClass());
        }
    }

    public void relocateLogFilesToProfileDirectory(File baseDirectory, String filenamePrefix) {
        boolean success;
        this.log.debug((Object)("Reconfiguring the log system with final output directory " + baseDirectory.getAbsolutePath() + " and log filename prefix '" + filenamePrefix + "'"));
        if (!this.configureFinalLogEnvironmentViaReflection(baseDirectory, filenamePrefix)) {
            throw new IllegalStateException("Failed to reconfigure the log system for writing to profile-specific log files");
        }
        try {
            success = this.attemptToTriggerPaxLog4j2Reconfiguration();
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error while attempting to reconfigure the log system for writing to profile-specific log files", (Throwable)e);
            return;
        }
        if (success) {
            this.finalizeRelocationViaReflection();
            this.log = LogFactory.getLog(this.getClass());
            this.log.debug((Object)("Successfully reconfigured the log system with final output directory " + baseDirectory.getAbsolutePath() + " and log filename prefix '" + filenamePrefix + "'"));
            System.setProperty(SYSTEM_PROPERTY_KEY_RELOCATION_SUCCESSFUL, "");
        }
    }

    private boolean attemptToTriggerPaxLog4j2Reconfiguration() {
        boolean success = false;
        String registeredServiceName = PaxLoggingService.class.getName();
        try {
            ServiceReference[] refs = this.bundleContext.getAllServiceReferences(registeredServiceName, null);
            if (refs == null) {
                throw new IllegalStateException("Found no registered OSGi service for " + registeredServiceName + "; was pax-logging properly initialized?");
            }
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                Object service = this.bundleContext.getService(ref);
                if (!service.getClass().getName().equals("org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl$1ManagedPaxLoggingService")) {
                    this.log.debug((Object)("Ignoring other registered PaxLoggingService service of class " + service.getClass()));
                } else {
                    try {
                        Field outerInstanceField = service.getClass().getDeclaredField("this$0");
                        outerInstanceField.setAccessible(true);
                        Object outerInstance = outerInstanceField.get(service);
                        String actualOuterClassName = outerInstance.getClass().getName();
                        if (!actualOuterClassName.equals("org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl")) {
                            throw new IllegalStateException("Expected to find an outer class of type org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl, but found " + actualOuterClassName + " instead");
                        }
                        Method method = outerInstance.getClass().getDeclaredMethod("updated", Dictionary.class);
                        method.setAccessible(true);
                        method.invoke(outerInstance, new Object[]{null});
                        success = true;
                        break;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        this.log.error((Object)"Failed to perform reflection operation", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Failed to fetch the list of OSGi services for " + registeredServiceName, e);
        }
        return success;
    }

    private boolean configureFinalLogEnvironmentViaReflection(File baseDirectory, String filenamePrefix) {
        try {
            Class<?> classProvidingStaticTriggerMethod = Class.forName(RECONFIGURATION_TARGET_CLASS);
            Method staticMethod = classProvidingStaticTriggerMethod.getMethod(STATIC_RECONFIGURATION_METHOD, File.class, String.class);
            staticMethod.invoke(null, baseDirectory, filenamePrefix);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            String baseMessage = "Error while reconfiguring the log system to use profile-specific log files in " + baseDirectory;
            System.err.println(String.valueOf(baseMessage) + ": " + e.toString());
            this.log.error((Object)baseMessage, (Throwable)e);
            return false;
        }
    }

    private boolean finalizeRelocationViaReflection() {
        try {
            Class<?> classProvidingStaticTriggerMethod = Class.forName(RECONFIGURATION_TARGET_CLASS);
            Method staticMethod = classProvidingStaticTriggerMethod.getMethod(STATIC_FINALIZATION_METHOD, new Class[0]);
            staticMethod.invoke(null, new Object[0]);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            String baseMessage = "Error while finalizing the reconfiguration from early log files to profile-specific ones";
            System.err.println(String.valueOf(baseMessage) + ": " + e.toString());
            this.log.error((Object)baseMessage, (Throwable)e);
            return false;
        }
    }
}

