/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.uplinktoolaccess.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupListener;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionListener;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionListenerAdapter;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionService;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionSetup;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptor;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptorListUpdate;
import de.rcenvironment.core.communication.uplink.client.session.api.UplinkLogicalNodeMappingService;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.api.UserComponentIdMappingService;
import de.rcenvironment.core.component.integration.documentation.ToolDocumentationProvider;
import de.rcenvironment.core.component.integration.documentation.ToolIntegrationDocumentationService;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.management.utils.JsonDataEncryptionUtils;
import de.rcenvironment.core.component.management.utils.JsonDataWithOptionalEncryption;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInstallationBuilder;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentInterfaceBuilder;
import de.rcenvironment.core.component.model.api.ComponentRevisionBuilder;
import de.rcenvironment.core.component.model.configuration.api.ComponentConfigurationModelFactory;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.endpoint.api.ComponentEndpointModelFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.uplinktoolaccess.UplinkToolAccessClientService;
import de.rcenvironment.core.component.uplinktoolaccess.internal.UplinkToolAccessComponentDescription;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.ServiceUtils;
import de.rcenvironment.core.utils.common.SizeValidatedDataSource;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class UplinkToolAccessClientServiceImpl
implements UplinkToolAccessClientService {
    private static final String SLASH = "/";
    private static final int SIZE_32 = 32;
    private static final int SIZE_16 = 16;
    private static final Log LOG = LogFactory.getLog(UplinkToolAccessClientServiceImpl.class);
    private static LocalComponentRegistrationService registry;
    @Reference
    private UserComponentIdMappingService userComponentIdMappingService;
    @Reference
    private SshUplinkConnectionService sshUplinkService;
    @Reference
    private ToolIntegrationDocumentationService toolDocService;
    private final Map<String, Map<String, ComponentInstallation>> registeredComponentsPerDestinationId;
    private final Map<String, Map<String, String>> registeredComponentHashesPerDestinationId;
    private ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<String, Map<String, ToolDescriptorListUpdate>> destinationIdsAndPublicationEntriesPerConnection;
    @Reference
    private AuthorizationService authorizationService;
    @Reference
    private UplinkLogicalNodeMappingService logicalNodeMappingService;

    public UplinkToolAccessClientServiceImpl() {
        this.registeredComponentsPerDestinationId = Collections.synchronizedMap(new HashMap());
        this.registeredComponentHashesPerDestinationId = Collections.synchronizedMap(new HashMap());
        this.destinationIdsAndPublicationEntriesPerConnection = new HashMap<String, Map<String, ToolDescriptorListUpdate>>();
    }

    @Reference(unbind="unbindComponentRegistry")
    protected void bindComponentRegistry(LocalComponentRegistrationService newRegistry) {
        registry = newRegistry;
    }

    protected void unbindComponentRegistry(LocalComponentRegistrationService oldRegistry) {
        registry = (LocalComponentRegistrationService)ServiceUtils.createFailingServiceProxy(LocalComponentRegistrationService.class);
    }

    @Activate
    public void activate() {
        this.registerListener();
    }

    private void registerListener() {
        this.authorizationService.addAuthorizationAccessGroupListener(new AuthorizationAccessGroupListener(){

            public void onAvailableAuthorizationAccessGroupsChanged(List<AuthorizationAccessGroup> accessGroups) {
                for (Map.Entry<String, Map<String, ToolDescriptorListUpdate>> entry : UplinkToolAccessClientServiceImpl.this.destinationIdsAndPublicationEntriesPerConnection.entrySet()) {
                    String connectionId = entry.getKey();
                    for (ToolDescriptorListUpdate publicationEntries : entry.getValue().values()) {
                        UplinkToolAccessClientServiceImpl.this.updateAndRegisterRemoteTools(publicationEntries, connectionId);
                    }
                }
            }
        });
        SshUplinkConnectionListenerAdapter listener = new SshUplinkConnectionListenerAdapter(){

            public void onPublicationEntriesChanged(ToolDescriptorListUpdate publicationEntries, String connectionId) {
                UplinkToolAccessClientServiceImpl.this.updateAndRegisterRemoteTools(publicationEntries, connectionId);
            }

            public void onConnectionClosed(SshUplinkConnectionSetup setup, boolean willAutoRetry) {
                UplinkToolAccessClientServiceImpl.this.removeAllToolsForConnection(setup.getId());
                UplinkToolAccessClientServiceImpl.this.destinationIdsAndPublicationEntriesPerConnection.remove(setup.getId());
            }
        };
        this.sshUplinkService.addListener((SshUplinkConnectionListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAndRegisterRemoteTools(ToolDescriptorListUpdate publicationEntries, String connectionId) {
        Map<String, String> registeredComponentHashes;
        Map<String, Object> registeredComponents = this.registeredComponentsPerDestinationId.get(publicationEntries.getDestinationId());
        if (registeredComponents == null) {
            registeredComponents = Collections.synchronizedMap(new HashMap());
            this.registeredComponentsPerDestinationId.put(publicationEntries.getDestinationId(), registeredComponents);
        }
        if ((registeredComponentHashes = this.registeredComponentHashesPerDestinationId.get(publicationEntries.getDestinationId())) == null) {
            registeredComponentHashes = Collections.synchronizedMap(new HashMap());
            this.registeredComponentHashesPerDestinationId.put(publicationEntries.getDestinationId(), registeredComponentHashes);
        }
        if (this.destinationIdsAndPublicationEntriesPerConnection.get(connectionId) == null) {
            this.destinationIdsAndPublicationEntriesPerConnection.put(connectionId, new HashMap());
        }
        this.destinationIdsAndPublicationEntriesPerConnection.get(connectionId).put(publicationEntries.getDestinationId(), publicationEntries);
        ArrayList<String> componentIdsReceivedAndRegistered = new ArrayList<String>();
        LogicalNodeId logicalNodeId = this.logicalNodeMappingService.getLocalLogicalNodeIdForDestinationIdAndUpdateName(publicationEntries.getDestinationId(), publicationEntries.getDisplayName());
        if (logicalNodeId == null) {
            logicalNodeId = this.logicalNodeMappingService.createOrGetLocalLogicalNodeIdForDestinationId(publicationEntries.getDestinationId(), publicationEntries.getDisplayName());
            this.registerToolDocumentationProvider(logicalNodeId);
        }
        for (ToolDescriptor toolDesc : publicationEntries.getToolDescriptors()) {
            this.readAndRegisterSingleTool(connectionId, publicationEntries.getDestinationId(), registeredComponents, registeredComponentHashes, componentIdsReceivedAndRegistered, toolDesc, logicalNodeId);
        }
        Map<String, Object> map = registeredComponents;
        synchronized (map) {
            Iterator<String> it = registeredComponents.keySet().iterator();
            while (it.hasNext()) {
                String regCompName = it.next();
                if (componentIdsReceivedAndRegistered.contains(regCompName)) continue;
                this.removeToolAccessComponent(regCompName, publicationEntries.getDestinationId());
                it.remove();
                registeredComponentHashes.remove(regCompName);
            }
        }
    }

    private void registerToolDocumentationProvider(LogicalNodeId logicalNodeId) {
        this.toolDocService.registerToolDocumentationProvider(new ToolDocumentationProvider(){

            public byte[] provideToolDocumentation(String identifier, String nodeId, String hashValue) throws IOException {
                Optional<SizeValidatedDataSource> result = UplinkToolAccessClientServiceImpl.this.downloadToolDocumentation(identifier, nodeId, hashValue);
                if (!result.isPresent()) {
                    return null;
                }
                SizeValidatedDataSource dataSource = result.get();
                long size = dataSource.getSize();
                if (size > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                byte[] buffer = new byte[(int)size];
                IOUtils.readFully((InputStream)dataSource.getStream(), (byte[])buffer);
                if (!dataSource.receivedCompletely()) {
                    throw new IOException("Received incomplete download for documentation id " + identifier);
                }
                return buffer;
            }
        }, logicalNodeId.getLogicalNodeIdString());
    }

    private void readAndRegisterSingleTool(String connectionId, String destinationId, Map<String, ComponentInstallation> registeredComponents, Map<String, String> registeredComponentHashes, List<String> componentIdsReceivedAndRegistered, ToolDescriptor toolDesc, LogicalNodeId logicalNodeId) {
        try {
            String decryptedToolData;
            AuthorizationPermissionSet permissionSet = null;
            if (toolDesc.getAuthGroupIds().size() == 1 && ((String)toolDesc.getAuthGroupIds().iterator().next()).equals("public")) {
                permissionSet = this.authorizationService.getDefaultAuthorizationObjects().permissionSetPublicInLocalNetwork();
            } else {
                Set declaredAuthGroups = this.authorizationService.representRemoteGroupIds((Collection)toolDesc.getAuthGroupIds());
                Set accessibleAuthGroups = this.authorizationService.intersectWithAccessibleGroups(declaredAuthGroups);
                permissionSet = this.authorizationService.buildPermissionSet((Collection)accessibleAuthGroups);
                if (accessibleAuthGroups.isEmpty()) {
                    this.log.debug((Object)("No local authorization group match for '" + toolDesc.getToolId() + SLASH + toolDesc.getToolVersion() + "'; tool will not be registered"));
                    return;
                }
            }
            if (JsonDataEncryptionUtils.isPublic((JsonDataWithOptionalEncryption)toolDesc.getSerializedToolData())) {
                decryptedToolData = JsonDataEncryptionUtils.getPublicData((JsonDataWithOptionalEncryption)toolDesc.getSerializedToolData());
            } else {
                AuthorizationAccessGroup groupForDecryption = permissionSet.getArbitraryGroup();
                decryptedToolData = JsonDataEncryptionUtils.attemptDecryption((JsonDataWithOptionalEncryption)toolDesc.getSerializedToolData(), (String)groupForDecryption.getFullId(), (SymmetricKey)this.authorizationService.getKeyDataForGroup(groupForDecryption).getSymmetricKey(), (CryptographyOperationsProvider)this.authorizationService.getCryptographyOperationsProvider());
            }
            UplinkToolAccessComponentDescription compDesc = (UplinkToolAccessComponentDescription)this.mapper.readValue(decryptedToolData, UplinkToolAccessComponentDescription.class);
            if (!compDesc.getComponentId().equals(toolDesc.getToolId()) || !compDesc.getToolVersion().equals(toolDesc.getToolVersion())) {
                this.log.warn((Object)"Mismatch between tool descriptor and serialized tool data; cannot register tool.");
                return;
            }
            String toolInstallationId = this.createUniqueToolInstallationId(toolDesc.getToolId(), toolDesc.getToolVersion(), logicalNodeId);
            if (!registeredComponents.containsKey(toolInstallationId)) {
                LOG.debug((Object)StringUtils.format((String)"Detected new Uplink tool %s (version %s) on host %s", (Object[])new Object[]{toolDesc.getToolId(), toolDesc.getToolVersion(), destinationId}));
                this.registerToolAccessComponent(toolInstallationId, compDesc, connectionId, destinationId, permissionSet, logicalNodeId);
                registeredComponentHashes.put(toolInstallationId, toolDesc.getToolDataHash());
            } else if (!registeredComponentHashes.get(toolInstallationId).equals(toolDesc.getToolDataHash())) {
                this.removeToolAccessComponent(toolInstallationId, destinationId);
                registeredComponentHashes.remove(toolInstallationId);
                this.registerToolAccessComponent(toolInstallationId, compDesc, connectionId, destinationId, permissionSet, logicalNodeId);
                registeredComponentHashes.put(toolInstallationId, toolDesc.getToolDataHash());
                LOG.info((Object)StringUtils.format((String)"Remote tool %s changed to version %s on host %s.", (Object[])new Object[]{toolDesc.getToolId(), toolDesc.getToolVersion(), destinationId}));
            } else if (!registry.getComponentPermissionSet(registry.getComponentSelector(registeredComponents.get(toolInstallationId)), true).equals(permissionSet)) {
                if (!this.sshUplinkService.getConnectionSetup(connectionId).isGateway()) {
                    permissionSet = this.authorizationService.getDefaultAuthorizationObjects().permissionSetLocalOnly();
                }
                registry.setComponentPermissions(registry.getComponentSelector(registeredComponents.get(toolInstallationId)), permissionSet);
            }
            componentIdsReceivedAndRegistered.add(toolInstallationId);
        }
        catch (OperationFailureException | IOException e) {
            this.log.warn((Object)("Could not deserialize tool data: " + e.getMessage()));
        }
    }

    private String createUniqueToolInstallationId(String toolId, String toolVersion, LogicalNodeId logicalNodeId) {
        return String.valueOf(toolId) + SLASH + toolVersion + SLASH + logicalNodeId.getLogicalNodePart();
    }

    protected void registerToolAccessComponent(String installationId, UplinkToolAccessComponentDescription component, String connectionId, String destinationId, AuthorizationPermissionSet permissionSet, LogicalNodeId nodeId) {
        Set<EndpointDefinition> inputs = this.createEndpointDefinitions(component.getInputDefinitions(), EndpointType.INPUT);
        EndpointDefinitionsProvider inputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(inputs);
        Set<EndpointDefinition> outputs = this.createEndpointDefinitions(component.getOutputDefinitions(), EndpointType.OUTPUT);
        EndpointDefinitionsProvider outputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(outputs);
        ConfigurationDefinition configuration = this.generateConfiguration(component, destinationId, connectionId, permissionSet);
        try {
            String internalComponentId = this.userComponentIdMappingService.fromExternalToInternalId(component.getComponentId());
            ComponentInterface componentInterface = new ComponentInterfaceBuilder().setIdentifier(internalComponentId).setDisplayName(component.getToolName()).setIcon16(this.readDefaultToolIcon(16)).setIcon32(this.readDefaultToolIcon(32)).setGroupName(component.getPaletteGroup()).setVersion(component.getToolVersion()).setDocumentationHash(component.getToolDocumentationHash()).setInputDefinitionsProvider(inputProvider).setOutputDefinitionsProvider(outputProvider).setConfigurationDefinition(configuration).setConfigurationExtensionDefinitions(new HashSet()).setColor(ComponentConstants.COMPONENT_COLOR_STANDARD).setShape(ComponentConstants.COMPONENT_SHAPE_STANDARD).setSize(ComponentConstants.COMPONENT_SIZE_STANDARD).build();
            ComponentInstallation ci = new ComponentInstallationBuilder().setComponentRevision(new ComponentRevisionBuilder().setComponentInterface(componentInterface).setClassName("de.rcenvironment.core.component.uplinktoolaccess.UplinkToolAccessClientComponent").build()).setNodeId(nodeId).setInstallationId(installationId).setIsMappedCompoent(true).build();
            registry.registerOrUpdateLocalComponentInstallation(ci);
            if (this.sshUplinkService.getConnectionSetup(connectionId).isGateway()) {
                registry.setComponentPermissions(registry.getComponentSelector(ci), permissionSet);
            } else {
                registry.setComponentPermissions(registry.getComponentSelector(ci), this.authorizationService.getDefaultAuthorizationObjects().permissionSetLocalOnly());
            }
            this.registeredComponentsPerDestinationId.get(destinationId).put(installationId, ci);
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Component Id " + component.getComponentId() + " could not be converted. Cause: " + e.getMessage()));
        }
    }

    protected void removeToolAccessComponent(String installationId, String destinationId) {
        ComponentInstallation ci = this.registeredComponentsPerDestinationId.get(destinationId).get(installationId);
        if (ci != null) {
            registry.setComponentPermissions(registry.getComponentSelector(ci), this.authorizationService.getDefaultAuthorizationObjects().permissionSetLocalOnly());
            registry.unregisterLocalComponentInstallation(ci.getInstallationId());
        }
    }

    private void removeAllToolsForConnection(String connectionId) {
        if (this.destinationIdsAndPublicationEntriesPerConnection.containsKey(connectionId)) {
            for (String destinationId : this.destinationIdsAndPublicationEntriesPerConnection.get(connectionId).keySet()) {
                Map<String, ComponentInstallation> compsForDestination = this.registeredComponentsPerDestinationId.get(destinationId);
                if (compsForDestination != null) {
                    for (String installationId : compsForDestination.keySet()) {
                        this.removeToolAccessComponent(installationId, destinationId);
                    }
                }
                this.registeredComponentsPerDestinationId.remove(destinationId);
                this.registeredComponentHashesPerDestinationId.remove(destinationId);
            }
        }
    }

    private ConfigurationDefinition generateConfiguration(UplinkToolAccessComponentDescription component, String destinationId, String connectionId, AuthorizationPermissionSet permissionSet) {
        Map<String, String> readOnlyConfiguration = component.getReadOnlyConfig();
        readOnlyConfiguration.put("toolId", component.getComponentId());
        readOnlyConfiguration.put("version", component.getToolVersion());
        readOnlyConfiguration.put("connection", connectionId);
        readOnlyConfiguration.put("destinationId", destinationId);
        readOnlyConfiguration.put("authGroupId", permissionSet.getArbitraryGroup().getFullId());
        return ComponentConfigurationModelFactory.createConfigurationDefinition(component.getConfigurationValues(), new LinkedList(), component.getConfigurationMetaData(), readOnlyConfiguration);
    }

    private Set<EndpointDefinition> createEndpointDefinitions(Set<Map<String, Object>> rawEndpointData, EndpointType type) {
        HashSet<EndpointDefinition> endpoints = new HashSet<EndpointDefinition>();
        for (Map<String, Object> rawEndpoint : rawEndpointData) {
            EndpointDefinition endpoint = ComponentEndpointModelFactory.createEndpointDefinition(rawEndpoint, (EndpointType)type);
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    private byte[] readDefaultToolIcon(int iconSize) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = this.getClass().getResourceAsStream("/icons/tool" + iconSize + ".png");){
                return IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | NullPointerException e) {
            LOG.error((Object)("Failed to read default tool icon: " + e));
            return null;
        }
    }

    @Override
    public Optional<SizeValidatedDataSource> downloadToolDocumentation(String toolIdAndVersion, String logicalNodeId, String hashValue) {
        String destinationId = this.logicalNodeMappingService.getDestinationIdForLogicalNodeId(logicalNodeId);
        if (destinationId == null) {
            this.log.warn((Object)("No destinationId could be found for logical node id " + logicalNodeId));
        }
        String connectionId = null;
        for (Map.Entry<String, Map<String, ToolDescriptorListUpdate>> entry : this.destinationIdsAndPublicationEntriesPerConnection.entrySet()) {
            if (!entry.getValue().containsKey(destinationId)) continue;
            connectionId = entry.getKey();
            break;
        }
        String docReferenceId = String.valueOf(toolIdAndVersion) + SLASH + hashValue;
        Optional optionalUplinkSession = this.sshUplinkService.getActiveSshUplinkSession(connectionId);
        if (!optionalUplinkSession.isPresent()) {
            this.log.warn((Object)"Tool documentation download requested, but the required Uplink connection is not active anymore");
            return Optional.empty();
        }
        return ((ClientSideUplinkSession)optionalUplinkSession.get()).fetchDocumentationData(destinationId, docReferenceId);
    }
}

