/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputLocationList;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class OutputWriterRemoveDynamicInputCommand
extends RemoveDynamicEndpointCommand {
    private ObjectMapper mapper;
    private String oldJsonString = "";
    private List<String> outputLocationIds;

    public OutputWriterRemoveDynamicInputCommand(EndpointType type, String dynamicEndpointId, List<String> names, List<String> outputLocationIds, Refreshable ... refreshable) {
        super(type, dynamicEndpointId, names, refreshable);
        this.outputLocationIds = outputLocationIds;
        this.mapper = JsonUtils.getDefaultObjectMapper();
        this.mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    public void execute() {
        try {
            String inputJsonString = this.getProperties().getConfigurationDescription().getConfigurationValue("outputLocations");
            if (inputJsonString != null && !inputJsonString.equals("")) {
                OutputLocationList list = (OutputLocationList)this.mapper.readValue(inputJsonString, OutputLocationList.class);
                for (String id : this.outputLocationIds) {
                    OutputLocation location = list.getOutputLocationById(id);
                    location.getInputs().removeAll(this.names);
                }
                String outputJsonString = this.mapper.writeValueAsString((Object)list);
                this.getProperties().getConfigurationDescription().setConfigurationValue("outputLocations", outputJsonString);
                this.oldJsonString = inputJsonString;
            }
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Error when writing components to JSON: " + e.getMessage()));
        }
        super.execute();
    }

    public void undo() {
        this.getProperties().getConfigurationDescription().setConfigurationValue("outputLocations", this.oldJsonString);
        super.undo();
    }
}

