/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.component.execution.api.BatchedConsoleRowsProcessor;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.SingleConsoleRowsProcessor;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchProcessor;
import java.util.List;

public class BatchingConsoleRowsForwarder
implements SingleConsoleRowsProcessor {
    private static final int MAX_BATCH_SIZE = 500;
    private static final long MAX_BATCH_LATENCY_MSEC = 200L;
    private final BatchAggregator<ConsoleRow> batchAggregator;

    public BatchingConsoleRowsForwarder(final BatchedConsoleRowsProcessor consoleRowsProcessor) {
        BatchProcessor<ConsoleRow> batchProcessor = new BatchProcessor<ConsoleRow>(){

            public void processBatch(List<ConsoleRow> batch) {
                ConsoleRow[] batchArray = batch.toArray(new ConsoleRow[batch.size()]);
                consoleRowsProcessor.processConsoleRows(batchArray);
            }
        };
        this.batchAggregator = ConcurrencyUtils.getFactory().createBatchAggregator(500, 200L, (BatchProcessor)batchProcessor);
    }

    @Override
    public void onConsoleRow(ConsoleRow consoleRow) {
        this.batchAggregator.enqueue((Object)consoleRow);
    }
}

