/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.FileParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedFileParameter;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.datamanagement.MetaDataService;
import de.rcenvironment.core.datamanagement.commons.WorkflowRun;
import de.rcenvironment.core.datamanagement.commons.WorkflowRunDescription;
import de.rcenvironment.core.datamanagement.export.matching.BooleanTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.DateTimeTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.DirectoryReferenceTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.FileReferenceTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.FloatTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.IntegerTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.MatchResult;
import de.rcenvironment.core.datamanagement.export.matching.Matcher;
import de.rcenvironment.core.datamanagement.export.matching.MatrixTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.NotAValueMatcher;
import de.rcenvironment.core.datamanagement.export.matching.ShortTextTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.SmallTableTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.VectorTDMatcher;
import de.rcenvironment.core.datamanagement.export.objects.PlainWorkflowRun;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class TestCommandPlugin
implements CommandPlugin {
    private static final String ROOT_COMMAND = "tc";
    private static final String OPEN_VIEW_COMMAND = "open_view";
    private static final String CLOSE_VIEW_COMMAND = "close_view";
    private static final String CLOSE_WELCOME_SCREEN = "close_welcome";
    private static final String EXPORT_ALL_WORKFLOW_RUNS = "export_all_wf_runs";
    private static final String EXPORT_WORKFLOW_RUN = "export_wf_run";
    private static final String COMPARE_TWO_WORKFLOW_RUNS = "compare_wf_runs";
    private Map<String, String> viewIds = new HashMap<String, String>();
    private MetaDataService metaDataService;
    private Map<DataType, Matcher> matchers = new HashMap<DataType, Matcher>();
    private ObjectMapper mapper = new ObjectMapper();
    private ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);

    public TestCommandPlugin() {
        this.fillViewIdMap();
        this.fillMatcherMap();
    }

    @Reference
    public void bindMetaDataService(MetaDataService service) {
        this.metaDataService = service;
    }

    public MainCommandDescription[] getCommands() {
        MainCommandDescription testCommands = new MainCommandDescription(ROOT_COMMAND, "test commands", "test commands", true, new SubCommandDescription[]{new SubCommandDescription(OPEN_VIEW_COMMAND, "opens a GUI view and sets focus to it.", this::handleOpenViewCommand, new CommandModifierInfo(new AbstractCommandParameter[]{new StringParameter(null, "open view parameter", "one of the following view keys is a valid input:" + this.viewIds.keySet().toString())}), true), new SubCommandDescription(CLOSE_VIEW_COMMAND, "closes a GUI view.", this::handleCloseViewCommand, new CommandModifierInfo(new AbstractCommandParameter[]{new StringParameter(null, "close view parameter", "one of the following view keys is a valid input:" + this.viewIds.keySet().toString())}), true), new SubCommandDescription(CLOSE_WELCOME_SCREEN, "closes the welcome screen if present.", this::closeWelcomeScreen, true), new SubCommandDescription(EXPORT_WORKFLOW_RUN, "exports the run corresponding to the workflowtitle to the given directory.", this::exportWorkflow, new CommandModifierInfo(new AbstractCommandParameter[]{new StringParameter(null, "absolute directory path", "absolute path to directory"), new StringParameter(null, "workflow title", "title of the workflow")}), true), new SubCommandDescription(COMPARE_TWO_WORKFLOW_RUNS, "compares the two given workflowruns and indicates if they are identical or wether their are differences.", this::compareWorkflowRuns, new CommandModifierInfo(new AbstractCommandParameter[]{new FileParameter("abs export workflow path", "absolute path to exported workflowrun"), new FileParameter("abs export workflow path", "absolute path to exported workflowrun")}), true), new SubCommandDescription(EXPORT_ALL_WORKFLOW_RUNS, "exports all workflow runs into the given export directory.", this::exportAllWorkflows, new CommandModifierInfo(new AbstractCommandParameter[]{new StringParameter(null, "abs path to export dir", "absolute path to export directory")}), true)});
        return new MainCommandDescription[]{testCommands};
    }

    private void closeWelcomeScreen(CommandContext context) {
        new UIJob("Closing welcome screen"){

            public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                IViewReference[] viewReferences;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    if (viewRef.getId().equals("org.eclipse.ui.internal.introview")) {
                        TestCommandPlugin.this.closeView("org.eclipse.ui.internal.introview");
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void exportAllWorkflows(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter dirParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        File exportDirectory = new File(dirParameter.getResult());
        if (!exportDirectory.exists()) {
            exportDirectory.mkdirs();
        }
        try {
            for (WorkflowRunDescription wfRunDesc : this.metaDataService.getWorkflowRunDescriptions()) {
                WorkflowRun workflowRun = this.metaDataService.getWorkflowRun(wfRunDesc.getWorkflowRunID(), (NetworkDestination)wfRunDesc.getStorageLogicalNodeId());
                TypedDatumSerializer serializer = ((TypedDatumService)this.serviceRegistryAccess.getService(TypedDatumService.class)).getSerializer();
                PlainWorkflowRun plainWorkflowRun = new PlainWorkflowRun(workflowRun, serializer);
                File targetFile = new File(exportDirectory, String.valueOf(wfRunDesc.getWorkflowTitle().replaceAll(":", "_")) + ".json");
                this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
                this.mapper.writeValue(targetFile, (Object)plainWorkflowRun);
            }
        }
        catch (CommunicationException | IOException e) {
            throw CommandException.executionError((String)StringUtils.format((String)"Failed to export all workflow runs: %s", (Object[])new Object[]{e}), (CommandContext)context);
        }
        context.println((Object)"Successfully exported all workflow runs.");
    }

    private void exportWorkflow(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter dirParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        ParsedStringParameter workflowTitleParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(1);
        String dirArgument = dirParameter.getResult();
        String workflowTitle = workflowTitleParameter.getResult();
        File targetDirectory = new File(dirArgument);
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        File targetFile = new File(targetDirectory, String.valueOf(workflowTitle.replaceAll(":", "_")) + ".json");
        try {
            boolean foundCorrespondingWfRunId = false;
            for (WorkflowRunDescription wfRunDesc : this.metaDataService.getWorkflowRunDescriptions()) {
                if (!workflowTitle.equals(wfRunDesc.getWorkflowTitle())) continue;
                foundCorrespondingWfRunId = true;
                WorkflowRun workflowRun = this.metaDataService.getWorkflowRun(wfRunDesc.getWorkflowRunID(), (NetworkDestination)wfRunDesc.getStorageLogicalNodeId());
                TypedDatumSerializer serializer = ((TypedDatumService)this.serviceRegistryAccess.getService(TypedDatumService.class)).getSerializer();
                PlainWorkflowRun plainWorkflowRun = new PlainWorkflowRun(workflowRun, serializer);
                this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
                this.mapper.writeValue(targetFile, (Object)plainWorkflowRun);
                context.println((Object)"Successfully exported workflowrun.");
                break;
            }
            if (!foundCorrespondingWfRunId) {
                throw CommandException.executionError((String)StringUtils.format((String)"Failed to find workflow corresponding to wf title \"%s\"", (Object[])new Object[]{workflowTitle}), (CommandContext)context);
            }
        }
        catch (CommunicationException | IOException e) {
            throw CommandException.executionError((String)StringUtils.format((String)"Failed to export workflow run: %s", (Object[])new Object[]{e}), (CommandContext)context);
        }
    }

    private void compareWorkflowRuns(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedFileParameter wfRun1Parameter = (ParsedFileParameter)modifiers.getPositionalCommandParameter(0);
        ParsedFileParameter wfRun2Parameter = (ParsedFileParameter)modifiers.getPositionalCommandParameter(0);
        File wfRun1 = wfRun1Parameter.getResult();
        File wfRun2 = wfRun2Parameter.getResult();
        try {
            PlainWorkflowRun plainWorkflowRun1 = (PlainWorkflowRun)this.mapper.readValue(wfRun1, PlainWorkflowRun.class);
            PlainWorkflowRun plainWorkflowRun2 = (PlainWorkflowRun)this.mapper.readValue(wfRun2, PlainWorkflowRun.class);
            MatchResult result = plainWorkflowRun1.matches(this.matchers, plainWorkflowRun2);
            if (result.hasMatched()) {
                context.println((Object)"The compared workflow runs are identical.");
            } else {
                context.println((Object)"The compared workflow runs differ in the following way:");
                context.println((Object)result);
            }
        }
        catch (IOException iOException) {
            throw CommandException.executionError((String)"Could not parse passed files.", (CommandContext)context);
        }
    }

    private void handleOpenViewCommand(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter viewIdParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        String viewId = viewIdParameter.getResult();
        if (!this.viewIds.containsKey(viewId)) {
            throw CommandException.syntaxError((String)"No view associated to passed argument.", (CommandContext)context);
        }
        this.openView(viewId);
    }

    private void handleCloseViewCommand(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter viewIdParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        String viewId = viewIdParameter.getResult();
        if (!this.viewIds.containsKey(viewId)) {
            throw CommandException.syntaxError((String)"No view associated with passed argument.", (CommandContext)context);
        }
        this.closeView(this.viewIds.get(viewId));
    }

    private void openView(final String viewKey) {
        new UIJob(StringUtils.format((String)"Opening view %s", (Object[])new Object[]{viewKey})){

            public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(TestCommandPlugin.this.viewIds.get(viewKey));
                }
                catch (PartInitException partInitException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void closeView(final String viewId) {
        new UIJob(StringUtils.format((String)"Closing view %s", (Object[])new Object[]{viewId})){

            public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                IViewReference[] viewReferences;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    if (viewRef.getId().equals(viewId)) {
                        page.hideView(viewRef.getView(true));
                        return Status.OK_STATUS;
                    }
                    ++n2;
                }
                return Status.CANCEL_STATUS;
            }
        }.schedule();
    }

    private void closeAllViews() {
        new UIJob("Closing all views"){

            public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                IViewReference[] viewReferences;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    if (TestCommandPlugin.this.viewIds.containsValue(viewRef.getId())) {
                        TestCommandPlugin.this.closeView(viewRef.getId());
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void fillViewIdMap() {
        this.viewIds.put("Component_Publishing", "de.rcenvironment.core.gui.authorization.ComponentPublishingView");
        this.viewIds.put("Cluster_Job_Monitor", "de.rcenvironment.core.gui.cluster.view.ClusterJobMonitorView");
        this.viewIds.put("Command_Console", "de.rcenvironment.core.gui.command.CommandConsoleViewer");
        this.viewIds.put("CPACS_Writer", "de.rcenvironment.components.cpacs.writer.gui.runtime.CpacsGeomView");
        this.viewIds.put("Data_Management_Browser", "de.rcenvironment.rce.gui.datamanagement.browser.DataManagementBrowser");
        this.viewIds.put("Excel", "de.rcenvironment.components.excel.gui.view.ExcelView");
        this.viewIds.put("Log", "de.rcenvironment.core.gui.log.LogView");
        this.viewIds.put("Network", "de.rcenvironment.core.gui.communication.views.NetworkView");
        this.viewIds.put("Optimizer", "de.rcenvironment.components.optimizer.gui.view.OptimizerView");
        this.viewIds.put("Parametric_Study", "de.rcenvironment.components.parametricstudy.gui.view.ParametricStudyView");
        this.viewIds.put("Properties", "org.eclipse.ui.views.PropertySheet");
        this.viewIds.put("TIGL_Viewer", "de.rcenvironment.core.gui.tiglviewer.views.TIGLViewer");
        this.viewIds.put("Timeline", "de.rcenvironment.gui.Timeline");
        this.viewIds.put("Workflow_List", "de.rcenvironment.gui.workflowList");
        this.viewIds.put("Workflow_Console", "de.rcenvironment.gui.WorkflowComponentConsole");
    }

    private void fillMatcherMap() {
        this.matchers.put(DataType.Boolean, (Matcher)new BooleanTDMatcher());
        this.matchers.put(DataType.Integer, (Matcher)new IntegerTDMatcher());
        this.matchers.put(DataType.Float, (Matcher)new FloatTDMatcher());
        this.matchers.put(DataType.NotAValue, (Matcher)new NotAValueMatcher());
        this.matchers.put(DataType.ShortText, (Matcher)new ShortTextTDMatcher());
        this.matchers.put(DataType.DateTime, (Matcher)new DateTimeTDMatcher());
        this.matchers.put(DataType.DirectoryReference, (Matcher)new DirectoryReferenceTDMatcher());
        this.matchers.put(DataType.FileReference, (Matcher)new FileReferenceTDMatcher());
        this.matchers.put(DataType.Matrix, (Matcher)new MatrixTDMatcher());
        this.matchers.put(DataType.Vector, (Matcher)new VectorTDMatcher());
        this.matchers.put(DataType.SmallTable, (Matcher)new SmallTableTDMatcher());
    }
}

