/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.joiner.execution;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class JoinerComponent
extends DefaultComponent {
    private ComponentContext componentContext;
    private Set<String> indefiniteTDsSent = new HashSet<String>();

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public void processInputs() throws ComponentException {
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            TypedDatum datum = this.componentContext.readInput(inputName);
            if (datum.getDataType().equals((Object)DataType.NotAValue)) {
                if (this.indefiniteTDsSent.contains(((NotAValueTD)datum).getIdentifier())) continue;
                this.indefiniteTDsSent.add(((NotAValueTD)datum).getIdentifier());
            }
            TypedDatum inputValue = this.componentContext.readInput(inputName);
            this.componentContext.writeOutput("Joined", inputValue);
            this.componentContext.getLog().componentInfo(StringUtils.format((String)"Forwarded (joined) from input '%s': %s", (Object[])new Object[]{inputName, inputValue}));
        }
    }
}

