/*
 * Copyright 2006-2023 DLR, Germany
 * 
 * SPDX-License-Identifier: EPL-1.0
 * 
 * https://rcenvironment.de/
 */

package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.utils.common.LogUtils;

/**
 * API for sending log output. Currently, the log messages are shown in the workflow console and are also stored in the data management and
 * accessible via the workflow data browser.
 * 
 * @author Doreen Seider
 */
public interface ComponentLog {

    /**
     * Sends a log message containing an stdout message of an integrated tool.
     * 
     * @param message stdout message of a tool
     */
    void toolStdout(String message);
    
    /**
     * Sends a log message containing an stderr message of an integrated tool.
     * 
     * @param message stderr message of a tool
     */
    void toolStderr(String message);
    
    /**
     * Send a log message containing an error from a workflow component.
     * 
     * @param message error message of workflow component
     */
    void componentError(String message);
    
    /**
     * Send a log message containing an error from a workflow component.
     * 
     * @param message error message of workflow component
     * @param t cause of the error
     * @param errorId unique id that serves a reference to the full-stack trace in the log file - it must be generated by the
     *        {@link LogUtils} class
     */
    void componentError(String message, Throwable t, String errorId);
    
    /**
     * Send a log message containing a warning from a workflow component.
     * 
     * @param message warning message of workflow component
     */
    void componentWarn(String message);
    
    /**
     * Send a log message containing an info from a workflow component.
     * 
     * @param message info message of workflow component
     */
    void componentInfo(String message);
}

