/*
 * Copyright 2006-2023 DLR, Germany
 * 
 * SPDX-License-Identifier: EPL-1.0
 * 
 * https://rcenvironment.de/
 */
 
package de.rcenvironment.components.excel.gui.properties;


/**
 * Constants for Excel properties.
 *
 * @author Markus Kunde
 */
public final class ExcelPropertiesConstants {


    /** Base path to icons. */
    public static final String ICONBASEPATH = "resources/";
    
    /** Filename of excel icon. Size 16. */
    public static final String ICONNAME_EXCEL_16 = "excel16.png";
    
    /** Filename of excel icon. Size 64. */
    public static final String ICONNAME_EXCEL_64 = "excel64.png";

    /** ID of input pane. */
    public static final String ID_INPUT_PANE = "default";
    
    /** ID of output pane. */
    public static final String ID_OUTPUT_PANE = "default";
    
    /**
     * Private constructor.
     */
    private ExcelPropertiesConstants() {}
}
