/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.simulator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

public class DakotaResponse {
    private final int standardPort = 10000;
    private final int bufferSize = 200;

    public void respond(String path, String data, BufferedWriter fw) throws IOException {
        String ip = "127.0.0.1";
        fw.append("Reading port ... \r\n");
        fw.flush();
        int port = this.readPort(path, fw);
        fw.append("done: " + port + "\r\n");
        fw.append("Open Connection ... \r\n");
        fw.flush();
        Socket socket = new Socket(ip, port);
        fw.append("done.\r\n");
        fw.flush();
        fw.append("Writing message for:" + path + "/" + data + " ...");
        this.writeMessagetoDakota(socket, String.valueOf(path) + "&&" + data + "\r\n");
        fw.append("done.\r\n");
        fw.flush();
        fw.append("blocking for answer ... ");
        fw.flush();
        this.blockUntilMessageArrives(socket);
        fw.append("done. \r\n Closing Socket");
        fw.flush();
        socket.close();
    }

    private int readPort(String path, BufferedWriter fw) throws IOException {
        BufferedReader fr;
        fw.flush();
        File portfile = null;
        try {
            File f = null;
            fw.append("Path : " + path);
            f = path.contains(".inworkdir") ? new File(path.substring(0, path.lastIndexOf(File.separator))) : new File(path.substring(0, path.indexOf("workdir")));
            fw.append("F : " + f.getAbsolutePath());
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                fw.append(subFile.getAbsolutePath());
                if (subFile.getName().endsWith(".port")) {
                    portfile = subFile;
                }
                ++n2;
            }
        }
        catch (NullPointerException e) {
            fw.append(e.getMessage());
            fw.flush();
        }
        fw.flush();
        try {
            fw.flush();
            fr = new BufferedReader(new FileReader(portfile));
            String firstLine = fr.readLine();
            fw.flush();
            return Integer.valueOf(firstLine);
        }
        catch (FileNotFoundException e) {
            fw.append(e.getMessage());
            fr = null;
        }
        catch (IOException e) {
            fw.append(e.getMessage());
            return 10000;
        }
        fw.flush();
        return 10000;
    }

    private void writeMessagetoDakota(Socket socket, String nachricht) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        printWriter.print(nachricht);
        printWriter.flush();
    }

    private void blockUntilMessageArrives(Socket socket) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        char[] buffer = new char[200];
        bufferedReader.read(buffer, 0, 200);
    }

    public static void main(String[] args) {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(new File("LOGGER")));
            fw.append("My arguments: " + args[0] + "   " + args[1]);
            DakotaResponse client = new DakotaResponse();
            try {
                client.respond(args[0], args[1], fw);
                fw.flush();
                fw.close();
            }
            catch (IOException e) {
                if (fw != null && e != null) {
                    fw.append(e.toString());
                    fw.flush();
                    fw.close();
                }
            }
        }
        catch (IOException e1) {
            System.err.println(e1.getStackTrace());
        }
    }
}

