/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.execution.internal;

import de.rcenvironment.components.evaluationmemory.execution.internal.EvaluationMemoryAccess;
import de.rcenvironment.components.evaluationmemory.execution.internal.EvaluationMemoryProperties;
import de.rcenvironment.components.evaluationmemory.execution.internal.ToleranceHandling;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.logging.Logger;

public class EvaluationMemoryFileAccessImpl
implements EvaluationMemoryAccess {
    private static final String VERSION_NUMBER = "1";
    private static final List<DataType> ALWAYS_VALID_OUTPUT_DATATYPES = new ArrayList<DataType>();
    private final File evalMemoryFile;
    private TypedDatumSerializer typedDatumSerializer;
    private ComponentLog componentLog;

    static {
        ALWAYS_VALID_OUTPUT_DATATYPES.add(DataType.NotAValue);
    }

    public EvaluationMemoryFileAccessImpl(String memoryFilePath) {
        this.evalMemoryFile = new File(memoryFilePath);
    }

    @Override
    public synchronized void setInputsOutputsDefinition(SortedMap<String, DataType> inputs, SortedMap<String, DataType> outputs) throws IOException {
        EvaluationMemoryProperties evalMemory = this.loadEvaluationMemory();
        this.addInputsDefinition(inputs, evalMemory);
        this.addOutputsDefinition(outputs, evalMemory);
        this.storeEvaluationMemory(evalMemory);
    }

    @Override
    public synchronized void addEvaluationValues(SortedMap<String, TypedDatum> inputValues, SortedMap<String, TypedDatum> outputValues) throws IOException {
        EvaluationMemoryProperties evalMemory = this.loadEvaluationMemory();
        this.validateInputs(evalMemory, this.getEndpoints(inputValues));
        this.validateOutputs(evalMemory, this.getEndpoints(outputValues));
        String evalMemoryKey = this.createEvaluationMemoryKeyForInputValues(inputValues);
        ArrayList<String> evalMemoryValues = new ArrayList<String>();
        for (TypedDatum value : outputValues.values()) {
            evalMemoryValues.add(this.typedDatumSerializer.serialize(value));
        }
        evalMemory.put(evalMemoryKey, StringUtils.escapeAndConcat(evalMemoryValues));
        this.storeEvaluationMemory(evalMemory);
    }

    private void storeEvaluationMemory(EvaluationMemoryProperties evalMemory) throws IOException {
        evalMemory.setVersion(VERSION_NUMBER);
        evalMemory.setType("de.rcenvironment.evaluationmemory");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream memoryFileOutputStream = new FileOutputStream(this.evalMemoryFile);){
            evalMemory.store(memoryFileOutputStream, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized SortedMap<String, TypedDatum> getEvaluationResult(SortedMap<String, TypedDatum> inputValues, SortedMap<String, DataType> outputs, SortedMap<String, Double> tolerances, ToleranceHandling toleranceHandling) throws IOException {
        EvaluationMemoryProperties evalMemory = this.loadEvaluationMemory();
        this.validateInputs(evalMemory, this.getEndpoints(inputValues));
        this.validateOutputs(evalMemory, outputs);
        SortedMap<String, TypedDatum> exactStoredResult = this.tryGetStoredResults(inputValues, outputs, evalMemory);
        if (exactStoredResult != null) {
            return exactStoredResult;
        }
        return this.tryGetToleratedStoredResults(inputValues, outputs.keySet(), tolerances, evalMemory, toleranceHandling);
    }

    private SortedMap<String, TypedDatum> tryGetStoredResults(SortedMap<String, TypedDatum> inputValues, SortedMap<String, DataType> outputs, Properties evalMemory) {
        String evalMemoryKey = this.createEvaluationMemoryKeyForInputValues(inputValues);
        if (evalMemory.containsKey(evalMemoryKey)) {
            String evaluationResult = evalMemory.getProperty(evalMemoryKey);
            return this.splitDeserializeAndZip(outputs.keySet(), evaluationResult);
        }
        return null;
    }

    private SortedMap<String, TypedDatum> tryGetToleratedStoredResults(SortedMap<String, TypedDatum> inputValues, Set<String> outputs, Map<String, Double> tolerances, EvaluationMemoryProperties evalMemory, ToleranceHandling toleranceHandling) {
        Predicate<SortedMap<String, TypedDatum>> isTolerated;
        Iterable<String> recordKeys;
        Set<String> inputLabels = inputValues.keySet();
        Collection<SortedMap<String, TypedDatum>> toleratedStoredInputs = this.collectToleratedInputs(inputLabels, recordKeys = evalMemory.getRecordKeys(), isTolerated = stored -> toleranceHandling.isInToleranceInterval((Map<String, TypedDatum>)inputValues, tolerances, (Map<String, TypedDatum>)stored));
        SortedMap<String, TypedDatum> mostToleratedStoredInput = toleranceHandling.pickMostToleratedInputs(toleratedStoredInputs, inputValues);
        if (mostToleratedStoredInput == null) {
            return null;
        }
        String infoMessage = String.format("Found evaluation results for values '%s' that are within tolerance intervals of actual values '%s'", mostToleratedStoredInput, inputValues);
        Logger.getLogger(this.getClass().getCanonicalName()).info(infoMessage);
        String lookupKey = this.createEvaluationMemoryKeyForInputValues(mostToleratedStoredInput);
        return this.splitDeserializeAndZip(outputs, evalMemory.getProperty(lookupKey));
    }

    private Collection<SortedMap<String, TypedDatum>> collectToleratedInputs(Set<String> inputLabels, Iterable<String> recordKeys, Predicate<SortedMap<String, TypedDatum>> isTolerated) {
        HashSet<SortedMap<String, TypedDatum>> candidateStoredInputs = new HashSet<SortedMap<String, TypedDatum>>();
        for (String inputString : recordKeys) {
            SortedMap<String, TypedDatum> potentialCandidateInput = this.splitDeserializeAndZip(inputLabels, inputString);
            if (!isTolerated.test(potentialCandidateInput)) continue;
            candidateStoredInputs.add(potentialCandidateInput);
        }
        return candidateStoredInputs;
    }

    private SortedMap<String, TypedDatum> splitDeserializeAndZip(Set<String> keySet, String inputString) {
        String[] serializedInputs = StringUtils.splitAndUnescape((String)inputString);
        TreeMap<String, TypedDatum> potentialCandidateInput = new TreeMap<String, TypedDatum>();
        int i = 0;
        for (String input : keySet) {
            potentialCandidateInput.put(input, this.typedDatumSerializer.deserialize(serializedInputs[i++]));
        }
        return potentialCandidateInput;
    }

    @Override
    public synchronized void validateEvaluationMemory(SortedMap<String, DataType> inputs, SortedMap<String, DataType> outputs) throws IOException {
        EvaluationMemoryProperties evalMemory = this.loadEvaluationMemory();
        this.validateVersionAndType(evalMemory);
        this.validateInputs(evalMemory, inputs);
        this.validateOutputs(evalMemory, outputs);
        this.validateEvaluationMemoryEntries(inputs, outputs, evalMemory);
    }

    private void addInputsDefinition(SortedMap<String, DataType> inputs, EvaluationMemoryProperties evalMemory) {
        evalMemory.setInputSpecification(this.createEndpointDefinitionEntry(inputs));
    }

    private void addOutputsDefinition(SortedMap<String, DataType> outputs, EvaluationMemoryProperties evalMemory) {
        evalMemory.setOutputSpecification(this.createEndpointDefinitionEntry(outputs));
    }

    private String createEndpointDefinitionEntry(Map<String, DataType> endpoints) {
        ArrayList<String> parts = new ArrayList<String>();
        for (Map.Entry<String, DataType> outputEntry : endpoints.entrySet()) {
            parts.add(outputEntry.getKey());
            parts.add(outputEntry.getValue().name());
        }
        return StringUtils.escapeAndConcat(parts);
    }

    private void validateEvaluationMemoryEntries(SortedMap<String, DataType> inputs, SortedMap<String, DataType> outputs, EvaluationMemoryProperties evalMemory) throws IOException {
        for (String key : evalMemory.getRecordKeys()) {
            this.validateEvaluationMemoryEntry(inputs, key);
            this.validateEvaluationMemoryEntry(outputs, evalMemory.getProperty(key));
        }
    }

    private void validateEvaluationMemoryEntry(SortedMap<String, DataType> endpoints, String evalMemoryEntry) throws IOException {
        String[] typedDatumParts = StringUtils.splitAndUnescape((String)evalMemoryEntry);
        ArrayList<TypedDatum> typedDatums = new ArrayList<TypedDatum>();
        String[] stringArray = typedDatumParts;
        int n = typedDatumParts.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            try {
                typedDatums.add(this.typedDatumSerializer.deserialize(value));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Failed to read values from evaluation memory file", e);
            }
            ++n2;
        }
        if (typedDatums.size() != endpoints.size()) {
            this.throwIOException(endpoints, typedDatums);
        }
        int i = 0;
        for (DataType dataType : endpoints.values()) {
            if (ALWAYS_VALID_OUTPUT_DATATYPES.contains(((TypedDatum)typedDatums.get(i)).getDataType())) continue;
            if (dataType != ((TypedDatum)typedDatums.get(i)).getDataType()) {
                this.throwIOException(endpoints, typedDatums);
            }
            ++i;
        }
    }

    private void throwIOException(SortedMap<String, DataType> endpoints, List<TypedDatum> tuple) throws IOException {
        throw new IOException(StringUtils.format((String)"Input/output data type(s) don't match input/output data type(s) in evaluation memory file - expected: %s actual: %s", (Object[])new Object[]{endpoints, tuple}));
    }

    private void validateVersionAndType(EvaluationMemoryProperties evalMemory) throws IOException {
        if (evalMemory.getVersion() == null) {
            throw new IOException("Version information is missing");
        }
        if (!evalMemory.getVersion().equals(VERSION_NUMBER)) {
            throw new IOException(StringUtils.format((String)"Version '%s' not supported; expected version: %s", (Object[])new Object[]{evalMemory.getVersion(), VERSION_NUMBER}));
        }
        if (evalMemory.getType() == null) {
            throw new IOException("Type information is missing");
        }
        if (!evalMemory.getType().equals("de.rcenvironment.evaluationmemory")) {
            throw new IOException(StringUtils.format((String)"Type '%s' not supported; expected type: %s", (Object[])new Object[]{evalMemory.getType(), "de.rcenvironment.evaluationmemory"}));
        }
    }

    private void validateInputs(EvaluationMemoryProperties evalMemory, Map<String, DataType> inputs) throws IOException {
        this.validateEndpoints(this.getEndpoints(evalMemory, evalMemory.getInputSpecificationKey()), inputs, true);
    }

    private void validateOutputs(EvaluationMemoryProperties evalMemory, Map<String, DataType> outputs) throws IOException {
        this.validateEndpoints(this.getEndpoints(evalMemory, evalMemory.getOutputSpecificationKey()), outputs, false);
    }

    private Map<String, DataType> getEndpoints(Properties evalMemory, String key) throws IOException {
        String endpointsEntry = evalMemory.getProperty(key);
        if (endpointsEntry == null) {
            throw new IOException(StringUtils.format((String)"'%s' definition is missing in evaluation memory file: %s (it is required to ensure correct evaluation memory handling, is written by the component, and must not be removed)", (Object[])new Object[]{key, this.evalMemoryFile}));
        }
        String[] parts = StringUtils.splitAndUnescape((String)endpointsEntry);
        HashMap<String, DataType> endpoints = new HashMap<String, DataType>();
        int i = 0;
        while (i < parts.length) {
            endpoints.put(parts[i], DataType.valueOf((String)parts[i + 1]));
            i += 2;
        }
        return endpoints;
    }

    private void validateEndpoints(Map<String, DataType> endpointsExpected, Map<String, DataType> actualEndpoints, boolean inputs) throws IOException {
        if (!this.areEndpointsEqual(endpointsExpected, actualEndpoints, inputs)) {
            throw new IOException(StringUtils.format((String)"Input(s)/output(s) don't match input(s)/output(s) in evaluation memory file - expected: %s actual: %s", (Object[])new Object[]{endpointsExpected, actualEndpoints}));
        }
    }

    private boolean areEndpointsEqual(Map<String, DataType> endpointsExpected, Map<String, DataType> actualEndpoints, boolean isInput) {
        boolean sameSize;
        boolean bl = sameSize = endpointsExpected.size() == actualEndpoints.size();
        if (!sameSize) {
            return false;
        }
        for (Map.Entry<String, DataType> endpointEntry : actualEndpoints.entrySet()) {
            boolean endpointValidByDefault;
            DataType endpointType = endpointEntry.getValue();
            boolean bl2 = endpointValidByDefault = !isInput && ALWAYS_VALID_OUTPUT_DATATYPES.contains(endpointType);
            if (endpointValidByDefault) continue;
            String endpointLabel = endpointEntry.getKey();
            boolean endpointIsExpected = endpointsExpected.containsKey(endpointLabel);
            if (!endpointIsExpected) {
                return false;
            }
            DataType expectedType = endpointsExpected.get(endpointLabel);
            boolean endpointIsEqual = expectedType.equals((Object)endpointType);
            if (endpointIsEqual) continue;
            return false;
        }
        return true;
    }

    private EvaluationMemoryProperties loadEvaluationMemory() throws IOException {
        EvaluationMemoryProperties evalMemory = new EvaluationMemoryProperties();
        if (!this.evalMemoryFile.exists()) {
            throw new FileNotFoundException("Evaluation memory file not found; either deleted or not created due to invalid file name");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream memFileInputStream = new FileInputStream(this.evalMemoryFile);){
            evalMemory.load(memFileInputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return evalMemory;
    }

    private SortedMap<String, DataType> getEndpoints(SortedMap<String, TypedDatum> endpoints) {
        TreeMap<String, DataType> endpointsWithDataType = new TreeMap<String, DataType>();
        for (Map.Entry<String, TypedDatum> endpointEntry : endpoints.entrySet()) {
            endpointsWithDataType.put(endpointEntry.getKey(), endpointEntry.getValue().getDataType());
        }
        return endpointsWithDataType;
    }

    private String createEvaluationMemoryKeyForInputValues(SortedMap<String, TypedDatum> valuesToEvaluate) {
        ArrayList<String> serializedValues = new ArrayList<String>();
        Iterator<TypedDatum> valuesIterator = valuesToEvaluate.values().iterator();
        while (valuesIterator.hasNext()) {
            serializedValues.add(this.typedDatumSerializer.serialize(valuesIterator.next()));
        }
        return StringUtils.escapeAndConcat(serializedValues);
    }

    protected void setTypedDatumSerializer(TypedDatumSerializer serializer) {
        this.typedDatumSerializer = serializer;
    }
}

