/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor.pages;

import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.integration.workflow.WorkflowConfigurationMap;
import de.rcenvironment.core.gui.integration.common.ComponentDescriptionValidator;
import de.rcenvironment.core.gui.integration.common.IntegrationHelper;
import de.rcenvironment.core.gui.integration.common.PathChooserButtonListener;
import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditor;
import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditorPage;
import de.rcenvironment.core.gui.integration.toolintegration.GroupPathChooserButtonListener;
import de.rcenvironment.core.gui.integration.workflowintegration.WorkflowIntegrationController;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.WorkflowIntegrationEditor;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.CheckButtonSelectionListener;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.TextModifyListener;
import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ComponentDescriptionPage
extends IntegrationEditorPage {
    private static final String DEFAULT_MESSAGE = "Define some information for the workflow component";
    private static final String DOTS = "...";
    private static final int DESCRIPTION_TEXT_HEIGHT_HINT = 50;
    private static final int TEXTFIELD_MIN_WIDTH = 220;
    private static final int SMALL_TEXTFIELD_MIN_WIDTH = 100;
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.integration.workflowintegration.integration_componentDescription";
    private Color colorWhite = ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_WHITE);
    private WorkflowIntegrationEditor integrationEditor;
    private Shell shell;
    private IntegrationHelper integrationHelper = new IntegrationHelper();
    private final ServiceRegistryAccess serviceRegistryAccess;
    private ToolIntegrationContextRegistry integrationContextRegistry;
    private IntegrationContext integrationContext;
    private Text wfNameText;
    private Text versionText;
    private Text iconPathText;
    private Text limitExecutionsText;
    private Text groupPathText;
    private Text documentationText;
    private Text descriptionText;
    private Text contactName;
    private Text contactEmail;
    private Button limitExecutionsButton;
    private Button copyIcon;
    private List<String> groupNames;
    private Optional<String> wfNameValidationMessage = Optional.empty();
    private Optional<String> groupValidationMessage = Optional.empty();
    private Optional<String> iconValidationMessage = Optional.empty();
    private Optional<String> documentationValidationMessage = Optional.empty();
    private Optional<String> versionVailidationMessage = Optional.empty();
    private Optional<String> parallelExecutionVailidationMessage = Optional.empty();
    private String originModel;

    public ComponentDescriptionPage(WorkflowIntegrationEditor integrationEditor, CTabFolder container) {
        super((IntegrationEditor)integrationEditor, container, "Workflow Component Description");
        this.integrationEditor = integrationEditor;
        this.shell = container.getShell();
        this.serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.integrationContextRegistry = (ToolIntegrationContextRegistry)this.serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
        this.integrationContext = this.getCurrentContext();
        this.groupNames = this.integrationHelper.updateGroupNames(this.integrationContext.getContextType());
        this.groupNames.removeIf(item -> item.equals("User Integrated Workflows"));
    }

    public void createContent(Composite container) {
        Group wfCharacteristics = new Group(container, 0);
        wfCharacteristics.setText("Workflow Component Characteristics");
        wfCharacteristics.setLayout((Layout)new GridLayout(4, false));
        GridData wfCharGridData = new GridData(1808);
        wfCharacteristics.setLayoutData((Object)wfCharGridData);
        wfCharGridData.verticalIndent = 5;
        wfCharacteristics.setBackground(this.colorWhite);
        this.createWfCharacteristics(wfCharacteristics);
        Group contactInformation = new Group(container, 0);
        contactInformation.setText("Contact Information");
        contactInformation.setLayout((Layout)new GridLayout(2, false));
        contactInformation.setLayoutData((Object)new GridData(4, 4, true, false));
        contactInformation.setBackground(this.colorWhite);
        this.createContactInformation(contactInformation);
        this.updateDescriptionSettings();
        this.updateLaunchSettings();
    }

    private void createWfCharacteristics(Group group) {
        this.wfNameText = this.createLabelAndTextfield((Composite)group, "Name*:", "toolName");
        this.wfNameText.addModifyListener(e -> {
            ComponentDescriptionValidator validator = new ComponentDescriptionValidator();
            Optional<String> currentName = this.integrationEditor.getController().getOriginalName();
            List usedToolnames = this.integrationHelper.getAlreadyIntegratedComponentNames();
            if (currentName.isPresent()) {
                usedToolnames.remove(currentName.get());
            }
            this.wfNameValidationMessage = validator.validateName(this.wfNameText, currentName, (Collection)usedToolnames);
            this.updateValidationMessage();
            this.updateSaveButtonActivation();
            if (!this.wfNameValidationMessage.isPresent()) {
                this.integrationEditor.updatePartName();
            }
        });
        this.createVersionComposite(group);
        this.groupPathText = this.createLabelAndTextfield((Composite)group, "Group path:", "groupName");
        this.groupPathText.addModifyListener(e -> {
            ComponentDescriptionValidator validator = new ComponentDescriptionValidator();
            this.groupValidationMessage = validator.validateGroupPath(this.groupPathText);
            this.updateValidationMessage();
            this.updateSaveButtonActivation();
        });
        Composite groupComposite = new Composite((Composite)group, 0);
        groupComposite.setLayout((Layout)new GridLayout(2, false));
        groupComposite.setBackground(this.colorWhite);
        Button chooseGroupButton = new Button(groupComposite, 8);
        chooseGroupButton.setText(DOTS);
        chooseGroupButton.addSelectionListener((SelectionListener)new GroupPathChooserButtonListener(this.groupNames, this.groupPathText, this.shell));
        this.createLimitExecutionComposite(group);
        this.iconPathText = this.createLabelAndTextfield((Composite)group, "Icon:", "toolIconPath");
        this.iconPathText.addModifyListener(e -> {
            ComponentDescriptionValidator validator = new ComponentDescriptionValidator();
            this.iconValidationMessage = validator.validateIcon(this.iconPathText, this.getCurrentContext(), (String)this.integrationEditor.getController().getConfigurationMap().get("toolName"));
            this.updateValidationMessage();
            this.updateSaveButtonActivation();
        });
        Composite iconPathComposite = this.createChoosePathComposite(group, this.iconPathText, new String[]{"*.jpg;*.png", "*.jpg", "*.png"});
        this.copyIcon = new Button(iconPathComposite, 32);
        this.copyIcon.setData("key", (Object)"uploadIcon");
        this.copyIcon.addSelectionListener((SelectionListener)new CheckButtonSelectionListener(this.copyIcon, this.integrationEditor, WorkflowIntegrationController.ConfigurationContext.COMMON_SETTINGS));
        Label copyIconLabel = new Label(iconPathComposite, 0);
        copyIconLabel.setText("Copy icon into configuration folder");
        copyIconLabel.setBackground(this.colorWhite);
        this.documentationText = this.createLabelAndTextfield((Composite)group, "Documentation:", "documentationFilePath");
        this.documentationText.addModifyListener(e -> {
            ComponentDescriptionValidator validator = new ComponentDescriptionValidator();
            this.documentationValidationMessage = validator.validateDoc(this.documentationText, this.getCurrentContext(), (String)this.integrationEditor.getController().getConfigurationMap().get("toolName"));
            this.updateValidationMessage();
            this.updateSaveButtonActivation();
        });
        this.createChoosePathComposite(group, this.documentationText, new String[]{"*.txt;*.pdf", "*.txt", "*.pdf"});
        Label descriptionLabel = new Label((Composite)group, 0);
        descriptionLabel.setText("Description:");
        GridData descriptionLabelData = new GridData();
        descriptionLabelData.verticalAlignment = 1;
        descriptionLabelData.horizontalAlignment = 3;
        descriptionLabel.setLayoutData((Object)descriptionLabelData);
        descriptionLabel.setBackground(this.colorWhite);
        this.descriptionText = new Text((Composite)group, 2626);
        GridData descriptionLayoutData = new GridData(1808);
        descriptionLayoutData.horizontalSpan = 3;
        descriptionLayoutData.heightHint = 50;
        this.descriptionText.setLayoutData((Object)descriptionLayoutData);
        this.descriptionText.setData("key", (Object)"toolDescription");
        this.descriptionText.addModifyListener((ModifyListener)new TextModifyListener(this.descriptionText, this.integrationEditor, WorkflowIntegrationController.ConfigurationContext.COMMON_SETTINGS));
    }

    private void createLimitExecutionComposite(Group group) {
        GridData compositeGridData = new GridData();
        compositeGridData.horizontalAlignment = 3;
        compositeGridData.grabExcessHorizontalSpace = true;
        Composite limitExecutionsComposite = new Composite((Composite)group, 0);
        GridLayout limitExecutionGridLayout = new GridLayout(3, false);
        limitExecutionsComposite.setLayout((Layout)limitExecutionGridLayout);
        limitExecutionsComposite.setLayoutData((Object)compositeGridData);
        limitExecutionsComposite.setBackground(this.colorWhite);
        this.limitExecutionsButton = new Button(limitExecutionsComposite, 131104);
        this.limitExecutionsButton.addSelectionListener((SelectionListener)new LimitExecutionButtonSelectionListener());
        this.limitExecutionsButton.setData("key", (Object)"limitInstallationInstances");
        this.limitExecutionsButton.addSelectionListener((SelectionListener)new CheckButtonSelectionListener(this.limitExecutionsButton, this.integrationEditor, WorkflowIntegrationController.ConfigurationContext.LAUNCH_SETTINGS));
        this.limitExecutionsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ComponentDescriptionPage.this.validateParallelExecution();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        Label limitExecutionLabel = new Label(limitExecutionsComposite, 0);
        limitExecutionLabel.setText("Limit parallel executions:");
        limitExecutionLabel.setBackground(this.colorWhite);
        this.limitExecutionsText = new Text(limitExecutionsComposite, 2048);
        GridData limitExecutionGridData = new GridData();
        limitExecutionGridData.widthHint = 100;
        limitExecutionGridData.horizontalAlignment = 3;
        limitExecutionGridData.grabExcessHorizontalSpace = true;
        this.limitExecutionsText.setLayoutData((Object)limitExecutionGridData);
        this.limitExecutionsText.setEnabled(false);
        this.limitExecutionsText.setData("key", (Object)"limitInstallationInstancesNumber");
        this.limitExecutionsText.addModifyListener((ModifyListener)new TextModifyListener(this.limitExecutionsText, this.integrationEditor, WorkflowIntegrationController.ConfigurationContext.LAUNCH_SETTINGS));
        this.limitExecutionsText.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(18));
        this.limitExecutionsText.addModifyListener(e -> this.validateParallelExecution());
    }

    private void createVersionComposite(Group group) {
        GridData compositeGridData = new GridData();
        compositeGridData.horizontalAlignment = 3;
        compositeGridData.grabExcessHorizontalSpace = true;
        compositeGridData.horizontalSpan = 2;
        Composite versionComposite = new Composite((Composite)group, 0);
        GridLayout versionGridLayout = new GridLayout(2, false);
        versionComposite.setLayout((Layout)versionGridLayout);
        versionComposite.setLayoutData((Object)compositeGridData);
        versionComposite.setBackground(this.colorWhite);
        Label versionLabel = new Label(versionComposite, 0);
        versionLabel.setText("Version*:");
        versionLabel.setBackground(this.colorWhite);
        GridData versionLabelGridData = new GridData();
        versionLabelGridData.horizontalAlignment = 3;
        versionLabelGridData.grabExcessHorizontalSpace = true;
        versionLabel.setLayoutData((Object)versionLabelGridData);
        this.versionText = new Text(versionComposite, 2048);
        GridData versionGridData = new GridData(768);
        versionGridData.widthHint = 100;
        versionGridData.grabExcessHorizontalSpace = false;
        this.versionText.setLayoutData((Object)versionGridData);
        this.versionText.setData("key", (Object)"version");
        this.versionText.addModifyListener((ModifyListener)new TextModifyListener(this.versionText, this.integrationEditor, WorkflowIntegrationController.ConfigurationContext.LAUNCH_SETTINGS));
        this.versionText.addModifyListener(e -> {
            Optional validationResult = ComponentIdRules.validateComponentVersionRules((String)this.versionText.getText());
            this.versionVailidationMessage = validationResult.isPresent() ? Optional.of(StringUtils.format((String)"The chosen version is not valid.\n %s", (Object[])new Object[]{validationResult.get()})) : Optional.empty();
            this.updateValidationMessage();
            this.updateSaveButtonActivation();
        });
    }

    private Composite createChoosePathComposite(Group group, Text text, String[] filterNames) {
        Composite iconPathComposite = new Composite((Composite)group, 0);
        iconPathComposite.setLayout((Layout)new GridLayout(3, false));
        iconPathComposite.setBackground(this.colorWhite);
        GridData iconGridData = new GridData();
        iconGridData.horizontalSpan = 2;
        iconPathComposite.setLayoutData((Object)iconGridData);
        Button choosePathButton = new Button(iconPathComposite, 8);
        choosePathButton.setText(DOTS);
        choosePathButton.addSelectionListener((SelectionListener)new PathChooserButtonListener(text, false, filterNames, this.shell));
        return iconPathComposite;
    }

    private void createContactInformation(Group group) {
        this.contactName = this.createLabelAndTextfield((Composite)group, "Name:", "toolIntegratorName");
        this.contactEmail = this.createLabelAndTextfield((Composite)group, "E-Mail:", "toolIntegratorE-Mail");
    }

    private Text createLabelAndTextfield(Composite composite, String labelText, String key) {
        Label label = new Label(composite, 0);
        label.setText(labelText);
        label.setBackground(this.colorWhite);
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 3;
        label.setLayoutData((Object)labelGridData);
        Text text = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 220;
        text.setLayoutData((Object)gridData);
        text.setData("key", (Object)key);
        text.addModifyListener((ModifyListener)new TextModifyListener(text, this.integrationEditor, WorkflowIntegrationController.ConfigurationContext.COMMON_SETTINGS));
        return text;
    }

    private void updateDescriptionSettings() {
        WorkflowConfigurationMap model = this.integrationEditor.getController().getWorkflowConfigurationModel();
        this.originModel = model.getRawConfigurationMap().toString();
        this.wfNameText.setText(model.getToolName());
        this.iconPathText.setText(model.getIconPath());
        this.groupPathText.setText(model.getGroupPath());
        this.documentationText.setText(model.getDocFilePath());
        this.descriptionText.setText(model.getToolDescription());
        this.contactName.setText(model.getIntegratorName());
        this.contactEmail.setText(model.getIntegratorEmail());
        this.copyIcon.setSelection(model.isCopyIcon());
    }

    private void updateLaunchSettings() {
        WorkflowConfigurationMap model = this.integrationEditor.getController().getWorkflowConfigurationModel();
        this.versionText.setText(model.getToolVersion());
        boolean checked = model.isLimitInstance();
        this.limitExecutionsButton.setSelection(checked);
        this.limitExecutionsText.setEnabled(checked);
        this.limitExecutionsText.setText(model.getMaxParallelCount());
    }

    private void updateValidationMessage() {
        this.setPageValid(false);
        if (this.wfNameValidationMessage.isPresent()) {
            this.setMessage(this.wfNameValidationMessage.get(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED));
        } else if (this.versionVailidationMessage.isPresent()) {
            this.setMessage(this.versionVailidationMessage.get(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED));
        } else if (this.groupValidationMessage.isPresent()) {
            this.setMessage(this.groupValidationMessage.get(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED));
        } else if (this.documentationValidationMessage.isPresent()) {
            this.setMessage(this.documentationValidationMessage.get(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED));
        } else if (this.parallelExecutionVailidationMessage.isPresent()) {
            this.setMessage(this.parallelExecutionVailidationMessage.get(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED));
        } else if (this.iconValidationMessage.isPresent()) {
            if (this.iconValidationMessage.get().equals("Icon path or file format is invalid. The default icon will be used.")) {
                this.setMessage(this.iconValidationMessage.get(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16));
                this.setPageValid(true);
            } else {
                this.setMessage(this.iconValidationMessage.get(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED));
            }
        } else {
            this.setMessage(DEFAULT_MESSAGE);
            this.setPageValid(true);
        }
    }

    private void validateParallelExecution() {
        ComponentDescriptionValidator validator = new ComponentDescriptionValidator();
        this.parallelExecutionVailidationMessage = validator.validateParallelExecution(this.limitExecutionsText, this.limitExecutionsButton);
        this.updateValidationMessage();
        this.updateSaveButtonActivation();
    }

    public IntegrationContext getCurrentContext() {
        if (this.integrationContext == null) {
            return this.integrationContextRegistry.getToolIntegrationContextByType("workflow");
        }
        return this.integrationContext;
    }

    public void update() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
    }

    public boolean hasChanges() {
        return !this.integrationEditor.getController().getConfigurationMap().toString().equals(this.originModel);
    }

    private class LimitExecutionButtonSelectionListener
    implements SelectionListener {
        private LimitExecutionButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent evt) {
            if (evt.getSource() instanceof Button) {
                ComponentDescriptionPage.this.limitExecutionsText.setEnabled(((Button)evt.getSource()).getSelection());
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }
}

