/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.parts;

import de.rcenvironment.core.component.model.spi.PropertiesChangeSupport;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.gui.workflow.editor.properties.LabelPropertySource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class WorkflowLabelPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    private static final int MINUS_ONE = -1;
    private static final int TWELVE = 12;
    private Font headerFont = null;
    private Font mainFont = null;
    private Color headerTextColor = null;
    private Color mainTextColor = null;
    private Color labelColor = null;
    private TransparentLabel containerLabel;
    private IFigure textContainer;
    private FlowPage headerFlowPage;
    private FlowPage mainFlowPage;
    private int currentHeaderTextSize = -1;
    private int currentMainTextSize = -1;

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public void performRequest(Request req) {
        if (req.getType().equals("open")) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("de.rcenvironment.rce.component.workflow.WorkflowLabelProperty".equals(prop)) {
            this.refreshVisuals();
        }
    }

    protected IFigure createFigure() {
        this.containerLabel = new TransparentLabel((WorkflowLabel)this.getModel());
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        gridLayout.numColumns = 1;
        this.containerLabel.setLayoutManager((LayoutManager)gridLayout);
        this.textContainer = new Figure();
        this.textContainer.setLayoutManager((LayoutManager)new GridLayout(1, false){

            public void layout(IFigure container) {
                super.layout(container);
                int availableWidth = container.getClientArea().width - this.horizontalSpacing * (this.numColumns - 1) - this.marginWidth * 2;
                if (container.getClientArea().width + 12 + 1 >= ((WorkflowLabelPart)WorkflowLabelPart.this).containerLabel.getClientArea().width) {
                    Dimension d = WorkflowLabelPart.this.mainFlowPage.getPreferredSize(-1, -1);
                    ((GridData)this.getConstraint((IFigure)((WorkflowLabelPart)WorkflowLabelPart.this).mainFlowPage)).widthHint = d.width < ((WorkflowLabelPart)WorkflowLabelPart.this).textContainer.getClientArea().width - this.horizontalSpacing * (this.numColumns - 1) - this.marginWidth * 2 ? -1 : availableWidth;
                    if (WorkflowLabelPart.this.textContainer.getChildren().contains(WorkflowLabelPart.this.headerFlowPage)) {
                        Dimension dd = WorkflowLabelPart.this.headerFlowPage.getPreferredSize(-1, -1);
                        ((GridData)this.getConstraint((IFigure)((WorkflowLabelPart)WorkflowLabelPart.this).headerFlowPage)).widthHint = dd.width < ((WorkflowLabelPart)WorkflowLabelPart.this).textContainer.getClientArea().width - this.horizontalSpacing * (this.numColumns - 1) - this.marginWidth * 2 ? -1 : availableWidth;
                    }
                } else {
                    ((GridData)this.getConstraint((IFigure)((WorkflowLabelPart)WorkflowLabelPart.this).mainFlowPage)).widthHint = -1;
                    ((GridData)this.getConstraint((IFigure)((WorkflowLabelPart)WorkflowLabelPart.this).headerFlowPage)).widthHint = -1;
                }
            }
        });
        GridData textContainerGD = new GridData();
        textContainerGD.grabExcessHorizontalSpace = true;
        textContainerGD.grabExcessVerticalSpace = true;
        textContainerGD.horizontalAlignment = 2;
        textContainerGD.verticalAlignment = 2;
        this.containerLabel.add(this.textContainer, textContainerGD);
        this.mainFlowPage = new FlowPage();
        TextFlow mainText = new TextFlow();
        mainText.setLayoutManager((LayoutManager)new ParagraphTextLayout(mainText, 1));
        this.mainFlowPage.add((IFigure)mainText);
        this.headerFlowPage = new FlowPage();
        TextFlow headerText = new TextFlow();
        headerText.setLayoutManager((LayoutManager)new ParagraphTextLayout(headerText, 1));
        this.headerFlowPage.add((IFigure)headerText);
        GridData gridDataHeader = new GridData();
        GridData gridDataMain = new GridData();
        gridDataMain.grabExcessHorizontalSpace = false;
        gridDataMain.grabExcessVerticalSpace = false;
        gridDataMain.horizontalAlignment = 4;
        this.textContainer.add((IFigure)this.headerFlowPage, (Object)gridDataHeader, 0);
        this.textContainer.add((IFigure)this.mainFlowPage, (Object)gridDataMain, 1);
        this.refreshSettings((WorkflowLabel)this.getModel());
        return this.containerLabel;
    }

    protected void refreshVisuals() {
        WorkflowLabel label = (WorkflowLabel)this.getModel();
        Point loc = new Point(label.getX(), label.getY());
        this.containerLabel.setLocation(loc);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.containerLabel, (Object)new Rectangle(loc, new Dimension(label.getWidth(), label.getHeight())));
        this.refreshSettings(label);
        this.figure.repaint();
        this.refreshSettings(label);
        this.figure.repaint();
        this.refreshSettings(label);
        this.figure.repaint();
    }

    protected void refreshSettings(WorkflowLabel label) {
        this.refreshContainerLabel(label);
        this.textContainer.revalidate();
        this.refreshMainText(label, (TextFlow)this.mainFlowPage.getChildren().get(0));
        this.refreshHeaderText(label, (TextFlow)this.headerFlowPage.getChildren().get(0));
        this.refreshPositionOfText(label);
        this.textAlignHeaderPage(label);
        this.textAlignMainPage(label);
        this.textContainer.getUpdateManager().performUpdate();
    }

    protected void refreshContainerLabel(WorkflowLabel label) {
        if (this.labelColor == null) {
            this.labelColor = new Color(null, label.getColorBackground()[0], label.getColorBackground()[1], label.getColorBackground()[2]);
        } else if (this.labelColor.getRed() != label.getColorBackground()[0] || this.labelColor.getGreen() != label.getColorBackground()[1] || this.labelColor.getBlue() != label.getColorBackground()[2]) {
            this.labelColor.dispose();
            this.labelColor = new Color(null, label.getColorBackground()[0], label.getColorBackground()[1], label.getColorBackground()[2]);
        }
        this.containerLabel.setBackgroundColor(this.labelColor);
        if (label.hasBorder()) {
            this.containerLabel.setBorder((Border)new LineBorder());
        } else {
            this.containerLabel.setBorder(null);
        }
    }

    private void refreshPositionOfText(WorkflowLabel label) {
        GridData textContainerGD = (GridData)this.containerLabel.getLayoutManager().getConstraint(this.textContainer);
        switch (label.getLabelPosition()) {
            case TOPLEFT: {
                textContainerGD.verticalAlignment = 1;
                textContainerGD.horizontalAlignment = 1;
                break;
            }
            case TOPCENTER: {
                textContainerGD.verticalAlignment = 1;
                textContainerGD.horizontalAlignment = 2;
                break;
            }
            case TOPRIGHT: {
                textContainerGD.verticalAlignment = 1;
                textContainerGD.horizontalAlignment = 3;
                break;
            }
            case CENTERLEFT: {
                textContainerGD.verticalAlignment = 2;
                textContainerGD.horizontalAlignment = 1;
                break;
            }
            case CENTER: {
                textContainerGD.verticalAlignment = 2;
                textContainerGD.horizontalAlignment = 2;
                break;
            }
            case CENTERRIGHT: {
                textContainerGD.verticalAlignment = 2;
                textContainerGD.horizontalAlignment = 3;
                break;
            }
            case BOTTOMLEFT: {
                textContainerGD.verticalAlignment = 3;
                textContainerGD.horizontalAlignment = 1;
                break;
            }
            case BOTTOMCENTER: {
                textContainerGD.verticalAlignment = 3;
                textContainerGD.horizontalAlignment = 2;
                break;
            }
            case BOTTOMRIGHT: {
                textContainerGD.verticalAlignment = 3;
                textContainerGD.horizontalAlignment = 3;
                break;
            }
            default: {
                textContainerGD.verticalAlignment = 1;
                textContainerGD.horizontalAlignment = 1;
            }
        }
    }

    private void textAlignHeaderPage(WorkflowLabel label) {
        switch (label.getHeaderAlignmentType()) {
            case LEFT: {
                this.headerFlowPage.setHorizontalAligment(1);
                ((GridData)this.textContainer.getLayoutManager().getConstraint((IFigure)this.headerFlowPage)).horizontalAlignment = 1;
                break;
            }
            case CENTER: {
                this.headerFlowPage.setHorizontalAligment(2);
                ((GridData)this.textContainer.getLayoutManager().getConstraint((IFigure)this.headerFlowPage)).horizontalAlignment = 2;
                break;
            }
            case RIGHT: {
                this.headerFlowPage.setHorizontalAligment(4);
                ((GridData)this.textContainer.getLayoutManager().getConstraint((IFigure)this.headerFlowPage)).horizontalAlignment = 3;
                break;
            }
            default: {
                this.headerFlowPage.setHorizontalAligment(1);
                ((GridData)this.textContainer.getLayoutManager().getConstraint((IFigure)this.headerFlowPage)).horizontalAlignment = 1;
            }
        }
    }

    private void textAlignMainPage(WorkflowLabel label) {
        switch (label.getTextAlignmentType()) {
            case LEFT: {
                this.mainFlowPage.setHorizontalAligment(1);
                break;
            }
            case CENTER: {
                this.mainFlowPage.setHorizontalAligment(2);
                break;
            }
            case RIGHT: {
                this.mainFlowPage.setHorizontalAligment(4);
                break;
            }
            default: {
                this.mainFlowPage.setHorizontalAligment(1);
            }
        }
    }

    protected void refreshHeaderText(WorkflowLabel label, TextFlow textFlow) {
        if (label.getHeaderText().isEmpty() && this.textContainer.getChildren().contains(this.headerFlowPage)) {
            this.textContainer.remove((IFigure)this.headerFlowPage);
            return;
        }
        if (label.getHeaderText().isEmpty()) {
            return;
        }
        if (!this.textContainer.getChildren().contains(this.headerFlowPage)) {
            this.textContainer.add((IFigure)this.headerFlowPage, 0);
        }
        textFlow.setText(label.getHeaderText());
        if (label.getHeaderTextSize() != this.currentHeaderTextSize && textFlow.getFont() != null && textFlow.getFont().getFontData().length > 0) {
            FontData[] fD = textFlow.getFont().getFontData();
            int size = label.getHeaderTextSize();
            fD[0].setHeight(size);
            this.currentHeaderTextSize = size;
            if (this.headerFont != null) {
                this.headerFont.dispose();
            }
            this.headerFont = new Font((Device)Display.getDefault(), fD[0]);
            textFlow.setFont(this.headerFont);
        }
        if (this.headerTextColor == null) {
            this.headerTextColor = new Color(null, label.getColorHeader()[0], label.getColorHeader()[1], label.getColorHeader()[2]);
        } else if (this.headerTextColor.getRed() != label.getColorHeader()[0] || this.headerTextColor.getGreen() != label.getColorHeader()[1] || this.headerTextColor.getBlue() != label.getColorHeader()[2]) {
            this.headerTextColor.dispose();
            this.headerTextColor = new Color(null, label.getColorHeader()[0], label.getColorHeader()[1], label.getColorHeader()[2]);
        }
        textFlow.setForegroundColor(this.headerTextColor);
    }

    protected void refreshMainText(WorkflowLabel label, TextFlow textFlow) {
        textFlow.setText(label.getText());
        if (label.getTextSize() != this.currentMainTextSize && textFlow.getFont() != null && textFlow.getFont().getFontData().length > 0) {
            FontData[] fD = textFlow.getFont().getFontData();
            int size = label.getTextSize();
            fD[0].setHeight(size);
            this.currentMainTextSize = size;
            if (this.mainFont != null) {
                this.mainFont.dispose();
            }
            this.mainFont = new Font((Device)Display.getDefault(), fD[0]);
            textFlow.setFont(this.mainFont);
        }
        if (this.mainTextColor == null) {
            this.mainTextColor = new Color(null, label.getColorText()[0], label.getColorText()[1], label.getColorText()[2]);
        } else if (this.mainTextColor.getRed() != label.getColorText()[0] || this.mainTextColor.getGreen() != label.getColorText()[1] || this.mainTextColor.getBlue() != label.getColorText()[2]) {
            this.mainTextColor.dispose();
            this.mainTextColor = new Color(null, label.getColorText()[0], label.getColorText()[1], label.getColorText()[2]);
        }
        textFlow.setForegroundColor(this.mainTextColor);
        textFlow.revalidate();
    }

    public void activate() {
        super.activate();
        ((PropertiesChangeSupport)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        super.deactivate();
        ((PropertiesChangeSupport)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
        if (this.mainFont != null) {
            this.mainFont.dispose();
        }
        if (this.headerFont != null) {
            this.headerFont.dispose();
        }
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySource.class) {
            return new LabelPropertySource(this.getViewer().getEditDomain().getCommandStack(), (WorkflowLabel)this.getModel());
        }
        if (type == SnapToHelper.class) {
            ArrayList<Object> helpers = new ArrayList<Object>();
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGeometry.isEnabled"))) {
                helpers.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGrid.isEnabled"))) {
                helpers.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (helpers.size() == 0) {
                return null;
            }
            return new CompoundSnapToHelper(helpers.toArray(new SnapToHelper[0]));
        }
        return super.getAdapter(type);
    }

    protected class TransparentLabel
    extends Label {
        private static final int ROUNDED_RECTANGLE_SIZE = 10;
        private final WorkflowLabel label;

        public TransparentLabel(WorkflowLabel label) {
            this.label = label;
        }

        protected void paintFigure(Graphics graphics) {
            int oldAlpha = graphics.getAlpha();
            int[] colorBackground = ((WorkflowLabel)WorkflowLabelPart.this.getModel()).getColorBackground();
            graphics.setBackgroundColor(new Color(null, colorBackground[0], colorBackground[1], colorBackground[2]));
            graphics.setAlpha(this.label.getAlpha());
            graphics.fillRoundRectangle(this.getBounds(), 10, 10);
            graphics.setAlpha(oldAlpha);
        }
    }
}

