/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.session.internal;

import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlockWithMetadata;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolConfiguration;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BoundedMessageBlockPrioritizer {
    private static final int NUM_PRIORITY_LEVELS = MessageBlockPriority.values().length;
    private static final boolean VERBOSE_LOGGING_ENABLED = DebugSettings.getVerboseLoggingEnabled((String)"uplink.flowcontrol");
    private final List<LinkedBlockingQueue<MessageBlockWithMetadata>> queuesByPriority = new ArrayList<LinkedBlockingQueue<MessageBlockWithMetadata>>(NUM_PRIORITY_LEVELS);
    private final Log log = LogFactory.getLog(this.getClass());

    public BoundedMessageBlockPrioritizer() {
        Map<MessageBlockPriority, Integer> maxMessagesPerPriority = UplinkProtocolConfiguration.getCurrent().getMaxBufferedOutgoingMessagesPerSessionAndPriority();
        MessageBlockPriority[] messageBlockPriorityArray = MessageBlockPriority.values();
        int n = messageBlockPriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageBlockPriority priority = messageBlockPriorityArray[n2];
            try {
                Integer maxMessages = Objects.requireNonNull(maxMessagesPerPriority.get(priority));
                this.queuesByPriority.add(new LinkedBlockingQueue(maxMessages));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                this.log.error((Object)("Invalid limit value for priority " + priority.name() + ": " + maxMessagesPerPriority.get(priority)));
                throw e;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitOrBlock(MessageBlockWithMetadata messageBlock, String logPrefix) throws InterruptedException {
        LinkedBlockingQueue<MessageBlockWithMetadata> queue;
        Objects.requireNonNull(messageBlock);
        messageBlock.setLocalQueueStartTime(System.currentTimeMillis());
        MessageBlockPriority priority = messageBlock.getPriority();
        LinkedBlockingQueue<MessageBlockWithMetadata> linkedBlockingQueue = queue = this.queuesByPriority.get(priority.getIndex());
        synchronized (linkedBlockingQueue) {
            if (!queue.offer(messageBlock)) {
                MessageBlockWithMetadata headElement = queue.peek();
                if (headElement != null) {
                    long waitTimeOfHeadElement = System.currentTimeMillis() - headElement.getLocalQueueStartTime();
                    if (VERBOSE_LOGGING_ENABLED) {
                        this.log.debug((Object)StringUtils.format((String)"%sStalling a message of type %s as there are already %d messages queued for priority %s; longest queue time: %d msec", (Object[])new Object[]{logPrefix, messageBlock.getType(), queue.size(), priority.name(), waitTimeOfHeadElement}));
                    }
                }
                queue.put(messageBlock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitOrFail(MessageBlockWithMetadata messageBlock, String logPrefix) throws OperationFailureException, InterruptedException {
        LinkedBlockingQueue<MessageBlockWithMetadata> queue;
        Objects.requireNonNull(messageBlock);
        messageBlock.setLocalQueueStartTime(System.currentTimeMillis());
        MessageBlockPriority priority = messageBlock.getPriority();
        LinkedBlockingQueue<MessageBlockWithMetadata> linkedBlockingQueue = queue = this.queuesByPriority.get(priority.getIndex());
        synchronized (linkedBlockingQueue) {
            MessageBlockWithMetadata headElement;
            if (!queue.offer(messageBlock) && (headElement = queue.peek()) != null) {
                long waitTimeOfHeadElement = System.currentTimeMillis() - headElement.getLocalQueueStartTime();
                throw new OperationFailureException(StringUtils.format((String)"%sFailed to submit a message of type %s for sending as there are already %d messages queued for priority %s; longest queue time: %d msec", (Object[])new Object[]{logPrefix, messageBlock.getType(), queue.size(), priority.name(), waitTimeOfHeadElement}));
            }
        }
    }

    public Optional<MessageBlockWithMetadata> takeNext() throws NoSuchElementException {
        int i = 0;
        while (i < NUM_PRIORITY_LEVELS) {
            MessageBlockWithMetadata pollResult = this.queuesByPriority.get(i).poll();
            if (pollResult != null) {
                return Optional.of(pollResult);
            }
            ++i;
        }
        return Optional.empty();
    }
}

