/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.common.impl;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.api.NodeNameResolver;
import de.rcenvironment.core.communication.common.CommonIdBase;
import de.rcenvironment.core.communication.common.IdType;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.impl.NodeIdentifierImpl;
import de.rcenvironment.core.communication.model.NodeInformationRegistry;
import de.rcenvironment.core.communication.model.internal.NodeInformationRegistryImpl;
import de.rcenvironment.core.eventlog.api.EventLog;
import de.rcenvironment.core.eventlog.api.EventLogEntry;
import de.rcenvironment.core.eventlog.api.EventType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.utils.common.DefaultTimeSource;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import de.rcenvironment.toolkit.utils.common.IdGeneratorType;
import de.rcenvironment.toolkit.utils.common.TimeSource;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;

public final class NodeIdentifierServiceImpl
implements NodeIdentifierService {
    private static final int TWO_EXTRA_BYTES_MULTIPLIER = 256;
    private static final AtomicLong sharedSequentialSessionPartIncrement = new AtomicLong();
    private final NodeInformationRegistry nodeInformationRegistry = new NodeInformationRegistryImpl();
    private final NodeNameResolver nodeNameResolver = this.nodeInformationRegistry;
    private final IdGeneratorType idGeneratorType;
    private final TimeSource timeSource = new DefaultTimeSource();
    private InstanceNodeSessionId localInstanceSessionId;

    public NodeIdentifierServiceImpl() {
        this(IdGeneratorType.SECURE);
    }

    public NodeIdentifierServiceImpl(IdGeneratorType idGeneratorPreference) {
        this.idGeneratorType = idGeneratorPreference;
    }

    @Override
    public InstanceNodeId generateInstanceNodeId() {
        String instanceIdString;
        String fullIdString = instanceIdString = this.createRandomHexString(32);
        return new NodeIdentifierImpl(instanceIdString, null, null, fullIdString, this.nodeNameResolver, IdType.INSTANCE_NODE_ID);
    }

    @Override
    public CommonIdBase parseSelectableTypeIdString(String instanceIdString, IdType targetIdType) throws IdentifierException {
        return new NodeIdentifierImpl(instanceIdString, this.nodeNameResolver, targetIdType);
    }

    @Override
    public InstanceNodeId parseInstanceNodeIdString(String input) throws IdentifierException {
        return new NodeIdentifierImpl(input, this.nodeNameResolver, IdType.INSTANCE_NODE_ID);
    }

    @Override
    public InstanceNodeSessionId parseInstanceNodeSessionIdString(String input) throws IdentifierException {
        return new NodeIdentifierImpl(input, this.nodeNameResolver, IdType.INSTANCE_NODE_SESSION_ID);
    }

    @Override
    public LogicalNodeId parseLogicalNodeIdString(String input) throws IdentifierException {
        return new NodeIdentifierImpl(input, this.nodeNameResolver, IdType.LOGICAL_NODE_ID);
    }

    @Override
    public LogicalNodeSessionId parseLogicalNodeSessionIdString(String input) throws IdentifierException {
        return new NodeIdentifierImpl(input, this.nodeNameResolver, IdType.LOGICAL_NODE_SESSION_ID);
    }

    @Override
    public InstanceNodeSessionId generateInstanceNodeSessionId(InstanceNodeId instanceId) {
        String instanceIdString = instanceId.getInstanceNodeIdString();
        String sessionIdPart = this.createTimestampHexString(10);
        String fullIdString = StringUtils.format((String)"%s::%s", (Object[])new Object[]{instanceIdString, sessionIdPart});
        return new NodeIdentifierImpl(instanceIdString, null, sessionIdPart, fullIdString, this.nodeNameResolver, IdType.INSTANCE_NODE_SESSION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultDisplayNameForLocalNode(InstanceNodeSessionId localInstanceSessionIdParam) {
        NodeIdentifierServiceImpl nodeIdentifierServiceImpl = this;
        synchronized (nodeIdentifierServiceImpl) {
            this.localInstanceSessionId = localInstanceSessionIdParam;
        }
        this.nodeInformationRegistry.associateDisplayName(localInstanceSessionIdParam, "<local instance>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associateDisplayName(InstanceNodeSessionId id, String newName) {
        if (this.nodeInformationRegistry.associateDisplayName(id, newName)) {
            EventLogEntry eventLogEntry = EventLog.newEntry((EventType)EventType.NETWORK_NODE_NAMED).set("instance_id", id.getInstanceNodeIdString()).set("session_id", id.getSessionIdPart()).set("name", newName);
            NodeIdentifierServiceImpl nodeIdentifierServiceImpl = this;
            synchronized (nodeIdentifierServiceImpl) {
                if (this.localInstanceSessionId != null && this.localInstanceSessionId.isSameInstanceNodeSessionAs(id)) {
                    eventLogEntry.set("is_local_node", "yes");
                }
            }
            EventLog.append((EventLogEntry)eventLogEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associateDisplayNameWithLogicalNode(LogicalNodeSessionId id, String newName) {
        if (this.nodeInformationRegistry.associateDisplayNameWithLogicalNode(id, newName)) {
            EventLogEntry eventLogEntry = EventLog.newEntry((EventType)EventType.NETWORK_NODE_NAMED).set("instance_id", id.getInstanceNodeIdString()).set("session_id", id.getSessionIdPart()).set("logical_sub_node_id", id.getLogicalNodePart()).set("name", newName);
            NodeIdentifierServiceImpl nodeIdentifierServiceImpl = this;
            synchronized (nodeIdentifierServiceImpl) {
                if (this.localInstanceSessionId != null && this.localInstanceSessionId.isSameInstanceNodeSessionAs(id)) {
                    eventLogEntry.set("is_local_node", "yes");
                }
            }
            EventLog.append((EventLogEntry)eventLogEntry);
        }
    }

    @Override
    public void printAllNameAssociations(PrintStream output, String introText) {
        this.nodeInformationRegistry.printAllNameAssociations(output, introText);
    }

    private String createRandomHexString(int length) {
        return IdGenerator.createRandomHexString((int)length, (IdGeneratorType)this.idGeneratorType);
    }

    private String createTimestampHexString(int totalLength) {
        long scaledTimestamp = this.timeSource.getCurrentTimeMillis() / 4L;
        if (scaledTimestamp < 0L || scaledTimestamp > 0x7FFFFFFF00L) {
            throw new IllegalStateException();
        }
        long adjustedTimestampValue = scaledTimestamp + sharedSequentialSessionPartIncrement.incrementAndGet();
        String hexString = Long.toHexString(adjustedTimestampValue);
        if (hexString.length() == totalLength) {
            return hexString;
        }
        return String.valueOf("0000000000".substring(0, totalLength - hexString.length())) + hexString;
    }
}

