/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties;

import de.rcenvironment.components.optimizer.common.MethodDescription;
import de.rcenvironment.components.optimizer.gui.properties.Messages;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MethodPropertiesDialogGenerator
extends Dialog {
    private static final String TRUE = "true";
    private static final String COMMON = "common";
    private static final String SPECIFIC = "specific";
    private static final String RESPONSES = "responses";
    private static final String SEPERATOR = "/";
    private final MethodDescription methodDescription;
    private Map<Widget, String> widgetToKeyMap;

    protected MethodPropertiesDialogGenerator(Shell parentShell, MethodDescription methodDescription) {
        super(parentShell);
        this.methodDescription = methodDescription;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(String.valueOf(Messages.algorithmProperties) + " - " + this.methodDescription.getMethodName());
        InputStream path = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/optimizer16.png");
        Image icon = new Image(null, new ImageData(path));
        shell.setImage(icon);
    }

    protected Control createDialogArea(Composite parent) {
        this.widgetToKeyMap = new HashMap<Widget, String>();
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        CTabFolder settingsTabFolder = new CTabFolder(dialogContainer, 2048);
        if (this.methodDescription != null) {
            if (this.methodDescription.getCommonSettings() != null && this.checkIfSettingsAreGUIRelevant(this.methodDescription.getCommonSettings())) {
                CTabItem commonSettingsTab = new CTabItem(settingsTabFolder, 0);
                commonSettingsTab.setText("Common Settings");
                Composite commonSettingsContainer = new Composite((Composite)settingsTabFolder, 0);
                commonSettingsContainer.setLayout((Layout)new GridLayout(2, true));
                this.createSettingsTab(this.methodDescription.getCommonSettings(), commonSettingsContainer, COMMON);
                commonSettingsTab.setControl((Control)commonSettingsContainer);
            }
            if (this.methodDescription.getSpecificSettings() != null && this.checkIfSettingsAreGUIRelevant(this.methodDescription.getSpecificSettings())) {
                CTabItem specificSettingsTab = new CTabItem(settingsTabFolder, 0);
                specificSettingsTab.setText("Algorithm Specific Settings");
                Composite specificSettingsContainer = new Composite((Composite)settingsTabFolder, 0);
                specificSettingsContainer.setLayout((Layout)new GridLayout(2, true));
                this.createSettingsTab(this.methodDescription.getSpecificSettings(), specificSettingsContainer, SPECIFIC);
                specificSettingsTab.setControl((Control)specificSettingsContainer);
            }
            if (this.methodDescription.getResponsesSettings() != null && this.checkIfSettingsAreGUIRelevant(this.methodDescription.getResponsesSettings())) {
                CTabItem responsesSettingsTab = new CTabItem(settingsTabFolder, 0);
                responsesSettingsTab.setText("Responses Settings");
                Composite responsesSettingsContainer = new Composite((Composite)settingsTabFolder, 0);
                responsesSettingsContainer.setLayout((Layout)new GridLayout(2, true));
                this.createSettingsTab(this.methodDescription.getResponsesSettings(), responsesSettingsContainer, RESPONSES);
                responsesSettingsTab.setControl((Control)responsesSettingsContainer);
            }
        }
        return dialogContainer;
    }

    private boolean checkIfSettingsAreGUIRelevant(Map<String, Map<String, String>> settings) {
        if (settings.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Map<String, String>> entry : settings.entrySet()) {
            String doNotShow = entry.getValue().get("doNotShow");
            if (doNotShow != null && !doNotShow.equals("false")) continue;
            return true;
        }
        return false;
    }

    private void createSettingsTab(Map<String, Map<String, String>> settings, Composite container, String tabIdentifier) {
        if (settings == null) {
            return;
        }
        this.createWidgets(settings, container, tabIdentifier);
        this.createRestoreDefaultsButton(container);
    }

    private void createWidgets(Map<String, Map<String, String>> settings, Composite container, String identifier) {
        String[] sortedSettings;
        String[] stringArray = sortedSettings = this.sortSettings(settings);
        int n = sortedSettings.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Map<String, String> currentSetting = settings.get(key);
            if (settings.get(key).get("doNotShow") == null || !settings.get(key).get("doNotShow").equalsIgnoreCase(TRUE)) {
                String swtWidget = settings.get(key).get("SWTWidget");
                if (swtWidget.equals("Text")) {
                    this.createTextField(container, currentSetting, String.valueOf(identifier) + SEPERATOR + key);
                } else if (swtWidget.equals("Combo")) {
                    this.createComboBox(container, currentSetting, String.valueOf(identifier) + SEPERATOR + key);
                } else if (swtWidget.equals("Check")) {
                    this.createCheckBox(container, currentSetting, String.valueOf(identifier) + SEPERATOR + key);
                }
            }
            ++n2;
        }
    }

    private String[] sortSettings(Map<String, Map<String, String>> settings) {
        String[] sortedSettings = new String[settings.keySet().size()];
        ArrayList<String> unknownOrder = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : settings.entrySet()) {
            String orderNumber = entry.getValue().get("GuiOrder");
            if (orderNumber != null) {
                int position = Integer.parseInt(orderNumber) - 1;
                if (position < sortedSettings.length && sortedSettings[position] == null) {
                    sortedSettings[position] = entry.getKey();
                    continue;
                }
                unknownOrder.add(entry.getKey());
                continue;
            }
            unknownOrder.add(entry.getKey());
        }
        block1: for (String str : unknownOrder) {
            int i = 0;
            while (i < sortedSettings.length) {
                if (sortedSettings[i] == null) {
                    sortedSettings[i] = str;
                    continue block1;
                }
                ++i;
            }
        }
        return sortedSettings;
    }

    private void createRestoreDefaultsButton(Composite container) {
        new Label(container, 0).setText("");
        Label horizontalLine = new Label(container, 258);
        GridData lineGridData = new GridData(16777992);
        horizontalLine.setLayoutData((Object)lineGridData);
        new Label(container, 0).setText("");
        Button loadDefaults = new Button(container, 8);
        loadDefaults.setImage(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.RESTORE_DEFAULT).createImage());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        loadDefaults.setLayoutData((Object)gridData);
        loadDefaults.setText(Messages.restoreDefaultAlgorithmProperties);
        loadDefaults.addSelectionListener((SelectionListener)new DefaultSelectionListener(container));
    }

    private String getValueOrDefault(Map<String, String> currentSetting) {
        String value = currentSetting.get("Value");
        if (value == null || value.equals("")) {
            value = currentSetting.get("DefaultValue");
        }
        return value;
    }

    private void createCheckBox(Composite container, Map<String, String> currentSetting, String identifier) {
        Button newCheckbox = this.createLabelAndCheckbox(container, currentSetting.get("GuiName"), this.getValueOrDefault(currentSetting));
        this.widgetToKeyMap.put((Widget)newCheckbox, identifier);
        newCheckbox.setData((Object)identifier);
        newCheckbox.addSelectionListener((SelectionListener)new SelectionChangedListener());
    }

    private void createComboBox(Composite container, Map<String, String> currentSetting, String identifier) {
        Combo newCombo = this.createLabelAndCombo(container, currentSetting.get("GuiName"), currentSetting.get("Choices"), this.getValueOrDefault(currentSetting));
        this.widgetToKeyMap.put((Widget)newCombo, identifier);
        newCombo.setData((Object)identifier);
        newCombo.addModifyListener((ModifyListener)new MethodPropertiesModifyListener());
    }

    private void createTextField(Composite container, Map<String, String> currentSetting, String identifier) {
        Text newTextfield = this.createLabelAndTextfield(container, currentSetting.get("GuiName"), currentSetting.get("dataType"), this.getValueOrDefault(currentSetting));
        newTextfield.setData((Object)identifier);
        this.widgetToKeyMap.put((Widget)newTextfield, identifier);
        newTextfield.addModifyListener((ModifyListener)new MethodPropertiesModifyListener());
    }

    private Button createLabelAndCheckbox(Composite container, String text, String value) {
        new Label(container, 0).setText(text);
        Button result = new Button(container, 32);
        result.setSelection(value.equals(TRUE));
        return result;
    }

    private Combo createLabelAndCombo(Composite container, String text, String entries, String value) {
        String[] entryData;
        new Label(container, 0).setText(text);
        Combo result = new Combo(container, 8);
        String[] stringArray = entryData = entries.split(",");
        int n = entryData.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            result.add(entry);
            ++n2;
        }
        result.select(result.indexOf(value));
        return result;
    }

    private Text createLabelAndTextfield(Composite container, String text, String dataType, String value) {
        new Label(container, 0).setText(text);
        Text result = new Text(container, 2052);
        result.setLayoutData((Object)new GridData(4, 4, true, false));
        result.setText(value);
        if (dataType.equals("Int")) {
            result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(2));
        } else if (dataType.equals("Real")) {
            result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(1));
        }
        return result;
    }

    public void validateInputs() {
        for (Map.Entry<Widget, String> entry : this.widgetToKeyMap.entrySet()) {
            String swtWidget;
            String[] identifier = entry.getValue().split(SEPERATOR);
            Map<String, String> settings = this.getSettings(identifier[0], identifier[1]);
            if (settings == null || !(swtWidget = settings.get("SWTWidget")).equals("Text") || this.validateTextField((Text)entry.getKey(), settings)) continue;
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
    }

    private Map<String, String> getSettings(String tabIdentifier, String value) {
        Map settings = null;
        if (tabIdentifier.equals(COMMON) && this.methodDescription.getCommonSettings().containsKey(value)) {
            settings = (Map)this.methodDescription.getCommonSettings().get(value);
        } else if (tabIdentifier.equals(SPECIFIC) && this.methodDescription.getSpecificSettings().containsKey(value)) {
            settings = (Map)this.methodDescription.getSpecificSettings().get(value);
        } else if (tabIdentifier.equals(RESPONSES) && this.methodDescription.getResponsesSettings().containsKey(value)) {
            settings = (Map)this.methodDescription.getResponsesSettings().get(value);
        }
        return settings;
    }

    private boolean validateTextField(Text textField, Map<String, String> settings) {
        String dataType = settings.get("dataType");
        String validation = settings.get("Validation");
        if (validation == null || validation.equals("")) {
            return true;
        }
        if (textField.getText().equals("") && validation.contains("required")) {
            return false;
        }
        if (!textField.getText().equals("")) {
            if (dataType.equalsIgnoreCase("INT")) {
                try {
                    int value = Integer.parseInt(textField.getText());
                    return this.checkValidation(value, validation);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (dataType.equalsIgnoreCase("REAL")) {
                try {
                    double value = Double.parseDouble(textField.getText());
                    return this.checkValidation(value, validation);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkValidation(double value, String validation) {
        String[] splitValidations;
        String[] stringArray = splitValidations = validation.split(",");
        int n = splitValidations.length;
        int n2 = 0;
        while (n2 < n) {
            double restriction;
            String argument = stringArray[n2];
            if (argument.contains("<=") ? value > (restriction = Double.parseDouble(argument.substring(2))) : (argument.contains(">=") ? value < (restriction = Double.parseDouble(argument.substring(2))) : (argument.contains("<") ? value >= (restriction = Double.parseDouble(argument.substring(1))) : argument.contains(">") && value <= (restriction = Double.parseDouble(argument.substring(1)))))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean checkValidation(int value, String validation) {
        return this.checkValidation((double)value, validation);
    }

    private void updatePropertiesSettings(Widget source, String value) {
        String[] identifier = this.widgetToKeyMap.get(source).split(SEPERATOR);
        if (identifier[0].equals(COMMON) && this.methodDescription.getCommonSettings().containsKey(identifier[1])) {
            ((Map)this.methodDescription.getCommonSettings().get(identifier[1])).put("Value", value);
        } else if (identifier[0].equals(SPECIFIC) && this.methodDescription.getSpecificSettings().containsKey(identifier[1])) {
            ((Map)this.methodDescription.getSpecificSettings().get(identifier[1])).put("Value", value);
        } else if (identifier[0].equals(RESPONSES) && this.methodDescription.getResponsesSettings().containsKey(identifier[1])) {
            ((Map)this.methodDescription.getResponsesSettings().get(identifier[1])).put("Value", value);
        }
    }

    private class DefaultSelectionListener
    implements SelectionListener {
        private Composite container;

        DefaultSelectionListener(Composite container) {
            this.container = container;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            Control[] controlArray = this.container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String[] identifier;
                Map settings;
                Control field = controlArray[n2];
                String settingsIdentifier = this.getSettingsIdentifer(field);
                if (settingsIdentifier != null && (settings = MethodPropertiesDialogGenerator.this.getSettings((identifier = settingsIdentifier.split(MethodPropertiesDialogGenerator.SEPERATOR))[0], identifier[1])) != null && (value = (String)settings.get("DefaultValue")) != null) {
                    if (field instanceof Text) {
                        ((Text)field).setText(value);
                    } else if (field instanceof Combo) {
                        ((Combo)field).setText(value);
                    } else if (field instanceof Button && (value.equals(MethodPropertiesDialogGenerator.TRUE) || value.equals("false"))) {
                        ((Button)field).setSelection(Boolean.parseBoolean(value));
                        MethodPropertiesDialogGenerator.this.updatePropertiesSettings((Widget)field, value);
                    }
                }
                ++n2;
            }
        }

        private String getSettingsIdentifer(Control field) {
            String key = null;
            if (field instanceof Text) {
                key = (String)((Text)field).getData();
            } else if (field instanceof Combo) {
                key = (String)((Combo)field).getData();
            } else if (field instanceof Button) {
                key = (String)((Button)field).getData();
            }
            return key;
        }
    }

    private class MethodPropertiesModifyListener
    implements ModifyListener {
        private MethodPropertiesModifyListener() {
        }

        public void modifyText(ModifyEvent arg0) {
            Widget source = (Widget)arg0.getSource();
            if (source instanceof Text) {
                MethodPropertiesDialogGenerator.this.updatePropertiesSettings(source, ((Text)source).getText());
                MethodPropertiesDialogGenerator.this.validateInputs();
            } else if (source instanceof Combo) {
                MethodPropertiesDialogGenerator.this.updatePropertiesSettings(source, ((Combo)source).getText());
            }
        }
    }

    private class SelectionChangedListener
    extends SelectionAdapter {
        private SelectionChangedListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Button source = (Button)e.getSource();
            MethodPropertiesDialogGenerator.this.updatePropertiesSettings((Widget)source, "" + source.getSelection());
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }
    }
}

