/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
implements Logger {
    private static final org.slf4j.Logger stlogger = LoggerFactory.getLogger(JSch.class);
    private final org.slf4j.Logger logger;

    public Slf4jLogger() {
        this(stlogger);
    }

    Slf4jLogger(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isEnabled(int level) {
        switch (level) {
            case 0: {
                return this.logger.isDebugEnabled();
            }
            case 1: {
                return this.logger.isInfoEnabled();
            }
            case 2: {
                return this.logger.isWarnEnabled();
            }
            case 3: 
            case 4: {
                return this.logger.isErrorEnabled();
            }
        }
        return this.logger.isTraceEnabled();
    }

    @Override
    public void log(int level, String message) {
        this.log(level, message, null);
    }

    @Override
    public void log(int level, String message, Throwable cause) {
        if (!this.isEnabled(level)) {
            return;
        }
        switch (level) {
            case 0: {
                this.logger.debug(message, cause);
                break;
            }
            case 1: {
                this.logger.info(message, cause);
                break;
            }
            case 2: {
                this.logger.warn(message, cause);
                break;
            }
            case 3: 
            case 4: {
                this.logger.error(message, cause);
                break;
            }
            default: {
                this.logger.trace(message, cause);
            }
        }
    }
}

