/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.toolintegration;

import de.rcenvironment.core.gui.integration.toolintegration.Messages;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class GroupPathChooserButtonListener
implements SelectionListener {
    private List<String> groupNames;
    private Text groupPathText;
    private Shell shell;

    public GroupPathChooserButtonListener(List<String> groupNames, Text groupPathText, Shell shell) {
        this.groupNames = groupNames;
        this.groupPathText = groupPathText;
        this.shell = shell;
    }

    public void widgetSelected(SelectionEvent arg0) {
        this.showGroupSelectionDialog();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.widgetSelected(arg0);
    }

    private void showGroupSelectionDialog() {
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(this.shell, (ILabelProvider)new LabelProvider());
        dlg.setElements(this.groupNames.toArray());
        dlg.setHelpAvailable(false);
        dlg.setMultipleSelection(false);
        dlg.setStatusLineAboveButtons(false);
        dlg.setMessage(Messages.chooseGroupDlgMessage);
        dlg.setTitle(Messages.chooseGroupDlgTitle);
        if (!this.groupPathText.getText().isEmpty() && this.groupNames.contains(this.groupPathText.getText())) {
            dlg.setInitialSelections(new Object[]{this.groupPathText.getText()});
        }
        if (dlg.open() == 0) {
            this.groupPathText.setText(dlg.getFirstResult().toString());
        }
    }
}

