/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.api.DefaultAuthorizationObjects;
import de.rcenvironment.core.component.authorization.api.ComponentAuthorizationSelector;
import de.rcenvironment.core.component.authorization.api.NamedComponentAuthorizationSelector;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.management.api.PermissionMatrixChangeListener;
import de.rcenvironment.core.gui.authorization.AssignComponentsDialog;
import de.rcenvironment.core.gui.authorization.AssignGroupsDialog;
import de.rcenvironment.core.gui.authorization.AuthorizationConstants;
import de.rcenvironment.core.gui.authorization.AuthorizationLabelProvider;
import de.rcenvironment.core.gui.authorization.ExportGroupKeyAction;
import de.rcenvironment.core.gui.authorization.ImportGroupKeyAction;
import de.rcenvironment.core.gui.authorization.ManageAuthorizationGroupsAction;
import de.rcenvironment.core.gui.authorization.PublishingType;
import de.rcenvironment.core.gui.authorization.ShowAuthorizationGroupIdAction;
import de.rcenvironment.core.gui.authorization.ToolbarFilterWidget;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.part.ViewPart;

public class ComponentPublishingView
extends ViewPart {
    private static final String FILTER_COMPONENTS_MESSAGE = "Filter components...";
    private static final String FILTER_GROUPS_MESSAGE = "Filter groups...";
    private AuthorizationGroupContentProvider authorizationGroupContentProvider;
    private AuthorizationComponentContentProvider authorizationComponentContentProvider;
    private final ServiceRegistryPublisherAccess serviceRegistryAccess;
    private final AuthorizationService authorizationService;
    private final DefaultAuthorizationObjects defaultAuthorizationObjects;
    private final LocalComponentRegistrationService localComponentRegistrationService;
    private TreeViewer groupsTreeViewer;
    private GroupsTreeViewerComparator groupsTreeViewerComparator = new GroupsTreeViewerComparator();
    private TreeViewer componentsTreeViewer;
    private ComponentsTreeViewerComparator componentsTreeViewerComparator = new ComponentsTreeViewerComparator();
    private TreeSortAction sortAscendingName;
    private TreeSortAction sortDescendingName;
    private ExpandAllAction expandAll;
    private CollapseAllAction collapseAll;
    private SelectionProviderAction groupsAssignComponentsAction;
    private Action groupsAssignGroupsAction;
    private AssignComponentsAction componentsAssignComponentsAction;
    private AssignGroupsAction componentsAssignGroupsAction;
    private Action manageGroupAction;
    private IAction importGroupKeyAction;
    private IAction groupsExportGroupKeyAction;
    private IAction componentsExportGroupKeyAction;
    private ToolbarFilterWidget toolbarFilter;
    private ShowAuthorizationGroupIdAction groupsShowIdAction;
    private ShowAuthorizationGroupIdAction componentsShowIdAction;

    public ComponentPublishingView() {
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        this.localComponentRegistrationService = (LocalComponentRegistrationService)this.serviceRegistryAccess.getService(LocalComponentRegistrationService.class);
        this.authorizationService = (AuthorizationService)this.serviceRegistryAccess.getService(AuthorizationService.class);
        this.defaultAuthorizationObjects = this.authorizationService.getDefaultAuthorizationObjects();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.initComponentTreeContentProvider();
        this.initGroupTreeContentProvider();
    }

    public void dispose() {
        this.serviceRegistryAccess.dispose();
        super.dispose();
    }

    private void initGroupTreeContentProvider() {
        this.authorizationGroupContentProvider = new AuthorizationGroupContentProvider();
    }

    private void initComponentTreeContentProvider() {
        this.authorizationComponentContentProvider = new AuthorizationComponentContentProvider();
    }

    private void registerChangeListeners() {
        this.serviceRegistryAccess.registerService(PermissionMatrixChangeListener.class, (Object)new PermissionMatrixChangeListener(){

            public void onPermissionMatrixChanged(boolean accessGroupsChanged, boolean componentSelectorsChanged, boolean assignmentsChanged) {
                Display.getDefault().asyncExec(() -> {
                    if (ComponentPublishingView.this.groupsTreeViewer.getControl().isDisposed() || ComponentPublishingView.this.componentsTreeViewer.getControl().isDisposed()) {
                        return;
                    }
                    ComponentPublishingView.this.groupsTreeViewer.refresh();
                    ComponentPublishingView.this.componentsTreeViewer.refresh();
                });
            }
        });
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        scrollComposite.setMinSize(250, 200);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        Composite scrollContent = new Composite((Composite)scrollComposite, 4);
        GridLayout contentLayout = new GridLayout(2, false);
        scrollContent.setLayout((Layout)contentLayout);
        CTabFolder arrangementTabFolder = new CTabFolder(scrollContent, 526336);
        GridData arrangementTabFolderGridData = new GridData(1808);
        arrangementTabFolder.setLayoutData((Object)arrangementTabFolderGridData);
        arrangementTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ComponentPublishingView.this.setSortActionsChecked();
                ComponentPublishingView.this.setViewerFilterAssignment();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        arrangementTabFolder.setSimple(false);
        ToolBar toolbar = new ToolBar((Composite)arrangementTabFolder, 0x800100);
        arrangementTabFolder.setTopRight((Control)toolbar);
        scrollComposite.setContent((Control)scrollContent);
        CTabItem arrangeByGroupTabItem = new CTabItem(arrangementTabFolder, 0);
        arrangeByGroupTabItem.setText("Component Assignment");
        Composite authorizationByGroupComposite = new Composite((Composite)arrangementTabFolder, 0);
        GridData authorizationGroupGridData = new GridData(1040);
        GridLayout authorizationGroupLayout = new GridLayout(2, false);
        authorizationByGroupComposite.setLayout((Layout)authorizationGroupLayout);
        authorizationByGroupComposite.setLayoutData((Object)authorizationGroupGridData);
        this.groupsTreeViewer = new TreeViewer(authorizationByGroupComposite, 526340);
        GridData groupsTreeViewerGridData = new GridData(1808);
        groupsTreeViewerGridData.verticalSpan = 3;
        this.groupsTreeViewer.getTree().setLayoutData((Object)groupsTreeViewerGridData);
        this.groupsTreeViewer.setContentProvider((IContentProvider)this.authorizationGroupContentProvider);
        this.groupsTreeViewer.setLabelProvider((IBaseLabelProvider)new AuthorizationLabelProvider());
        this.groupsTreeViewer.setInput((Object)new String[0]);
        this.groupsTreeViewer.addDoubleClickListener((IDoubleClickListener)new TreeDoubleClickListener());
        this.groupsTreeViewer.setComparator((ViewerComparator)this.groupsTreeViewerComparator);
        this.groupsAssignComponentsAction = new AssignComponentsAction((ISelectionProvider)this.groupsTreeViewer);
        this.groupsAssignGroupsAction = new AssignGroupsAction((ISelectionProvider)this.groupsTreeViewer);
        this.groupsExportGroupKeyAction = new ExportGroupKeyAction((ISelectionProvider)this.groupsTreeViewer, this.authorizationService);
        this.groupsShowIdAction = new ShowAuthorizationGroupIdAction((StructuredViewer)this.groupsTreeViewer);
        ActionContributionItem groupsAssignComponentsContribution = new ActionContributionItem((IAction)this.groupsAssignComponentsAction);
        groupsAssignComponentsContribution.fill(authorizationByGroupComposite);
        Button groupsAssignComponentsButton = (Button)groupsAssignComponentsContribution.getWidget();
        GridData groupsAssignComponentsButtonGridData = new GridData();
        groupsAssignComponentsButtonGridData.verticalAlignment = 128;
        groupsAssignComponentsButtonGridData.horizontalAlignment = 4;
        groupsAssignComponentsButton.setLayoutData((Object)groupsAssignComponentsButtonGridData);
        ActionContributionItem groupsAssignGroupsContribution = new ActionContributionItem((IAction)this.groupsAssignGroupsAction);
        groupsAssignGroupsContribution.fill(authorizationByGroupComposite);
        Button groupsAssignGroupsButton = (Button)groupsAssignGroupsContribution.getWidget();
        GridData groupsAssignGroupsButtonGridData = new GridData();
        groupsAssignGroupsButtonGridData.verticalAlignment = 128;
        groupsAssignGroupsButtonGridData.horizontalAlignment = 4;
        groupsAssignGroupsButton.setLayoutData((Object)groupsAssignGroupsButtonGridData);
        CTabItem arrangeByComponentsTabItem = new CTabItem(arrangementTabFolder, 0);
        arrangeByComponentsTabItem.setText("Group Assignment");
        Composite authorizationByComponentComposite = new Composite((Composite)arrangementTabFolder, 0);
        GridData authorizationComponentGridData = new GridData(1040);
        GridLayout authorizationComponentLayout = new GridLayout(2, false);
        authorizationByComponentComposite.setLayout((Layout)authorizationComponentLayout);
        authorizationByComponentComposite.setLayoutData((Object)authorizationComponentGridData);
        this.componentsTreeViewer = new TreeViewer(authorizationByComponentComposite, 526340);
        GridData componentsTreeViewerGridData = new GridData(1808);
        componentsTreeViewerGridData.verticalSpan = 3;
        this.componentsTreeViewer.getTree().setLayoutData((Object)componentsTreeViewerGridData);
        this.componentsTreeViewer.setContentProvider((IContentProvider)this.authorizationComponentContentProvider);
        this.componentsTreeViewer.setLabelProvider((IBaseLabelProvider)new AuthorizationLabelProvider());
        this.componentsTreeViewer.setInput((Object)new String[0]);
        this.componentsTreeViewer.addDoubleClickListener((IDoubleClickListener)new TreeDoubleClickListener());
        this.componentsTreeViewer.setComparator((ViewerComparator)this.componentsTreeViewerComparator);
        this.componentsAssignGroupsAction = new AssignGroupsAction((ISelectionProvider)this.componentsTreeViewer);
        this.componentsAssignComponentsAction = new AssignComponentsAction((ISelectionProvider)this.componentsTreeViewer);
        this.componentsExportGroupKeyAction = new ExportGroupKeyAction((ISelectionProvider)this.componentsTreeViewer, this.authorizationService);
        this.componentsShowIdAction = new ShowAuthorizationGroupIdAction((StructuredViewer)this.componentsTreeViewer);
        ActionContributionItem componentsAssignComponentsContribution = new ActionContributionItem((IAction)this.componentsAssignComponentsAction);
        componentsAssignComponentsContribution.fill(authorizationByComponentComposite);
        Button componentsAssignComponentsButton = (Button)componentsAssignComponentsContribution.getWidget();
        GridData componentsAssignComponentsButtonGridData = new GridData();
        componentsAssignComponentsButtonGridData.verticalAlignment = 128;
        componentsAssignComponentsButtonGridData.horizontalAlignment = 4;
        componentsAssignComponentsButton.setLayoutData((Object)componentsAssignComponentsButtonGridData);
        ActionContributionItem componentsAssignGroupsContribution = new ActionContributionItem((IAction)this.componentsAssignGroupsAction);
        componentsAssignGroupsContribution.fill(authorizationByComponentComposite);
        Button componentsAssignGroupsButton = (Button)componentsAssignGroupsContribution.getWidget();
        GridData componentsAssignGroupsButtonGridData = new GridData();
        componentsAssignGroupsButtonGridData.verticalAlignment = 128;
        componentsAssignGroupsButtonGridData.horizontalAlignment = 4;
        componentsAssignGroupsButton.setLayoutData((Object)componentsAssignGroupsButtonGridData);
        this.makeActions();
        GridData manageGroupsButtonGridData = new GridData();
        manageGroupsButtonGridData.verticalAlignment = 1024;
        ActionContributionItem groupsManageGroupsContribution = new ActionContributionItem((IAction)this.manageGroupAction);
        groupsManageGroupsContribution.fill(authorizationByGroupComposite);
        Button groupsManageGroupsButton = (Button)groupsManageGroupsContribution.getWidget();
        groupsManageGroupsButton.setLayoutData((Object)manageGroupsButtonGridData);
        ActionContributionItem componentsManageGroupsContribution = new ActionContributionItem((IAction)this.manageGroupAction);
        componentsManageGroupsContribution.fill(authorizationByComponentComposite);
        Button componentsManageGroupsButton = (Button)componentsManageGroupsContribution.getWidget();
        componentsManageGroupsButton.setLayoutData((Object)manageGroupsButtonGridData);
        arrangeByGroupTabItem.setControl((Control)authorizationByGroupComposite);
        arrangeByComponentsTabItem.setControl((Control)authorizationByComponentComposite);
        arrangementTabFolder.setSelection(arrangeByGroupTabItem);
        this.fillLocalToolBar(toolbar);
        this.hookContextMenus();
        this.registerChangeListeners();
    }

    protected void setViewerFilterAssignment() {
        if (this.groupsTreeViewer.getTree().isVisible()) {
            this.toolbarFilter.setViewer((StructuredViewer)this.groupsTreeViewer);
            this.toolbarFilter.setMessage(FILTER_GROUPS_MESSAGE);
            this.groupsTreeViewer.resetFilters();
            this.groupsTreeViewer.getTree().setFocus();
            Tree tree = this.groupsTreeViewer.getTree();
            if (tree.getItemCount() > 0 && tree.getSelectionCount() == 0) {
                tree.setSelection(tree.getItem(0));
                tree.notifyListeners(13, new Event());
            }
        } else if (this.componentsTreeViewer.getTree().isVisible()) {
            this.toolbarFilter.setViewer((StructuredViewer)this.componentsTreeViewer);
            this.toolbarFilter.setMessage(FILTER_COMPONENTS_MESSAGE);
            this.componentsTreeViewer.resetFilters();
            Tree tree = this.componentsTreeViewer.getTree();
            if (tree.getItemCount() > 0 && tree.getSelectionCount() == 0) {
                tree.setSelection(tree.getItem(0));
                tree.notifyListeners(13, new Event());
            }
            this.componentsTreeViewer.getTree().setFocus();
        }
    }

    private void makeActions() {
        this.sortAscendingName = new TreeSortAction(1);
        this.sortAscendingName.setImageDescriptor(AuthorizationConstants.SORT_ASC);
        this.sortAscendingName.setText("Sort alphabetically ascending");
        this.sortDescendingName = new TreeSortAction(-1);
        this.sortDescendingName.setImageDescriptor(AuthorizationConstants.SORT_DESC);
        this.sortDescendingName.setText("Sort alphabetically descending");
        this.expandAll = new ExpandAllAction();
        this.expandAll.setImageDescriptor(AuthorizationConstants.EXPAND_ALL_ICON);
        this.expandAll.setText("Expand all");
        this.collapseAll = new CollapseAllAction();
        this.collapseAll.setImageDescriptor(AuthorizationConstants.COLLAPSE_ALL_ICON);
        this.collapseAll.setText("Collapse all");
        this.manageGroupAction = new ManageAuthorizationGroupsAction();
        this.importGroupKeyAction = new ImportGroupKeyAction(this.authorizationService);
    }

    private void fillLocalToolBar(ToolBar toolbar) {
        this.toolbarFilter = new ToolbarFilterWidget((StructuredViewer)this.groupsTreeViewer, FILTER_GROUPS_MESSAGE);
        this.toolbarFilter.fill(toolbar, 0);
        new ActionContributionItem((IAction)this.sortAscendingName).fill(toolbar, 1);
        new ActionContributionItem((IAction)this.sortDescendingName).fill(toolbar, 2);
        new ActionContributionItem((IAction)this.expandAll).fill(toolbar, 3);
        new ActionContributionItem((IAction)this.collapseAll).fill(toolbar, 4);
    }

    private void hookContextMenus() {
        MenuManager groupsMenuManager = new MenuManager();
        groupsMenuManager.setRemoveAllWhenShown(true);
        groupsMenuManager.addMenuListener(this::fillGroupsContextMenu);
        Menu groupsTreeMenu = groupsMenuManager.createContextMenu(this.groupsTreeViewer.getControl());
        this.groupsTreeViewer.getControl().setMenu(groupsTreeMenu);
        this.getSite().registerContextMenu(groupsMenuManager, (ISelectionProvider)this.groupsTreeViewer);
        MenuManager componentsMenuManager = new MenuManager();
        componentsMenuManager.setRemoveAllWhenShown(true);
        componentsMenuManager.addMenuListener(this::fillComponentsContextMenu);
        Menu componentsTreeMenu = componentsMenuManager.createContextMenu(this.componentsTreeViewer.getControl());
        this.componentsTreeViewer.getControl().setMenu(componentsTreeMenu);
        this.getSite().registerContextMenu(componentsMenuManager, (ISelectionProvider)this.componentsTreeViewer);
    }

    protected void fillComponentsContextMenu(IMenuManager manager) {
        this.fillContextMenu(manager);
        manager.add((IAction)this.componentsShowIdAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.componentsAssignComponentsAction);
        manager.add((IAction)this.componentsAssignGroupsAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.importGroupKeyAction);
        manager.add(this.componentsExportGroupKeyAction);
    }

    protected void fillGroupsContextMenu(IMenuManager manager) {
        this.fillContextMenu(manager);
        manager.add((IAction)this.groupsShowIdAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.groupsAssignComponentsAction);
        manager.add((IAction)this.groupsAssignGroupsAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.importGroupKeyAction);
        manager.add(this.groupsExportGroupKeyAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.sortAscendingName);
        manager.add((IAction)this.sortDescendingName);
        manager.add((IAction)this.expandAll);
        manager.add((IAction)this.collapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.manageGroupAction);
    }

    public void setFocus() {
        this.groupsTreeViewer.getTree().setFocus();
    }

    private void setSortActionsChecked() {
        if (this.componentsTreeViewer.getControl().isVisible()) {
            this.sortAscendingName.setChecked(this.componentsTreeViewerComparator.getDirection() == 1);
            this.sortDescendingName.setChecked(this.componentsTreeViewerComparator.getDirection() == -1);
        }
        if (this.groupsTreeViewer.getControl().isVisible()) {
            this.sortAscendingName.setChecked(this.groupsTreeViewerComparator.getDirection() == 1);
            this.sortDescendingName.setChecked(this.groupsTreeViewerComparator.getDirection() == -1);
        }
    }

    private final class AssignComponentsAction
    extends SelectionProviderAction {
        private AssignComponentsAction(ISelectionProvider provider) {
            super(provider, "Assign Components...");
            this.setEnabled(false);
        }

        public void run() {
            IStructuredSelection selection = this.getStructuredSelection();
            TreeMap<NamedComponentAuthorizationSelector, Boolean> componentToStateMapping = new TreeMap<NamedComponentAuthorizationSelector, Boolean>();
            if (selection.isEmpty() || !(selection.getFirstElement() instanceof AuthorizationAccessGroup)) {
                return;
            }
            AuthorizationAccessGroup selectedGroupObject = (AuthorizationAccessGroup)selection.getFirstElement();
            List components = ComponentPublishingView.this.localComponentRegistrationService.listAuthorizationSelectorsForRemotableComponentsIncludingOrphans();
            for (NamedComponentAuthorizationSelector component : components) {
                AuthorizationPermissionSet permissionSet = ComponentPublishingView.this.localComponentRegistrationService.getComponentPermissionSet((ComponentAuthorizationSelector)component, true);
                if (permissionSet.isPublic() && !ComponentPublishingView.this.authorizationService.isPublicAccessGroup(selectedGroupObject)) continue;
                componentToStateMapping.put(component, permissionSet.includesAccessGroup(selectedGroupObject));
            }
            Display display = Display.getDefault();
            Shell shell = display.getActiveShell();
            AssignComponentsDialog assignComponentsDialog = new AssignComponentsDialog(shell, ComponentPublishingView.this.authorizationService, componentToStateMapping, selectedGroupObject.getDisplayName());
            int id = assignComponentsDialog.open();
            if (id == 0) {
                Map<NamedComponentAuthorizationSelector, Boolean> resultingComponentToStateMapping = assignComponentsDialog.getComponentToStateMapping();
                for (Map.Entry<NamedComponentAuthorizationSelector, Boolean> e : resultingComponentToStateMapping.entrySet()) {
                    NamedComponentAuthorizationSelector componentSelector = e.getKey();
                    ComponentPublishingView.this.localComponentRegistrationService.setComponentPermissionState((ComponentAuthorizationSelector)componentSelector, selectedGroupObject, e.getValue().booleanValue());
                }
                ComponentPublishingView.this.groupsTreeViewer.setExpandedState((Object)selectedGroupObject, true);
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            Object obj = selection.getFirstElement();
            if (selection.size() == 1 && obj instanceof AuthorizationAccessGroup) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private final class AssignGroupsAction
    extends SelectionProviderAction {
        private AssignGroupsAction(ISelectionProvider provider) {
            super(provider, "Assign Groups...");
            this.setEnabled(false);
        }

        public void run() {
            IStructuredSelection selection = this.getStructuredSelection();
            HashMap<AuthorizationAccessGroup, Boolean> groupToStateMapping = new HashMap<AuthorizationAccessGroup, Boolean>();
            List groups = ComponentPublishingView.this.localComponentRegistrationService.listAvailableAuthorizationAccessGroups();
            if (selection.isEmpty() || !(selection.getFirstElement() instanceof NamedComponentAuthorizationSelector)) {
                return;
            }
            NamedComponentAuthorizationSelector selectedComponentObject = (NamedComponentAuthorizationSelector)selection.getFirstElement();
            AuthorizationPermissionSet authorizationPermissionSet = ComponentPublishingView.this.localComponentRegistrationService.getComponentPermissionSet((ComponentAuthorizationSelector)selectedComponentObject, true);
            for (AuthorizationAccessGroup group : groups) {
                if (ComponentPublishingView.this.authorizationService.isPublicAccessGroup(group)) continue;
                groupToStateMapping.put(group, authorizationPermissionSet.includesAccessGroup(group));
            }
            Shell shell = Display.getDefault().getActiveShell();
            AssignGroupsDialog assignGroupsDialog = new AssignGroupsDialog(shell, groupToStateMapping, authorizationPermissionSet, selectedComponentObject.getDisplayName());
            if (assignGroupsDialog.open() == 0) {
                AuthorizationPermissionSet newPermissionSet;
                PublishingType type = assignGroupsDialog.getType();
                if (type == PublishingType.CUSTOM) {
                    ArrayList<AuthorizationAccessGroup> newAuthorizationGroups = new ArrayList<AuthorizationAccessGroup>();
                    for (AuthorizationAccessGroup group : groups) {
                        if (!groupToStateMapping.keySet().contains(group) || !((Boolean)groupToStateMapping.get(group)).booleanValue()) continue;
                        newAuthorizationGroups.add(group);
                    }
                    newPermissionSet = ComponentPublishingView.this.authorizationService.buildPermissionSet(newAuthorizationGroups);
                } else if (type == PublishingType.LOCAL) {
                    newPermissionSet = ComponentPublishingView.this.defaultAuthorizationObjects.permissionSetLocalOnly();
                } else if (type == PublishingType.PUBLIC) {
                    newPermissionSet = ComponentPublishingView.this.defaultAuthorizationObjects.permissionSetPublicInLocalNetwork();
                } else {
                    throw new IllegalStateException();
                }
                ComponentPublishingView.this.localComponentRegistrationService.setComponentPermissions((ComponentAuthorizationSelector)selectedComponentObject, newPermissionSet);
                ComponentPublishingView.this.componentsTreeViewer.setExpandedState((Object)selectedComponentObject, true);
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            Object obj = selection.getFirstElement();
            if (selection.size() == 1 && obj instanceof NamedComponentAuthorizationSelector) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class AuthorizationComponentContentProvider
    implements ITreeContentProvider {
        private AuthorizationComponentContentProvider() {
        }

        public Object[] getChildren(Object o) {
            if (!(o instanceof ComponentAuthorizationSelector)) {
                return new Object[0];
            }
            ComponentAuthorizationSelector selector = (ComponentAuthorizationSelector)o;
            Collection accessGroups = ComponentPublishingView.this.localComponentRegistrationService.getComponentPermissionSet(selector, true).getAccessGroups();
            return accessGroups.toArray();
        }

        public Object[] getElements(Object arg0) {
            List components = ComponentPublishingView.this.localComponentRegistrationService.listAuthorizationSelectorsForRemotableComponents();
            return components.toArray();
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object o) {
            if (!(o instanceof ComponentAuthorizationSelector)) {
                return false;
            }
            ComponentAuthorizationSelector selector = (ComponentAuthorizationSelector)o;
            return !ComponentPublishingView.this.localComponentRegistrationService.getComponentPermissionSet(selector, true).isLocalOnly();
        }
    }

    private class AuthorizationGroupContentProvider
    implements ITreeContentProvider {
        private AuthorizationGroupContentProvider() {
        }

        public Object[] getChildren(Object groupObject) {
            if (!(groupObject instanceof AuthorizationAccessGroup)) {
                return new Object[0];
            }
            AuthorizationAccessGroup group = (AuthorizationAccessGroup)groupObject;
            return ComponentPublishingView.this.localComponentRegistrationService.listAuthorizationSelectorsForAccessGroup(group, true).toArray();
        }

        public Object[] getElements(Object arg0) {
            ArrayList authorizationGroups = new ArrayList(ComponentPublishingView.this.authorizationService.listAccessibleGroups(true));
            Collections.sort(authorizationGroups);
            return authorizationGroups.toArray();
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object groupObject) {
            if (!(groupObject instanceof AuthorizationAccessGroup)) {
                return false;
            }
            AuthorizationAccessGroup group = (AuthorizationAccessGroup)groupObject;
            return !ComponentPublishingView.this.localComponentRegistrationService.listAuthorizationSelectorsForAccessGroup(group, true).isEmpty();
        }
    }

    private class CollapseAllAction
    extends Action {
        private CollapseAllAction() {
        }

        public void run() {
            if (ComponentPublishingView.this.componentsTreeViewer.getControl().isVisible()) {
                ComponentPublishingView.this.componentsTreeViewer.collapseAll();
            }
            if (ComponentPublishingView.this.groupsTreeViewer.getControl().isVisible()) {
                ComponentPublishingView.this.groupsTreeViewer.collapseAll();
            }
        }
    }

    class ComponentsTreeViewerComparator
    extends ViewerComparator {
        private int direction = 1;

        ComponentsTreeViewerComparator() {
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof AuthorizationAccessGroup && e2 instanceof AuthorizationAccessGroup) {
                AuthorizationAccessGroup group1 = (AuthorizationAccessGroup)e1;
                AuthorizationAccessGroup group2 = (AuthorizationAccessGroup)e2;
                return group1.compareToIgnoreCase(group2);
            }
            if (e1 instanceof NamedComponentAuthorizationSelector && e2 instanceof NamedComponentAuthorizationSelector) {
                NamedComponentAuthorizationSelector component1 = (NamedComponentAuthorizationSelector)e1;
                NamedComponentAuthorizationSelector component2 = (NamedComponentAuthorizationSelector)e2;
                int returncode = component1.compareToIgnoreCase(component2);
                if (this.direction == -1) {
                    returncode = -returncode;
                }
                return returncode;
            }
            return super.compare(viewer, e1, e2);
        }

        public int getDirection() {
            return this.direction;
        }
    }

    private class ExpandAllAction
    extends Action {
        private ExpandAllAction() {
        }

        public void run() {
            if (ComponentPublishingView.this.componentsTreeViewer.getControl().isVisible()) {
                ComponentPublishingView.this.componentsTreeViewer.expandAll();
            }
            if (ComponentPublishingView.this.groupsTreeViewer.getControl().isVisible()) {
                ComponentPublishingView.this.groupsTreeViewer.expandAll();
            }
        }
    }

    class GroupsTreeViewerComparator
    extends ViewerComparator {
        private int direction = 1;

        GroupsTreeViewerComparator() {
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof AuthorizationAccessGroup && e2 instanceof AuthorizationAccessGroup) {
                AuthorizationAccessGroup group1 = (AuthorizationAccessGroup)e1;
                AuthorizationAccessGroup group2 = (AuthorizationAccessGroup)e2;
                int returncode = group1.compareToIgnoreCase(group2);
                if (this.direction == -1) {
                    returncode = -returncode;
                }
                return returncode;
            }
            if (e1 instanceof NamedComponentAuthorizationSelector && e2 instanceof NamedComponentAuthorizationSelector) {
                NamedComponentAuthorizationSelector component1 = (NamedComponentAuthorizationSelector)e1;
                NamedComponentAuthorizationSelector component2 = (NamedComponentAuthorizationSelector)e2;
                return component1.compareToIgnoreCase(component2);
            }
            return super.compare(viewer, e1, e2);
        }

        public int getDirection() {
            return this.direction;
        }
    }

    private final class TreeDoubleClickListener
    implements IDoubleClickListener {
        private TreeDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (!(event.getViewer() instanceof TreeViewer)) {
                return;
            }
            TreeViewer sourceViewer = (TreeViewer)event.getViewer();
            IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
            Object selectedNode = thisSelection.getFirstElement();
            if (selectedNode instanceof AuthorizationAccessGroup) {
                new AssignComponentsAction((ISelectionProvider)sourceViewer).run();
            }
            if (selectedNode instanceof NamedComponentAuthorizationSelector) {
                new AssignGroupsAction((ISelectionProvider)sourceViewer).run();
            }
        }
    }

    private final class TreeSortAction
    extends Action {
        private int direction;

        protected TreeSortAction(int direction) {
            this.direction = direction;
            this.setChecked(ComponentPublishingView.this.componentsTreeViewerComparator.getDirection() == direction);
        }

        public void run() {
            if (ComponentPublishingView.this.componentsTreeViewer.getControl().isVisible()) {
                ComponentPublishingView.this.componentsTreeViewerComparator.setDirection(this.direction);
                ComponentPublishingView.this.componentsTreeViewer.refresh();
            }
            if (ComponentPublishingView.this.groupsTreeViewer.getControl().isVisible()) {
                ComponentPublishingView.this.groupsTreeViewerComparator.setDirection(this.direction);
                ComponentPublishingView.this.groupsTreeViewer.refresh();
            }
            ComponentPublishingView.this.setSortActionsChecked();
        }
    }
}

