/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;

public class ComponentStepDefinitions
extends InstanceManagementStepDefinitionBase {
    private String lastStaticInputQueried;
    private String lastStaticOutputQueried;
    private final List<Endpoint> staticInputsOfLastComponent = new LinkedList<Endpoint>();
    private final List<Endpoint> dynamicInputsOfLastComponent = new LinkedList<Endpoint>();
    private final List<Endpoint> staticOutputsOfLastComponent = new LinkedList<Endpoint>();
    private final List<Endpoint> dynamicOutputsOfLastComponent = new LinkedList<Endpoint>();

    public ComponentStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @Given(value="^adding(?: tool[s]?)? \"([^\"]+)\" to( all)?(?: instance[s]?)?(?: \"([^\"]+)\")?$")
    public void givenAddingTools(String tools, String allFlag, String instanceIds) throws Exception {
        AddToolIterator addToolIterator = new AddToolIterator(tools);
        this.iterateInstances(addToolIterator, allFlag, instanceIds);
    }

    @When(value="^removing(?: tool[s]?)? \"([^\"]+)\"(?: from)?( all)?(?: instance[s]?)?(?: \"([^\"]+)\")?$")
    public void whenRemovingTools(String tools, String allFlag, String instanceIds) throws Exception {
        RemoveToolIterator removeToolIterator = new RemoveToolIterator(tools);
        this.iterateInstances(removeToolIterator, allFlag, instanceIds);
    }

    @When(value="^integrating workflow \"([^\"]*)\" as component \"([^\"]*)\" on instance \"([^\"]*)\" with the following endpoint definitions:$")
    public void whenIntegratingWorkflow(String workflowName, String componentName, String instanceId, DataTable endpointDefinitionTable) {
        List endpointDefinitions = endpointDefinitionTable.cells(0);
        String endpointsDefinitionsString = "--expose " + endpointDefinitions.stream().map(row -> (String)row.get(0)).collect(Collectors.joining(", "));
        Path originalWfFileLocation = this.executionContext.getTestScriptLocation().toPath().resolve("workflows").resolve(workflowName);
        String command = StringUtils.format((String)"wf-integrate %s \"%s\" %s", (Object[])new Object[]{componentName, originalWfFileLocation, endpointsDefinitionsString});
        this.executeCommandOnInstance(this.resolveInstance(instanceId), command, false);
    }

    @Then(value="^instance \"([^\"]*)\" should see these components:$")
    public void thenInstanceSeesComponents(String instanceId, DataTable componentsTable) {
        ManagedInstance instance = this.resolveInstance(instanceId);
        HashMap<String, ComponentVisibilityState> visibilityMap = new HashMap<String, ComponentVisibilityState>();
        for (List criteriaRow : componentsTable.cells(0)) {
            String argNodeName = (String)criteriaRow.get(0);
            String argCompName = (String)criteriaRow.get(1);
            String expectedState = (String)criteriaRow.get(2);
            String mapKey = String.valueOf(argNodeName) + "/" + argCompName;
            ComponentVisibilityState entry = new ComponentVisibilityState(argCompName, argNodeName, expectedState, null);
            visibilityMap.put(mapKey, entry);
            this.log.debug((Object)("Parsed component expectation: " + entry));
        }
        String output = this.executeCommandOnInstance(instance, "components list --as-table", false);
        String[] stringArray = output.split("\n");
        int argCompName = stringArray.length;
        int argNodeName = 0;
        while (argNodeName < argCompName) {
            String trimmedLine;
            String line = stringArray[argNodeName];
            if (!line.startsWith("Finished executing command") && !(trimmedLine = line.trim()).isEmpty()) {
                String[] lineParts = trimmedLine.split("\\|");
                if (lineParts.length != 6) {
                    this.log.error((Object)("Ignoring output line with unexpected number of elements: " + line));
                } else {
                    String componentRefName = lineParts[2];
                    String nodeName = lineParts[0];
                    String actualState = lineParts[5];
                    String mapKey = String.valueOf(nodeName) + "/" + componentRefName;
                    ComponentVisibilityState existing = (ComponentVisibilityState)visibilityMap.get(mapKey);
                    if (existing != null) {
                        existing.setActualState(actualState);
                    }
                }
            }
            ++argNodeName;
        }
        boolean hasMismatch = false;
        StringBuilder errorLines = new StringBuilder();
        for (ComponentVisibilityState entry : visibilityMap.values()) {
            if (entry.stateMatches()) continue;
            String errorLine = "  Unexpected component state: " + entry;
            errorLines.append("\n");
            errorLines.append(errorLine);
            this.printToCommandConsole(errorLine);
            hasMismatch = true;
        }
        if (hasMismatch) {
            Assert.fail((String)("At least one component had an unexpected visibility/authorization state: " + errorLines.toString()));
        }
    }

    @Then(value="^instance \"([^\"]*)\" should see the component \"([^\"]*)\"$")
    public void instanceShouldSeeTheComponent(String instanceId, String componentId) {
        ManagedInstance instance = this.resolveInstance(instanceId);
        String command = StringUtils.format((String)"components show %s", (Object[])new Object[]{componentId});
        String output = this.executeCommandOnInstance(instance, command, false);
        String[] outputLines = output.split("\n");
        String expectedExternalIdLine = StringUtils.format((String)"External ID: %s", (Object[])new Object[]{componentId});
        Assert.assertEquals((Object)expectedExternalIdLine, (Object)outputLines[0]);
        Assert.assertTrue((boolean)outputLines[2].equals("Static Inputs:"));
        LinkedList<String> staticInputLines = new LinkedList<String>();
        int currentIndex = 3;
        String currentLine = outputLines[currentIndex];
        while (!currentLine.equals("Dynamic Inputs:")) {
            staticInputLines.add(currentLine);
            currentLine = outputLines[++currentIndex];
        }
        currentLine = outputLines[++currentIndex];
        LinkedList<String> dynamicInputLines = new LinkedList<String>();
        while (!currentLine.equals("Static Outputs:")) {
            dynamicInputLines.add(currentLine);
            currentLine = outputLines[++currentIndex];
        }
        currentLine = outputLines[++currentIndex];
        LinkedList<String> staticOutputLines = new LinkedList<String>();
        while (!currentLine.equals("Dynamic Outputs:")) {
            staticOutputLines.add(currentLine);
            currentLine = outputLines[++currentIndex];
        }
        ++currentIndex;
        LinkedList<String> dynamicOutputLines = new LinkedList<String>();
        while (currentIndex < outputLines.length) {
            currentLine = outputLines[currentIndex];
            dynamicOutputLines.add(currentLine);
            ++currentIndex;
        }
    }

    @Then(value="^that component should have a static input with name \"([^\"]*)\"$")
    public void thatComponentShouldHaveInputWithName(String inputName) {
        this.lastStaticInputQueried = inputName;
        Assert.assertTrue((boolean)this.staticInputsOfLastComponent.stream().anyMatch(endpoint -> ((Endpoint)endpoint).name.equals(inputName)));
    }

    @Then(value="^that input should have the default data type \"([^\"]*)\"$")
    public void thatInputShouldBeOfType(String expectedDefaultDataType) {
        Endpoint lastInputQueried = this.getLastStaticInputQueried();
        Assert.assertEquals((Object)expectedDefaultDataType, (Object)lastInputQueried.defaultDatatype);
    }

    @Then(value="^that input should have the input handling \"([^\"]*)\"$")
    public void thatInputShouldHaveTheInputHandling(String expectedInputHandling) {
        Endpoint lastInputQueried = this.getLastStaticInputQueried();
        Assert.assertEquals((Object)expectedInputHandling, (Object)lastInputQueried.defaultInputHandling);
    }

    @Then(value="^that input should have the execution constraint \"([^\"]*)\"$")
    public void thatInputShouldHaveTheExecutionConstraint(String expectedExecutionConstraint) {
        Endpoint lastInputQueried = this.getLastStaticInputQueried();
        Assert.assertEquals((Object)expectedExecutionConstraint, (Object)lastInputQueried.defaultExecutionConstraint);
    }

    @Then(value="^that component should have a static output with name \"([^\"]*)\"$")
    public void thatComponentShouldHaveAnOutputWithName(String outputName) {
        this.lastStaticOutputQueried = outputName;
        Assert.assertTrue((boolean)this.staticOutputsOfLastComponent.stream().anyMatch(endpoint -> ((Endpoint)endpoint).name.equals(outputName)));
    }

    @Then(value="^that output should have the default data type \"([^\"]*)\"$")
    public void thatOutputShouldBeOfType(String expectedDefaultDataType) {
        Endpoint lastOutputQueried = this.getLastStaticOutputQueried();
        Assert.assertEquals((Object)expectedDefaultDataType, (Object)lastOutputQueried.defaultDatatype);
    }

    private Endpoint getLastStaticInputQueried() {
        return this.staticInputsOfLastComponent.stream().filter(endpoint -> ((Endpoint)endpoint).name.equals(this.lastStaticInputQueried)).findAny().get();
    }

    private Endpoint getLastStaticOutputQueried() {
        return this.staticOutputsOfLastComponent.stream().filter(endpoint -> ((Endpoint)endpoint).name.equals(this.lastStaticOutputQueried)).findAny().get();
    }

    private class AddToolIterator
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private String toolList;

        AddToolIterator(String toolList) {
            this.toolList = toolList;
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws IOException {
            for (String tool : ComponentStepDefinitions.this.parseCommaSeparatedList(this.toolList)) {
                ComponentStepDefinitions.this.printToCommandConsole(StringUtils.format((String)"Adding tool %s to instance %s", (Object[])new Object[]{tool, instance}));
                File toolFile = instance.getAbsolutePathFromRelative(StringUtils.format((String)"integration/tools/%s", (Object[])new Object[]{tool}));
                if (toolFile.exists()) {
                    FileUtils.cleanDirectory((File)toolFile);
                } else {
                    toolFile.mkdir();
                }
                File testToolTemplateDir = Paths.get(ComponentStepDefinitions.this.executionContext.getTestScriptLocation().toString(), "tools", tool).toFile();
                FileUtils.copyDirectory((File)testToolTemplateDir, (File)toolFile);
            }
        }
    }

    private class ComponentVisibilityState {
        private String componentName;
        private String nodeName;
        private String expectedState;
        private String actualState;

        ComponentVisibilityState(String componentName, String nodeName, String expectedState, String actualState) {
            this.componentName = componentName;
            this.nodeName = nodeName;
            this.setExpectedState(expectedState);
            this.setActualState(actualState);
        }

        public void setExpectedState(String expectedState) {
            this.expectedState = Optional.ofNullable(expectedState).orElse("(absent)");
        }

        public void setActualState(String actualState) {
            this.actualState = Optional.ofNullable(actualState).orElse("(absent)");
        }

        public boolean stateMatches() {
            return this.expectedState.equals(this.actualState);
        }

        public String toString() {
            return StringUtils.format((String)"%s | %s | expected: %s | found: %s", (Object[])new Object[]{this.nodeName, this.componentName, this.expectedState, this.actualState});
        }
    }

    private static class Endpoint {
        private String name;
        private String defaultDatatype;
        private String possibleDatatypes;
        private String defaultInputHandling;
        private String possibleInputHandlings;
        private String defaultExecutionConstraint;
        private String possibleExecutionConstraints;

        private Endpoint() {
        }

        private static Endpoint parseComponentsShowOutputLine(String outputLine) {
            String[] outputComponents = outputLine.split("|");
            Assert.assertTrue((outputComponents.length == 3 || outputComponents.length == 7 ? 1 : 0) != 0);
            Endpoint product = new Endpoint();
            product.name = outputComponents[0];
            product.defaultDatatype = outputComponents[1];
            product.possibleDatatypes = outputComponents[2];
            if (outputComponents.length == 7) {
                product.defaultInputHandling = outputComponents[3];
                product.possibleInputHandlings = outputComponents[4];
                product.defaultExecutionConstraint = outputComponents[5];
                product.possibleExecutionConstraints = outputComponents[6];
            }
            return product;
        }
    }

    private class RemoveToolIterator
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private String toolList;

        RemoveToolIterator(String toolList) {
            this.toolList = toolList;
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws Exception {
            for (String tool : ComponentStepDefinitions.this.parseCommaSeparatedList(this.toolList)) {
                ComponentStepDefinitions.this.printToCommandConsole(StringUtils.format((String)"Removing tool %s from instance %s", (Object[])new Object[]{tool, instance}));
                File toolFile = instance.getAbsolutePathFromRelative(StringUtils.format((String)"integration/tools/%s", (Object[])new Object[]{tool}));
                if (!toolFile.exists()) continue;
                FileUtils.cleanDirectory((File)toolFile);
            }
        }
    }
}

