/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function;

import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EndpointAdapters
implements Iterable<EndpointAdapter> {
    private final List<EndpointAdapter> definitions = new LinkedList<EndpointAdapter>();

    private EndpointAdapters() {
    }

    @Override
    public Iterator<EndpointAdapter> iterator() {
        return this.definitions.iterator();
    }

    public Stream<EndpointAdapter> stream() {
        return this.definitions.stream();
    }

    public boolean containsAdapterWithInternalEndpointName(String internalEndpoint) {
        return this.stream().anyMatch(definition -> definition.getInternalName().equals(internalEndpoint));
    }

    public EndpointAdapter getByInternalEndpointName(String internalEndpointName) {
        return this.stream().filter(definition -> definition.getInternalName().equals(internalEndpointName)).findAny().get();
    }

    public EndpointAdapter getByExternalEndpointName(String externalEndpointName) {
        return this.stream().filter(definition -> definition.getExternalName().equals(externalEndpointName)).findAny().get();
    }

    public boolean containsOutputAdapters() {
        return this.stream().anyMatch(definition -> definition.isOutputAdapter());
    }

    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    /* synthetic */ EndpointAdapters(EndpointAdapters endpointAdapters) {
        this();
    }

    public static class Builder {
        private final EndpointAdapters product = new EndpointAdapters(null);

        public Builder addEndpointAdapter(EndpointAdapter def) {
            this.product.definitions.add(def);
            return this;
        }

        public EndpointAdapters build() {
            String endpointAdapterDescriptions;
            Map<String, List<EndpointAdapter>> externalInputNameCount = this.product.definitions.stream().filter(EndpointAdapter::isInputAdapter).collect(Collectors.groupingBy(EndpointAdapter::getExternalName));
            Map<String, List<EndpointAdapter>> externalOutputNameCount = this.product.definitions.stream().filter(EndpointAdapter::isOutputAdapter).collect(Collectors.groupingBy(EndpointAdapter::getExternalName));
            StringBuilder offendingEndpointAdapterDescriptions = new StringBuilder();
            for (Map.Entry<String, List<EndpointAdapter>> countEntry : externalInputNameCount.entrySet()) {
                if (countEntry.getValue().size() <= 1) continue;
                endpointAdapterDescriptions = countEntry.getValue().stream().map(EndpointAdapter::toString).collect(Collectors.joining(", ", "[", "]"));
                offendingEndpointAdapterDescriptions.append(endpointAdapterDescriptions);
            }
            for (Map.Entry<String, List<EndpointAdapter>> countEntry : externalOutputNameCount.entrySet()) {
                if (countEntry.getValue().size() <= 1) continue;
                endpointAdapterDescriptions = countEntry.getValue().stream().map(EndpointAdapter::toString).collect(Collectors.joining(", ", "[", "]"));
                offendingEndpointAdapterDescriptions.append(endpointAdapterDescriptions);
            }
            if (!offendingEndpointAdapterDescriptions.toString().equals("")) {
                String errorMessage = "The following EndpointAdapterDefinitions do not have disjoint external names: " + offendingEndpointAdapterDescriptions;
                throw new IllegalArgumentException(errorMessage);
            }
            return this.product;
        }
    }
}

