/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.monitoring.common.spi.PeriodicMonitoringDataContributor;
import de.rcenvironment.core.monitoring.system.api.LocalSystemMonitoringAggregationService;
import de.rcenvironment.core.monitoring.system.api.OperatingSystemException;
import de.rcenvironment.core.monitoring.system.api.RemotableSystemMonitoringService;
import de.rcenvironment.core.monitoring.system.api.model.FullSystemAndProcessDataSnapshot;
import de.rcenvironment.core.monitoring.system.api.model.SystemLoadInformation;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationAdapter;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationEntryPoint;
import de.rcenvironment.core.monitoring.system.internal.SystemMonitoringDataCollector;
import de.rcenvironment.core.monitoring.system.internal.SystemMonitoringDataProcessor;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.objectbindings.api.ObjectBindingsService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class SystemMonitoringAggregationServiceImpl
implements RemotableSystemMonitoringService,
LocalSystemMonitoringAggregationService {
    private static final int MAX_ITEMS = 20;
    private static final int INTERVAL = 3000;
    private SystemIntegrationAdapter adapter;
    private AsyncTaskService asyncTaskService;
    private ObjectBindingsService objectBindingsService;
    private Map<String, String> topicIdToDescriptionMap = new HashMap<String, String>();
    private SystemMonitoringDataCollector dataCollector;
    private SystemMonitoringDataProcessor dataProcessor;
    private final Log log = LogFactory.getLog(SystemMonitoringAggregationServiceImpl.class);
    private CommunicationService communicationService;

    protected void activate(BundleContext bundleContext) {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        Objects.requireNonNull(this.objectBindingsService);
        Objects.requireNonNull(this.asyncTaskService);
        this.adapter = this.getAdapter();
        Objects.requireNonNull(this.adapter);
        this.topicIdToDescriptionMap.put("basic_system_data", "Logs basic system monitoring data (total CPU and RAM usage)");
        this.objectBindingsService.addBinding(PeriodicMonitoringDataContributor.class, (Object)this.setUpPeriodicMonitoringDataContributorAdapter(), (Object)this);
        this.dataCollector = new SystemMonitoringDataCollector(this.adapter, this.asyncTaskService);
        this.dataCollector.startCollection(20, 3000);
        this.log.debug((Object)"System data collector initialized and collection started");
        this.dataProcessor = new SystemMonitoringDataProcessor(this.dataCollector.getRingBuffer(), this.adapter);
    }

    protected SystemIntegrationAdapter getAdapter() {
        return SystemIntegrationEntryPoint.getAdapter();
    }

    protected void deactivate(BundleContext bundleContext) {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.objectBindingsService.removeAllBindingsOfOwner((Object)this);
    }

    protected void bindObjectBindingsService(ObjectBindingsService newInstance) {
        this.objectBindingsService = newInstance;
    }

    protected void bindAsyncTaskService(AsyncTaskService newInstance) {
        this.asyncTaskService = newInstance;
    }

    protected void bindCommunicationService(CommunicationService newInstance) {
        this.communicationService = newInstance;
    }

    @Override
    @AllowRemoteAccess
    public synchronized FullSystemAndProcessDataSnapshot getCompleteSnapshot() throws OperatingSystemException {
        return this.createFullSnapshot();
    }

    @Override
    @AllowRemoteAccess
    public SystemLoadInformation getSystemLoadInformation(Integer maxSamples) {
        return this.dataProcessor.getSystemLoadInformation(maxSamples);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ResolvableNodeId> Map<T, SystemLoadInformation> collectSystemMonitoringDataWithTimeLimit(Set<T> nodeIds, int timeSpanMsec, int timeLimitMsec) throws InterruptedException, ExecutionException, TimeoutException {
        ConcurrentHashMap concurrentResultMap = new ConcurrentHashMap();
        int nodeCount = nodeIds.size();
        Semaphore finishCounter = new Semaphore(0);
        for (ResolvableNodeId nodeId : nodeIds) {
            this.asyncTaskService.execute("Fetch system load data from a single node", () -> {
                RemotableSystemMonitoringService remotableService = (RemotableSystemMonitoringService)this.communicationService.getRemotableService(RemotableSystemMonitoringService.class, (NetworkDestination)nodeId);
                try {
                    SystemLoadInformation systemLoadInformation = remotableService.getSystemLoadInformation(timeSpanMsec / 1000);
                    concurrentResultMap.put(nodeId, systemLoadInformation);
                }
                catch (RemoteOperationException e) {
                    this.log.warn((Object)("Error while fetching remote system load data: " + e.toString()));
                }
                finishCounter.release();
            });
        }
        this.asyncTaskService.scheduleAfterDelay("Enforce time limit while waiting for system load information responses", () -> finishCounter.release(nodeCount), (long)timeLimitMsec);
        if (!finishCounter.tryAcquire(nodeCount, timeLimitMsec * 2, TimeUnit.MILLISECONDS)) {
            this.log.warn((Object)"Fallback time limit reached while waiting for individual system load data responses");
        }
        ConcurrentHashMap concurrentHashMap = concurrentResultMap;
        synchronized (concurrentHashMap) {
            return Collections.unmodifiableMap(new HashMap(concurrentResultMap));
        }
    }

    private FullSystemAndProcessDataSnapshot createFullSnapshot() {
        this.dataCollector.resetPartialCollectionFallback();
        return this.dataProcessor.createFullSystemSnapshot();
    }

    private String createSimpleSystemMonitoringSummary() {
        FullSystemAndProcessDataSnapshot snapshot = this.createFullSnapshot();
        double nodeCpuUsage = snapshot.getNodeCPUusage();
        long ram = snapshot.getNodeRAMUsage();
        long systemRamUsage = snapshot.getNodeRAMUsage();
        return StringUtils.format((String)"System CPU usage: %.2f%%, System RAM usage: %d / %d MiB", (Object[])new Object[]{nodeCpuUsage * 100.0, systemRamUsage, ram});
    }

    private String logDetailedMonitoringData() {
        return this.createFullSnapshot().toString();
    }

    private PeriodicMonitoringDataContributor setUpPeriodicMonitoringDataContributorAdapter() {
        return new PeriodicMonitoringDataContributor(){

            @Override
            public Collection<String> getTopicIds() {
                return SystemMonitoringAggregationServiceImpl.this.topicIdToDescriptionMap.keySet();
            }

            @Override
            public String getTopicDescription(String topicId) {
                return (String)SystemMonitoringAggregationServiceImpl.this.topicIdToDescriptionMap.get(topicId);
            }

            @Override
            public void generateOutput(String topicId, List<String> collection) {
                switch (topicId) {
                    case "basic_system_data": {
                        collection.add(SystemMonitoringAggregationServiceImpl.this.createSimpleSystemMonitoringSummary());
                        break;
                    }
                    case "detailed_system_data": {
                        collection.add(SystemMonitoringAggregationServiceImpl.this.logDetailedMonitoringData());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("There is no topic id such as: " + topicId);
                    }
                }
            }
        };
    }
}

