/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.connection.internal;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListener;
import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.channel.MessageChannelState;
import de.rcenvironment.core.communication.channel.MessageChannelTrafficListener;
import de.rcenvironment.core.communication.channel.ServerContactPoint;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NodeIdentifierContextHolder;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.configuration.CommunicationIPFilterConfiguration;
import de.rcenvironment.core.communication.configuration.IPWhitelistConnectionFilter;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.messaging.MessageEndpointHandler;
import de.rcenvironment.core.communication.messaging.NetworkRequestHandler;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.NetworkResponseHandler;
import de.rcenvironment.core.communication.protocol.NetworkRequestFactory;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import de.rcenvironment.core.communication.protocol.ProtocolConstants;
import de.rcenvironment.core.communication.routing.MessageRoutingService;
import de.rcenvironment.core.communication.routing.internal.WaitForResponseBlocker;
import de.rcenvironment.core.communication.transport.spi.BrokenMessageChannelListener;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.communication.transport.spi.MessageChannelEndpointHandler;
import de.rcenvironment.core.communication.transport.spi.MessageChannelResponseHandler;
import de.rcenvironment.core.communication.transport.spi.NetworkTransportProvider;
import de.rcenvironment.core.communication.utils.MessageUtils;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.eventlog.api.EventLog;
import de.rcenvironment.core.eventlog.api.EventLogEntry;
import de.rcenvironment.core.eventlog.api.EventType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageChannelServiceImpl
implements MessageChannelService {
    private static final String SINGLE_QUOTE = "'";
    private InitialNodeInformation ownNodeInformation;
    private Map<String, NetworkTransportProvider> transportProviders;
    private AsyncOrderedCallbackManager<MessageChannelLifecycleListener> channelListeners;
    private AsyncOrderedCallbackManager<MessageChannelTrafficListener> trafficListeners;
    private AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private NodeConfigurationService configurationService;
    private NodeIdentifierService nodeIdentifierService;
    private String protocolVersion = "10.0.0";
    private RawMessageChannelEndpointHandlerImpl rawMessageChannelEndpointHandler;
    private MessageRoutingService messageRoutingService;
    private final BrokenMessageChannelListenerImpl brokenConnectionListener;
    private MessageEndpointHandler messageEndpointHandler;
    private final Map<String, MessageChannel> activeOutgoingChannels;
    private final Map<MessageChannel, MessageChannelHealthState> connectionHealthStates = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicLong healthCheckTaskCounter = new AtomicLong();
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean localNodeIsRelay;
    private final IPWhitelistConnectionFilter globalIPWhitelistFilter;
    private InstanceNodeSessionId localNodeId;
    private long requestTimeoutMsec;
    private volatile boolean shuttingDown = false;

    public MessageChannelServiceImpl() {
        this.transportProviders = new HashMap<String, NetworkTransportProvider>();
        this.channelListeners = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
        this.trafficListeners = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
        this.rawMessageChannelEndpointHandler = new RawMessageChannelEndpointHandlerImpl();
        this.brokenConnectionListener = new BrokenMessageChannelListenerImpl();
        this.activeOutgoingChannels = new HashMap<String, MessageChannel>();
        this.globalIPWhitelistFilter = new IPWhitelistConnectionFilter();
    }

    @Override
    public Future<MessageChannel> connect(final NetworkContactPoint ncp, final boolean allowDuplex) throws CommunicationException {
        if (this.shuttingDown) {
            throw new CommunicationException("Ignoring a request to connect to " + ncp + " as the network layer is shutting down");
        }
        final NetworkTransportProvider transportProvider = this.getTransportProvider(ncp.getTransportId());
        if (transportProvider == null) {
            throw new CommunicationException("Unknown transport id: " + ncp.getTransportId());
        }
        Callable<MessageChannel> connectTask = new Callable<MessageChannel>(){

            @Override
            @TaskDescription(value="Communication Layer: Connect to remote node (low-level task)")
            public MessageChannel call() throws Exception {
                MessageChannel channel;
                try {
                    channel = transportProvider.connect(ncp, MessageChannelServiceImpl.this.ownNodeInformation, MessageChannelServiceImpl.this.protocolVersion, allowDuplex, MessageChannelServiceImpl.this.rawMessageChannelEndpointHandler, MessageChannelServiceImpl.this.brokenConnectionListener);
                }
                catch (RuntimeException e) {
                    MessageChannelServiceImpl.this.logger.error((Object)("Failed to connect to " + ncp + " (local node: " + MessageChannelServiceImpl.this.ownNodeInformation.getLogDescription() + ")"), (Throwable)e);
                    throw e;
                }
                InitialNodeInformation remoteNodeInformation = channel.getRemoteNodeInformation();
                MessageChannelServiceImpl.this.mergeRemoteHandshakeInformationIntoGlobalNodeKnowledge(remoteNodeInformation);
                MessageChannelServiceImpl.this.logger.debug((Object)StringUtils.format((String)"Channel '%s' established from '%s' to '%s' using remote NCP %s", (Object[])new Object[]{channel, MessageChannelServiceImpl.this.ownNodeInformation.getLogDescription(), remoteNodeInformation.getLogDescription(), ncp}));
                return channel;
            }
        };
        return this.threadPool.submit((Callable)connectTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNewOutgoingChannel(final MessageChannel channel) {
        this.connectionHealthStates.put(channel, new MessageChannelHealthState());
        Map<String, MessageChannel> map = this.activeOutgoingChannels;
        synchronized (map) {
            this.activeOutgoingChannels.put(channel.getChannelId(), channel);
        }
        this.channelListeners.enqueueCallback((AsyncCallback)new AsyncCallback<MessageChannelLifecycleListener>(){

            public void performCallback(MessageChannelLifecycleListener listener) {
                listener.onOutgoingChannelEstablished(channel);
            }
        });
    }

    @Override
    public void closeOutgoingChannel(MessageChannel channel) {
        if (channel.close()) {
            this.unregisterClosedOrBrokenChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<MessageChannel> getAllOutgoingChannels() {
        HashSet<MessageChannel> detachedCopy;
        Map<String, MessageChannel> map = this.activeOutgoingChannels;
        synchronized (map) {
            detachedCopy = new HashSet<MessageChannel>(this.activeOutgoingChannels.values());
        }
        return detachedCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageChannel getOutgoingChannelById(String id) {
        Map<String, MessageChannel> map = this.activeOutgoingChannels;
        synchronized (map) {
            return this.activeOutgoingChannels.get(id);
        }
    }

    @Override
    public void setShutdownFlag(boolean newShuttingDownState) {
        this.shuttingDown = newShuttingDownState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAllOutgoingChannels() {
        HashSet<MessageChannel> tempCopyofSet;
        Map<String, MessageChannel> map = this.activeOutgoingChannels;
        synchronized (map) {
            tempCopyofSet = new HashSet<MessageChannel>(this.activeOutgoingChannels.values());
        }
        for (MessageChannel channel : tempCopyofSet) {
            this.closeOutgoingChannel(channel);
        }
        map = this.activeOutgoingChannels;
        synchronized (map) {
            for (MessageChannel channel : this.activeOutgoingChannels.values()) {
                this.logger.warn((Object)("Channel list not empty after closing all outgoing connections: " + channel));
            }
        }
    }

    @Override
    public void sendDirectMessageAsync(NetworkRequest request, MessageChannel channel, NetworkResponseHandler outerResponseHandler) {
        this.sendDirectMessageAsync(request, channel, outerResponseHandler, this.configurationService.getRequestTimeoutMsec());
    }

    @Override
    public void sendDirectMessageAsync(final NetworkRequest request, MessageChannel channel, final NetworkResponseHandler outerResponseHandler, int timeoutMsec) {
        if (channel == null) {
            throw new NullPointerException("Null channel passed to sendRequest(); request=" + request);
        }
        byte[] contentBytes = request.getContentBytes();
        final String messageType = request.getMessageType();
        MessageChannelResponseHandler responseHandler = new MessageChannelResponseHandler(){

            @Override
            public void onResponseAvailable(NetworkResponse response) {
                outerResponseHandler.onResponseAvailable(response);
                byte[] contentBytes = response.getContentBytes();
                if (contentBytes != null) {
                    StatsCounter.registerValue((String)"Messaging: Response payload bytes received by type", (String)messageType, (long)contentBytes.length);
                }
            }

            @Override
            public void onChannelBroken(NetworkRequest request, MessageChannel channel) {
                outerResponseHandler.onResponseAvailable(NetworkResponseFactory.generateResponseForChannelCloseWhileWaitingForResponse(request, MessageChannelServiceImpl.this.ownNodeInformation.getInstanceNodeSessionId(), null));
                MessageChannelServiceImpl.this.handleBrokenChannel(channel);
            }
        };
        if (request.accessMetaData().getSenderIdString() == null) {
            this.logger.warn((Object)("Sending message of type " + request.getMessageType() + " with empty 'sender' field"));
        }
        channel.sendRequest(request, responseHandler, timeoutMsec);
        this.trafficListeners.enqueueCallback((AsyncCallback)new AsyncCallback<MessageChannelTrafficListener>(){

            public void performCallback(MessageChannelTrafficListener listener) {
                listener.onRequestSentIntoChannel(request);
            }
        });
        if (contentBytes != null) {
            StatsCounter.registerValue((String)"Messaging: Request payload bytes sent by type", (String)messageType, (long)contentBytes.length);
        }
    }

    @Override
    public void sendDirectMessageAsync(NetworkRequest request, String channelId, NetworkResponseHandler responseHandler) {
        MessageChannel channel = this.getOutgoingChannelById(channelId);
        if (channel != null) {
            this.sendDirectMessageAsync(request, channel, responseHandler);
        } else {
            this.logger.debug((Object)("No message channel for id " + channelId + "; most likely, it has just been closed and therefore deregistered"));
            responseHandler.onResponseAvailable(NetworkResponseFactory.generateResponseForCloseOrBrokenChannelDuringRequestDelivery(request, this.localNodeId, null));
        }
    }

    @Override
    public NetworkResponse sendDirectMessageBlocking(NetworkRequest request, MessageChannel channel, int timeout) {
        WaitForResponseBlocker responseBlocker = new WaitForResponseBlocker(request, this.localNodeId);
        this.sendDirectMessageAsync(request, channel, responseBlocker, timeout);
        return responseBlocker.await(timeout);
    }

    @Override
    public NetworkResponse handleLocalForcedSerializationRPC(NetworkRequest request, InstanceNodeSessionId sourceId) {
        return this.rawMessageChannelEndpointHandler.onRawRequestReceived(request, sourceId.getInstanceNodeSessionIdString());
    }

    @Override
    public void registerRequestHandler(String messageType, NetworkRequestHandler handler) {
        this.messageEndpointHandler.registerRequestHandler(messageType, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addChannelLifecycleListener(MessageChannelLifecycleListener listener) {
        Map<String, MessageChannel> map = this.activeOutgoingChannels;
        synchronized (map) {
            final Set<MessageChannel> detachedCopy = Collections.unmodifiableSet(new HashSet<MessageChannel>(this.activeOutgoingChannels.values()));
            this.channelListeners.addListenerAndEnqueueCallback((Object)listener, (AsyncCallback)new AsyncCallback<MessageChannelLifecycleListener>(){

                public void performCallback(MessageChannelLifecycleListener listener) {
                    listener.setInitialMessageChannels(detachedCopy);
                }
            });
        }
    }

    @Override
    public void removeChannelLifecycleListener(MessageChannelLifecycleListener listener) {
        this.channelListeners.removeListener((Object)listener);
    }

    @Override
    public void addTrafficListener(MessageChannelTrafficListener listener) {
        this.trafficListeners.addListener((Object)listener);
    }

    @Override
    public ServerContactPoint startServer(NetworkContactPoint ncp) throws CommunicationException {
        NetworkTransportProvider transportProvider = this.getTransportProvider(ncp.getTransportId());
        ServerContactPoint scp = new ServerContactPoint(transportProvider, ncp, this.protocolVersion, this.rawMessageChannelEndpointHandler, this.globalIPWhitelistFilter);
        scp.start();
        return scp;
    }

    @Override
    public void loadAndApplyIPFilterConfiguration() {
        CommunicationIPFilterConfiguration ipFilterConfiguration = this.configurationService.getIPFilterConfiguration();
        if (ipFilterConfiguration.getEnabled()) {
            this.globalIPWhitelistFilter.configure(ipFilterConfiguration.getAllowedIPs());
        } else {
            this.globalIPWhitelistFilter.configure(null);
        }
    }

    @Override
    public void printIPFilterInformation(TextOutputReceiver outputReceiver) {
        Set<String> acceptedIps = this.globalIPWhitelistFilter.getAcceptedIps();
        if (acceptedIps != null) {
            outputReceiver.addOutput(StringUtils.format((String)"IP filtering is ENABLED; incoming connections are restricted to %d source IPs", (Object[])new Object[]{acceptedIps.size()}));
        } else {
            outputReceiver.addOutput(StringUtils.format((String)"IP filtering is DISABLED; all incoming connections are accepted", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerHealthCheckForAllChannels() {
        Map<String, MessageChannel> map = this.activeOutgoingChannels;
        synchronized (map) {
            for (MessageChannel channel : this.activeOutgoingChannels.values()) {
                String uniqueTaskId = StringUtils.format((String)"%s-%s", (Object[])new Object[]{channel.getChannelId(), Long.toString(this.healthCheckTaskCounter.incrementAndGet())});
                this.threadPool.execute("Communication Layer: Channel health check", uniqueTaskId, () -> {
                    try {
                        try {
                            Thread.sleep(ThreadLocalRandom.current().nextInt(7000));
                        }
                        catch (InterruptedException interruptedException) {
                            this.logger.debug((Object)"Interrupted while waiting to perform the next connection health check, skipping");
                            return;
                        }
                        this.performHealthCheckAndActOnResult(channel);
                    }
                    catch (InterruptedException e2) {
                        this.logger.debug((Object)"Interruption during channel health check", (Throwable)e2);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNetworkTransportProvider(NetworkTransportProvider provider) {
        this.logger.debug((Object)("Registering transport provider for id '" + provider.getTransportId() + SINGLE_QUOTE));
        Map<String, NetworkTransportProvider> map = this.transportProviders;
        synchronized (map) {
            String id = provider.getTransportId();
            NetworkTransportProvider previous = this.transportProviders.put(id, provider);
            if (previous != null) {
                this.transportProviders.put(id, previous);
                throw new IllegalStateException("Duplicate transport for id '" + id + SINGLE_QUOTE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkTransportProvider(NetworkTransportProvider provider) {
        this.logger.debug((Object)("Unregistering transport provider for id '" + provider.getTransportId() + SINGLE_QUOTE));
        Map<String, NetworkTransportProvider> map = this.transportProviders;
        synchronized (map) {
            NetworkTransportProvider removed = this.transportProviders.remove(provider.getTransportId());
            if (removed != provider) {
                throw new IllegalStateException("Transport to remove was not actually registered: " + provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkTransportProvider getTransportProvider(String transportId) {
        Map<String, NetworkTransportProvider> map = this.transportProviders;
        synchronized (map) {
            NetworkTransportProvider provider = this.transportProviders.get(transportId);
            if (provider == null) {
                throw new IllegalStateException("No transport registered for id " + transportId);
            }
            return provider;
        }
    }

    @Override
    public void setMessageEndpointHandler(MessageEndpointHandler newService) {
        this.messageEndpointHandler = newService;
    }

    @Override
    public void setForwardingService(MessageRoutingService newService) {
        this.messageRoutingService = newService;
    }

    @Override
    public void overrideProtocolVersion(String newVersion) {
        this.protocolVersion = newVersion;
    }

    public void bindNodeConfigurationService(NodeConfigurationService newService) {
        if (this.configurationService != null) {
            throw new IllegalStateException();
        }
        this.configurationService = newService;
        this.nodeIdentifierService = this.configurationService.getNodeIdentifierService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.ownNodeInformation = this.configurationService.getInitialNodeInformation();
        this.localNodeId = this.ownNodeInformation.getInstanceNodeSessionId();
        this.localNodeIsRelay = this.configurationService.isRelay();
        this.requestTimeoutMsec = this.configurationService.getRequestTimeoutMsec();
        Map<String, NetworkTransportProvider> map = this.transportProviders;
        synchronized (map) {
            int numTransports = this.transportProviders.size();
            this.logger.debug((Object)StringUtils.format((String)"Activated network channel service; instance log name='%s'; node id='%s'; %d registered transport providers", (Object[])new Object[]{this.ownNodeInformation.getLogDescription(), this.ownNodeInformation.getInstanceNodeSessionId(), numTransports}));
        }
        this.loadAndApplyIPFilterConfiguration();
    }

    public void deactivate() {
        this.logger.debug((Object)"Deactivating");
    }

    protected void setNodeInformation(InitialNodeInformation nodeInformation) {
        this.ownNodeInformation = nodeInformation;
    }

    public NodeIdentifierService getNodeIdentifierService() {
        return this.nodeIdentifierService;
    }

    private void mergeRemoteHandshakeInformationIntoGlobalNodeKnowledge(InitialNodeInformation remoteNodeInformation) {
        this.nodeIdentifierService.associateDisplayName(remoteNodeInformation.getInstanceNodeSessionId(), remoteNodeInformation.getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performHealthCheckAndActOnResult(MessageChannel channel) throws InterruptedException {
        MessageChannelHealthState connectionState = this.connectionHealthStates.get(channel);
        if (connectionState == null) {
            this.logger.error((Object)("Internal error: Found no health state object for channel " + channel + "; closing channel"));
            this.triggerAsyncClosingOfBrokenChannel(channel);
            return;
        }
        Object object = connectionState.healthCheckInProgressLock;
        synchronized (object) {
            if (!channel.isReadyToUse()) {
                this.logger.debug((Object)StringUtils.format((String)"Channel %s is %s; skipping scheduled health check", (Object[])new Object[]{channel.getChannelId(), channel.getState()}));
                return;
            }
            if (this.verboseLogging) {
                this.logger.debug((Object)("Performing health check on " + channel));
            }
            boolean checkSuccessful = this.performConnectionHealthCheckRequestResponse(channel);
            boolean considerChannelBroken = false;
            MessageChannelHealthState messageChannelHealthState = connectionState;
            synchronized (messageChannelHealthState) {
                if (checkSuccessful) {
                    if (connectionState.healthCheckFailureCount > 0) {
                        this.logger.debug((Object)StringUtils.format((String)"Channel %s to %s passed its health check after %d previous failures", (Object[])new Object[]{channel.getChannelId(), channel.getRemoteNodeInformation().getInstanceNodeSessionId(), connectionState.healthCheckFailureCount}));
                    }
                    connectionState.healthCheckFailureCount = 0;
                } else {
                    MessageChannelHealthState messageChannelHealthState2 = connectionState;
                    messageChannelHealthState2.healthCheckFailureCount = messageChannelHealthState2.healthCheckFailureCount + 1;
                    this.logger.debug((Object)StringUtils.format((String)"Channel %s to %s failed a health check (%d consecutive failures)", (Object[])new Object[]{channel.getChannelId(), channel.getRemoteNodeInformation().getInstanceNodeSessionId(), connectionState.healthCheckFailureCount}));
                    if (connectionState.healthCheckFailuresAtOrAboveLimit()) {
                        considerChannelBroken = true;
                    }
                }
            }
            if (considerChannelBroken) {
                this.triggerAsyncClosingOfBrokenChannel(channel);
            }
        }
    }

    private void triggerAsyncClosingOfBrokenChannel(MessageChannel channel) {
        this.threadPool.execute("Communication Layer: Close broken channel after health check failure", () -> this.handleBrokenChannel(channel));
    }

    private boolean performConnectionHealthCheckRequestResponse(MessageChannel channel) throws InterruptedException {
        String randomToken = Integer.toString(ThreadLocalRandom.current().nextInt());
        byte[] contentBytes = MessageUtils.serializeSafeObject((Serializable)((Object)randomToken));
        NetworkRequest request = NetworkRequestFactory.createNetworkRequest(contentBytes, "healthCheck", this.ownNodeInformation.getInstanceNodeSessionId(), null);
        NetworkResponse response = this.sendDirectMessageBlocking(request, channel, 10000);
        if (response.isSuccess()) {
            try {
                Serializable deserializedContent = response.getDeserializedContent();
                if (!randomToken.equals(deserializedContent)) {
                    this.logger.warn((Object)StringUtils.format((String)"Received successful response for a health check on channel '%s', but it contained unexpected content: %s", (Object[])new Object[]{channel.getChannelId(), deserializedContent}));
                    return false;
                }
            }
            catch (SerializationException e) {
                this.logger.warn((Object)StringUtils.format((String)"Received successful response for a health check on channel '%s', but there was an error deserializing its content", (Object[])new Object[]{channel.getChannelId()}), (Throwable)e);
                return false;
            }
            if (this.verboseLogging) {
                this.logger.debug((Object)("Health check on channel " + channel + " passed"));
            }
            return true;
        }
        int numericResultCode = response.getResultCode().getCode();
        Serializable deserializedContent = null;
        try {
            deserializedContent = response.getDeserializedContent();
        }
        catch (SerializationException e) {
            this.logger.warn((Object)StringUtils.format((String)"Received non-successful response for a health check on channel '%s' (error code %d), and there was also an error deserializing its content", (Object[])new Object[]{channel.getChannelId(), numericResultCode}), (Throwable)e);
        }
        if (response.getResultCode() == ProtocolConstants.ResultCode.TIMEOUT_WAITING_FOR_RESPONSE) {
            this.logger.warn((Object)StringUtils.format((String)"Received no response for a health check on message channel '%s' within %,d milliseconds; the connection or the remote instance may be overloaded", (Object[])new Object[]{channel.getChannelId(), 10000}));
        } else {
            if (response.getResultCode() == ProtocolConstants.ResultCode.CHANNEL_OR_RESPONSE_LISTENER_SHUT_DOWN_WHILE_WAITING_FOR_RESPONSE) {
                this.logger.debug((Object)StringUtils.format((String)"Message channel '%s' was closed while waiting for a health check response; not counting as an additional health check failure", (Object[])new Object[]{channel.getChannelId(), 10000}));
                return true;
            }
            this.logger.warn((Object)StringUtils.format((String)"Received non-success response for a health check on channel '%s': error code %d, content: %s", (Object[])new Object[]{channel.getChannelId(), numericResultCode, deserializedContent}));
        }
        return false;
    }

    private void handleBrokenChannel(MessageChannel channel) {
        String remoteNodeText = "(no node information available)";
        if (channel.getRemoteNodeInformation() != null) {
            remoteNodeText = channel.getRemoteNodeInformation().getInstanceNodeSessionId().toString();
        }
        this.logger.debug((Object)("Closing broken channel to " + remoteNodeText + " (id=" + channel.getChannelId() + ")"));
        if (channel.markAsBroken()) {
            this.unregisterClosedOrBrokenChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterClosedOrBrokenChannel(final MessageChannel channel) {
        Map<String, MessageChannel> map = this.activeOutgoingChannels;
        synchronized (map) {
            MessageChannel removed = this.activeOutgoingChannels.remove(channel.getChannelId());
            if (removed != channel) {
                this.logger.warn((Object)StringUtils.format((String)"Unexpected state: Expected to find same registered channel object for closed or broken channel %s, but found '%s' instead", (Object[])new Object[]{channel.getChannelId(), removed}));
            }
        }
        this.logger.debug((Object)("Notifying listeners of shutdown of channel " + channel.getChannelId()));
        this.channelListeners.enqueueCallback((AsyncCallback)new AsyncCallback<MessageChannelLifecycleListener>(){

            public void performCallback(MessageChannelLifecycleListener listener) {
                listener.onOutgoingChannelTerminated(channel);
            }
        });
        EventLog.append((EventLogEntry)EventLog.newEntry((EventType)EventType.CONNECTION_INCOMING_CLOSED).set("type", "localnet").set("connection_id", channel.getChannelId()).set("remote_node_id", channel.getRemoteNodeInformation().getInstanceNodeSessionIdString()).set("remote_ip", "TODO").set("remote_port", "TODO").set("server_port", "TODO"));
    }

    private class BrokenMessageChannelListenerImpl
    implements BrokenMessageChannelListener {
        private BrokenMessageChannelListenerImpl() {
        }

        @Override
        public void onChannelBroken(MessageChannel channel) {
            if (channel.getInitiatedByRemote()) {
                MessageChannelServiceImpl.this.logger.warn((Object)("onChannelBroken called for remote-initiated channel " + channel.getChannelId() + "; ignoring"));
                return;
            }
            MessageChannelServiceImpl.this.handleBrokenChannel(channel);
        }
    }

    private static final class MessageChannelHealthState {
        private int healthCheckFailureCount;
        private final Object healthCheckInProgressLock = new Object();

        private MessageChannelHealthState() {
        }

        public boolean healthCheckFailuresAtOrAboveLimit() {
            return this.healthCheckFailureCount >= 3;
        }
    }

    private class RawMessageChannelEndpointHandlerImpl
    implements MessageChannelEndpointHandler {
        private RawMessageChannelEndpointHandlerImpl() {
        }

        @Override
        public InitialNodeInformation exchangeNodeInformation(InitialNodeInformation senderNodeInformation) {
            MessageChannelServiceImpl.this.mergeRemoteHandshakeInformationIntoGlobalNodeKnowledge(senderNodeInformation);
            return MessageChannelServiceImpl.this.ownNodeInformation;
        }

        @Override
        public void onRemoteInitiatedChannelEstablished(MessageChannel channel, ServerContactPoint serverContactPoint) {
            if (!channel.getInitiatedByRemote()) {
                throw new IllegalStateException("Consistency error");
            }
            MessageChannelServiceImpl.this.registerNewOutgoingChannel(channel);
            MessageChannelServiceImpl.this.logger.debug((Object)StringUtils.format((String)"Remote-initiated channel '%s' established from '%s' to '%s' via local SCP %s", (Object[])new Object[]{channel, channel.getRemoteNodeInformation().getLogDescription(), MessageChannelServiceImpl.this.ownNodeInformation.getLogDescription(), serverContactPoint}));
            EventLog.append((EventLogEntry)EventLog.newEntry((EventType)EventType.CONNECTION_INCOMING_ACCEPTED).set("type", "localnet").set("connection_id", channel.getChannelId()).set("remote_node_id", channel.getRemoteNodeInformation().getInstanceNodeSessionIdString()).set("remote_ip", "TODO").set("remote_port", "TODO").set("server_port", serverContactPoint.getNetworkContactPoint().getPort()));
        }

        @Override
        public void onInboundChannelClosing(String idOfInboundChannel) {
            if (idOfInboundChannel == null) {
                throw new NullPointerException(idOfInboundChannel);
            }
            MessageChannelServiceImpl.this.logger.debug((Object)("Inbound message channel is closing, checking for mirror channels; id=" + idOfInboundChannel));
            for (MessageChannel channel : MessageChannelServiceImpl.this.getAllOutgoingChannels()) {
                if (!idOfInboundChannel.equals(channel.getAssociatedMirrorChannelId())) continue;
                MessageChannelServiceImpl.this.logger.debug((Object)StringUtils.format((String)"Found matching mirror channel for closing inbound channel %s, closing: %s", (Object[])new Object[]{idOfInboundChannel, channel}));
                MessageChannelServiceImpl.this.threadPool.execute("Communication Layer: Close mirror channel after inbound channel was closed", idOfInboundChannel, () -> {
                    if (channel.getState() == MessageChannelState.ESTABLISHED) {
                        channel.markAsClosedBecauseMirrorChannelClosed();
                    }
                    MessageChannelServiceImpl.this.closeOutgoingChannel(channel);
                });
            }
        }

        @Override
        public NetworkResponse onRawRequestReceived(NetworkRequest request, String sourceIdString) {
            try {
                NodeIdentifierContextHolder.setDeserializationServiceForCurrentThread(MessageChannelServiceImpl.this.nodeIdentifierService);
                NetworkResponse networkResponse = this.onRawRequestReceivedInternal(request, sourceIdString);
                return networkResponse;
            }
            finally {
                NodeIdentifierContextHolder.setDeserializationServiceForCurrentThread(null);
            }
        }

        private NetworkResponse onRawRequestReceivedInternal(final NetworkRequest request, String sourceIdString) {
            NetworkResponse response;
            String finalRecipientIdString;
            InstanceNodeSessionId sourceId;
            try {
                sourceId = MessageChannelServiceImpl.this.nodeIdentifierService.parseInstanceNodeSessionIdString(sourceIdString);
            }
            catch (IdentifierException e) {
                throw NodeIdentifierUtils.wrapIdentifierException(e);
            }
            MessageChannelServiceImpl.this.trafficListeners.enqueueCallback((AsyncCallback)new AsyncCallback<MessageChannelTrafficListener>(){

                public void performCallback(MessageChannelTrafficListener listener) {
                    listener.onRequestReceivedFromChannel(request, sourceId);
                }
            });
            String messageType = request.getMessageType();
            byte[] contentBytes = request.getContentBytes();
            if (contentBytes != null) {
                StatsCounter.registerValue((String)"Messaging: Request payload bytes received by type", (String)messageType, (long)contentBytes.length);
            }
            if ((finalRecipientIdString = request.accessMetaData().getFinalRecipientIdString()) == null || MessageChannelServiceImpl.this.ownNodeInformation.getInstanceNodeSessionIdString().equals(finalRecipientIdString)) {
                StatsCounter.count((String)"Messages arrived at destination by type", (String)messageType);
                response = MessageChannelServiceImpl.this.messageEndpointHandler.onRequestArrivedAtDestination(request);
            } else {
                if (!MessageChannelServiceImpl.this.localNodeIsRelay) {
                    MessageChannelServiceImpl.this.logger.error((Object)("Received a network request that would be forwarded, but the local node is not a relay: " + request));
                    return NetworkResponseFactory.generateResponseForNoRouteWhileForwarding(request, MessageChannelServiceImpl.this.ownNodeInformation.getInstanceNodeSessionId());
                }
                NetworkRequest forwardingRequest = NetworkRequestFactory.createNetworkRequestForForwarding(request, MessageChannelServiceImpl.this.ownNodeInformation.getInstanceNodeSessionId());
                if (!forwardingRequest.getRequestId().equals(request.getRequestId())) {
                    throw new IllegalStateException("Wrong request id on forwarding");
                }
                StatsCounter.count((String)"Messages forwarded by type", (String)messageType);
                response = MessageChannelServiceImpl.this.messageRoutingService.forwardAndAwait(forwardingRequest);
            }
            if (!response.accessMetaData().hasSender()) {
                response.accessMetaData().setSender(MessageChannelServiceImpl.this.ownNodeInformation.getInstanceNodeSessionId());
            }
            MessageChannelServiceImpl.this.trafficListeners.enqueueCallback((AsyncCallback)new AsyncCallback<MessageChannelTrafficListener>(){

                public void performCallback(MessageChannelTrafficListener listener) {
                    listener.onResponseSentIntoChannel(response, request, sourceId);
                }
            });
            return response;
        }
    }
}

