/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.toolintegration;

import de.rcenvironment.core.component.integration.IntegrationContextType;
import de.rcenvironment.core.component.integration.ToolIntegrationConstants;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.integration.toolintegration.Messages;
import de.rcenvironment.core.gui.integration.toolintegration.ToolIntegrationWizard;
import de.rcenvironment.core.gui.integration.toolintegration.WizardInsertCopyCommandDialog;
import de.rcenvironment.core.gui.integration.toolintegration.api.ToolIntegrationWizardPage;
import de.rcenvironment.core.gui.utils.common.widgets.LineNumberStyledText;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ScriptConfigurationPage
extends ToolIntegrationWizardPage {
    public static final int INPUT_COMBO = 0;
    public static final int OUTPUT_COMBO = 1;
    public static final int PROPERTY_COMBO = 2;
    public static final int ADD_PROPERTY_COMBO = 3;
    public static final int DIRECTORY_COMBO = 4;
    private static final int COMBO_WIDTH = 125;
    private static final int INSERT_BUTTON_WIDTH = 50;
    private static final int MOCK_GROUP_MINIMUM_HEIGHT = 67;
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.wizard.toolintegration.integration_execution";
    private static final int TEXTFIELD_HEIGHT = 270;
    private static final int TEXTFIELD_WIDTH = 300;
    private static final int NUMBER_OF_TABS = 4;
    private static final String CPACS_MOCK_TOOL_OUTPUT_FILENAME = "imitationToolOutputFilename";
    protected Map<String, Object> configurationMap;
    private final CCombo[] inputCombos;
    private final CCombo[] outputCombos;
    private final CCombo[] propertiesCombos;
    private final CCombo[] directoryCombos;
    private final LineNumberStyledText[] textFields;
    private Button winEnabledButton = null;
    private Button linuxEnabledButton = null;
    private boolean winScriptHasFocus = false;
    private Button noErrorOnOtherExitCodeButton;
    private Button setWorkingDirAsCwdButton;
    private Button setToolDirAsCwdButton;
    private Label executionPathLabel;
    private Button mockModeCheckBox;
    private CTabFolder tabFolder;
    private Composite mockScriptTabComposite;
    private Composite mockScriptTabButtonComposite;
    private Text mockToolOutputFilenameText;
    private Label mockToolOutputFilenameLabel;

    protected ScriptConfigurationPage(String pageName, Map<String, Object> configurationMap) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.scriptPageDescription);
        this.configurationMap = configurationMap;
        this.inputCombos = new CCombo[4];
        this.outputCombos = new CCombo[4];
        this.propertiesCombos = new CCombo[4];
        this.directoryCombos = new CCombo[4];
        this.textFields = new LineNumberStyledText[5];
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.tabFolder = new CTabFolder(container, 2048);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessVerticalSpace = true;
        this.tabFolder.setLayoutData((Object)layoutData);
        this.createScriptTabItem("commandScriptLinux", Messages.commandScriptMessage, 0);
        this.createScriptTabItem("preScript", Messages.preScript, 1);
        this.createScriptTabItem("postScript", Messages.postScript, 2);
        this.createScriptTabItem("imitationScript", "Tool run imitation script", 3);
        this.tabFolder.setSelection(0);
        this.createMockModeGroup(container);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
        this.updatePageComplete();
    }

    private void createMockModeGroup(Composite container) {
        Group mockGroup = new Group(container, 0);
        mockGroup.setText("Tool run imitation mode");
        mockGroup.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(768);
        layoutData.minimumHeight = 67;
        mockGroup.setLayoutData((Object)layoutData);
        this.mockModeCheckBox = new Button((Composite)mockGroup, 32);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.mockModeCheckBox.setLayoutData((Object)layoutData);
        this.mockModeCheckBox.setText("Support tool run imitation");
        this.mockModeCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ScriptConfigurationPage.this.setMockScriptTabEnabled(ScriptConfigurationPage.this.mockModeCheckBox.getSelection());
                if (ScriptConfigurationPage.this.mockToolOutputFilenameText != null) {
                    ScriptConfigurationPage.this.mockToolOutputFilenameText.setEnabled(ScriptConfigurationPage.this.mockModeCheckBox.getSelection());
                }
                ScriptConfigurationPage.this.configurationMap.put("imitationModeSupported", ScriptConfigurationPage.this.mockModeCheckBox.getSelection());
                ScriptConfigurationPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.mockToolOutputFilenameLabel = new Label((Composite)mockGroup, 0);
        this.mockToolOutputFilenameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mockToolOutputFilenameLabel.setText("Dummy tool output filename:");
        this.mockToolOutputFilenameText = new Text((Composite)mockGroup, 2048);
        this.mockToolOutputFilenameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mockToolOutputFilenameText.addModifyListener((ModifyListener)new TextAreaModifyListener(CPACS_MOCK_TOOL_OUTPUT_FILENAME));
        this.mockToolOutputFilenameLabel.setVisible(false);
        this.mockToolOutputFilenameText.setVisible(false);
    }

    private void setChildrenEnabled(Composite parent, boolean enabled) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    private void setMockScriptTabEnabled(boolean enabled) {
        this.setChildrenEnabled(this.mockScriptTabComposite, enabled);
        this.setChildrenEnabled(this.mockScriptTabButtonComposite, enabled);
    }

    @Override
    public void updatePage() {
        int i = 0;
        while (i < 4) {
            this.addAllEndpoints(this.inputCombos[i], "inputs", i);
            this.setComboEnabled(this.inputCombos[i]);
            if (i > 0) {
                this.addAllEndpoints(this.outputCombos[i], "outputs", i);
            }
            this.setComboEnabled(this.outputCombos[i]);
            this.propertiesCombos[i].removeAll();
            if (this.configurationMap.containsKey("toolProperties")) {
                Map properties = (Map)this.configurationMap.get("toolProperties");
                for (Object proptabObject : properties.values()) {
                    Map proptab = (Map)proptabObject;
                    for (Object propertyObject : proptab.values()) {
                        if (!(propertyObject instanceof Map)) continue;
                        Map property = (Map)propertyObject;
                        this.propertiesCombos[i].add((String)property.get("propertyDisplayName"));
                    }
                }
            }
            if (this.propertiesCombos[i].getItemCount() > 0) {
                this.propertiesCombos[i].select(0);
            }
            this.setComboEnabled(this.propertiesCombos[i]);
            this.directoryCombos[i].select(0);
            boolean mockModeSupported = this.configurationMap.containsKey("imitationModeSupported") && (Boolean)this.configurationMap.get("imitationModeSupported") != false;
            this.setMockScriptTabEnabled(mockModeSupported);
            this.mockModeCheckBox.setSelection(mockModeSupported);
            if (this.mockToolOutputFilenameText != null) {
                this.mockToolOutputFilenameText.setEnabled(mockModeSupported);
            }
            ++i;
        }
        boolean isCPACSType = ((ToolIntegrationWizard)this.getWizard()).getCurrentContext().getContextTypeString().equalsIgnoreCase("CPACS");
        this.mockToolOutputFilenameLabel.setVisible(isCPACSType);
        this.mockToolOutputFilenameText.setVisible(isCPACSType);
        this.updateButtons();
        this.updatePageComplete();
    }

    private void setComboEnabled(CCombo combo) {
        if (combo != null) {
            if (combo.getItemCount() == 0) {
                combo.setEnabled(false);
            } else {
                combo.setEnabled(true);
            }
        }
    }

    private void updateButtons() {
        boolean windowsEnabled = false;
        boolean linuxEnabled = false;
        if (this.configurationMap.get("enableCommandScriptWindows") != null) {
            windowsEnabled = (Boolean)this.configurationMap.get("enableCommandScriptWindows");
        }
        if (this.configurationMap.get("enableCommandScriptLinux") != null) {
            linuxEnabled = (Boolean)this.configurationMap.get("enableCommandScriptLinux");
        }
        this.winEnabledButton.setSelection(windowsEnabled);
        this.linuxEnabledButton.setSelection(linuxEnabled);
        this.textFields[0].setEditable(linuxEnabled);
        this.textFields[0].setEnabled(linuxEnabled);
        this.textFields[this.textFields.length - 1].setEditable(windowsEnabled);
        this.textFields[this.textFields.length - 1].setEnabled(windowsEnabled);
        if ((String)this.configurationMap.get("commandScriptLinux") != null) {
            this.textFields[0].setText((String)this.configurationMap.get("commandScriptLinux"));
        } else {
            this.textFields[0].setText("");
        }
        if ((String)this.configurationMap.get("commandScriptWindows") != null) {
            this.textFields[this.textFields.length - 1].setText((String)this.configurationMap.get("commandScriptWindows"));
        } else {
            this.textFields[this.textFields.length - 1].setText("");
        }
        if ((String)this.configurationMap.get("preScript") != null) {
            this.textFields[1].setText((String)this.configurationMap.get("preScript"));
        } else {
            this.textFields[1].setText("");
        }
        if ((String)this.configurationMap.get("postScript") != null) {
            this.textFields[2].setText((String)this.configurationMap.get("postScript"));
        } else {
            this.textFields[2].setText("");
        }
        if ((String)this.configurationMap.get("imitationScript") != null) {
            this.textFields[3].setText((String)this.configurationMap.get("imitationScript"));
        } else {
            this.textFields[3].setText("");
        }
        if (this.configurationMap.get("dontCrashOnNonZeroExitCodes") != null) {
            this.noErrorOnOtherExitCodeButton.setSelection(((Boolean)this.configurationMap.get("dontCrashOnNonZeroExitCodes")).booleanValue());
        }
        if (this.configurationMap.get("setToolDirAsWorkingDir") != null) {
            boolean toolDirIsCwd = (Boolean)this.configurationMap.get("setToolDirAsWorkingDir");
            this.setWorkingDirAsCwdButton.setSelection(!toolDirIsCwd);
            this.setToolDirAsCwdButton.setSelection(toolDirIsCwd);
        } else {
            this.setWorkingDirAsCwdButton.setSelection(true);
            this.setToolDirAsCwdButton.setSelection(false);
        }
        this.setWorkingDirAsCwdButton.setEnabled(true);
        this.setToolDirAsCwdButton.setEnabled(true);
        this.executionPathLabel.setEnabled(true);
        String[] stringArray = ((ToolIntegrationWizard)this.getWizard()).getCurrentContext().getDisabledIntegrationKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if ("setToolDirAsWorkingDir".equals(key)) {
                this.setToolDirAsCwdButton.setEnabled(false);
                this.setWorkingDirAsCwdButton.setEnabled(false);
                this.executionPathLabel.setEnabled(false);
            }
            ++n2;
        }
        if (this.mockToolOutputFilenameText != null) {
            if ((String)this.configurationMap.get(CPACS_MOCK_TOOL_OUTPUT_FILENAME) != null) {
                this.mockToolOutputFilenameText.setText((String)this.configurationMap.get(CPACS_MOCK_TOOL_OUTPUT_FILENAME));
            } else {
                this.mockToolOutputFilenameText.setText("");
            }
        }
    }

    private void updatePageComplete() {
        boolean linuxEnabled;
        boolean winEnabled = this.configurationMap.get("enableCommandScriptWindows") != null && (Boolean)this.configurationMap.get("enableCommandScriptWindows") != false;
        boolean bl = linuxEnabled = this.configurationMap.get("enableCommandScriptLinux") != null && (Boolean)this.configurationMap.get("enableCommandScriptLinux") != false;
        if (!winEnabled && !linuxEnabled) {
            this.setPageComplete(false);
        } else {
            boolean linuxScriptNotEmpty;
            boolean winScriptNotEmpty = (String)this.configurationMap.get("commandScriptWindows") != null && !((String)this.configurationMap.get("commandScriptWindows")).trim().isEmpty();
            boolean bl2 = linuxScriptNotEmpty = (String)this.configurationMap.get("commandScriptLinux") != null && !((String)this.configurationMap.get("commandScriptLinux")).trim().isEmpty();
            if (winEnabled && winScriptNotEmpty || linuxEnabled && linuxScriptNotEmpty) {
                this.validateIsMockScriptConfiguration();
            } else {
                this.setMessage(Messages.toolExecutionCommandNeeded, 3);
                this.setPageComplete(false);
            }
        }
    }

    private LineNumberStyledText createScriptTabItem(String propertyKey, String name, int buttonIndex) {
        LineNumberStyledText scriptAreaWin;
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(name);
        Composite client = new Composite((Composite)this.tabFolder, 0);
        if (buttonIndex == 0) {
            this.winEnabledButton = new Button(client, 32);
            this.winEnabledButton.setText(Messages.winCommandUse);
            this.linuxEnabledButton = new Button(client, 32);
            this.linuxEnabledButton.setText(Messages.linuxCommandUse);
            new Label(client, 0);
        }
        if (buttonIndex == 0) {
            client.setLayout((Layout)new GridLayout(3, false));
            scriptAreaWin = new LineNumberStyledText(client, 2626);
            GridData scriptAreaWinData = new GridData(1808);
            scriptAreaWinData.widthHint = 150;
            scriptAreaWinData.heightHint = 270;
            scriptAreaWin.setLayoutData((Object)scriptAreaWinData);
            scriptAreaWin.addModifyListener((ModifyListener)new TextAreaModifyListener("commandScriptWindows"));
            scriptAreaWin.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent arg0) {
                }

                public void focusGained(FocusEvent arg0) {
                    ScriptConfigurationPage.this.winScriptHasFocus = true;
                }
            });
            scriptAreaWin.setEditable(false);
            this.textFields[this.textFields.length - 1] = scriptAreaWin;
        } else {
            scriptAreaWin = null;
            client.setLayout((Layout)new GridLayout(2, false));
        }
        item.setControl((Control)client);
        LineNumberStyledText scriptArea = new LineNumberStyledText(client, 2626);
        GridData scriptAreaData = new GridData(1808);
        if (buttonIndex == 0) {
            scriptArea.setEnabled(false);
            scriptArea.setEditable(false);
            scriptArea.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent arg0) {
                }

                public void focusGained(FocusEvent arg0) {
                    ScriptConfigurationPage.this.winScriptHasFocus = false;
                }
            });
            scriptAreaData.widthHint = 150;
        } else {
            scriptAreaData.widthHint = 300;
        }
        scriptAreaData.heightHint = 270;
        scriptArea.setLayoutData((Object)scriptAreaData);
        scriptArea.addModifyListener((ModifyListener)new TextAreaModifyListener(propertyKey));
        this.textFields[buttonIndex] = scriptArea;
        if (buttonIndex == 0) {
            this.addScriptSelectButtonListener();
        }
        this.createInsertFields(buttonIndex, client, scriptAreaWin, scriptArea);
        if (buttonIndex > 0) {
            Label jythonLabel = new Label(client, 0);
            jythonLabel.setText(Messages.scriptLanguageHint);
        } else {
            new Label(client, 0).setText(Messages.scriptLanguageHintBatch);
            new Label(client, 0).setText(Messages.scriptLanguageHintBash);
            new Label(client, 0).setText("");
            Group executionPropertiesGroup = new Group(client, 0);
            executionPropertiesGroup.setText("Execution Options");
            executionPropertiesGroup.setLayout((Layout)new GridLayout(1, false));
            GridData executionPropertiesData = new GridData(768);
            executionPropertiesData.horizontalSpan = 3;
            executionPropertiesGroup.setLayoutData((Object)executionPropertiesData);
            this.noErrorOnOtherExitCodeButton = new Button((Composite)executionPropertiesGroup, 32);
            this.noErrorOnOtherExitCodeButton.setText(Messages.dontCrashOtherThanZeroLabel);
            this.noErrorOnOtherExitCodeButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ScriptConfigurationPage.this.configurationMap.put("dontCrashOnNonZeroExitCodes", ScriptConfigurationPage.this.noErrorOnOtherExitCodeButton.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            });
            this.executionPathLabel = new Label((Composite)executionPropertiesGroup, 0);
            this.executionPathLabel.setText("Execute (command(s), pre execution/post execution/tool run imitation script) from");
            this.setWorkingDirAsCwdButton = new Button((Composite)executionPropertiesGroup, 16);
            this.setWorkingDirAsCwdButton.setSelection(true);
            this.setWorkingDirAsCwdButton.setText("Working directory");
            this.setWorkingDirAsCwdButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ScriptConfigurationPage.this.configurationMap.put("setToolDirAsWorkingDir", !ScriptConfigurationPage.this.setWorkingDirAsCwdButton.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            });
            this.setToolDirAsCwdButton = new Button((Composite)executionPropertiesGroup, 16);
            this.setToolDirAsCwdButton.setText("Tool directory");
            this.setToolDirAsCwdButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ScriptConfigurationPage.this.configurationMap.put("setToolDirAsWorkingDir", ScriptConfigurationPage.this.setToolDirAsCwdButton.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            });
        }
        if (buttonIndex == 3) {
            this.mockScriptTabComposite = client;
        }
        return scriptArea;
    }

    private void validateIsMockScriptConfiguration() {
        if (IntegrationContextType.COMMON.toString().equals(this.configurationMap.get("integrationType")) || this.configurationMap.get("integrationType") == null) {
            if (this.mockModeCheckBox.getSelection() && this.textFields[3].getText().isEmpty() && !this.mockToolOutputFilenameText.isVisible()) {
                this.setMessage("Tool run imitation mode is supported but no tool run imitation script is configured.", 3);
                this.setPageComplete(false);
            } else if (this.mockModeCheckBox.getSelection() && this.mockToolOutputFilenameText.isVisible() && this.mockToolOutputFilenameText.getText().isEmpty()) {
                this.setMessage("Tool run imitation mode is supported but no dummy tool output filename is configured.", 3);
                this.setPageComplete(false);
            } else {
                this.setMessage(null, 0);
                this.setPageComplete(true);
            }
        } else {
            this.setMessage(null, 0);
            this.setPageComplete(true);
        }
    }

    private void createInsertFields(int buttonIndex, Composite client, LineNumberStyledText scriptAreaWin, LineNumberStyledText scriptArea) {
        Composite buttonComposite = new Composite(client, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        GridData buttonCompositeData = new GridData();
        buttonCompositeData.verticalAlignment = 1;
        buttonCompositeData.horizontalSpan = 1;
        buttonComposite.setLayoutData((Object)buttonCompositeData);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        Label inputLabel = new Label(buttonComposite, 0);
        inputLabel.setText(Messages.inputs);
        inputLabel.setLayoutData((Object)labelData);
        CCombo inputCombo = new CCombo(buttonComposite, 2056);
        GridData inputComboData = new GridData(768);
        inputComboData.horizontalSpan = 1;
        inputComboData.widthHint = 125;
        inputCombo.setLayoutData((Object)inputComboData);
        Button inputInsertButton = new Button(buttonComposite, 8);
        GridData insertButtonData = new GridData();
        insertButtonData.horizontalSpan = 1;
        insertButtonData.widthHint = 50;
        inputInsertButton.setLayoutData((Object)insertButtonData);
        inputInsertButton.setText(Messages.insertButtonLabel);
        if (buttonIndex == 0) {
            inputInsertButton.addSelectionListener((SelectionListener)new InsertButtonListener(inputCombo, scriptArea, scriptAreaWin, 0));
        } else {
            inputInsertButton.addSelectionListener((SelectionListener)new InsertButtonListener(inputCombo, scriptArea, 0));
        }
        this.inputCombos[buttonIndex] = inputCombo;
        if (buttonIndex > 0) {
            GridData labelDataOutput = new GridData();
            labelDataOutput.horizontalSpan = 2;
            Label outputLabel = new Label(buttonComposite, 0);
            outputLabel.setText(Messages.outputs);
            outputLabel.setLayoutData((Object)labelDataOutput);
            CCombo outputCombo = new CCombo(buttonComposite, 2056);
            GridData outputComboData = new GridData(768);
            outputComboData.widthHint = 125;
            outputCombo.setLayoutData((Object)outputComboData);
            Button outputInsertButton = new Button(buttonComposite, 8);
            outputInsertButton.setLayoutData((Object)insertButtonData);
            outputInsertButton.setText(Messages.insertButtonLabel);
            outputInsertButton.addSelectionListener((SelectionListener)new InsertButtonListener(outputCombo, scriptArea, 1));
            this.outputCombos[buttonIndex] = outputCombo;
        }
        GridData labelDataProperties = new GridData();
        labelDataProperties.horizontalSpan = 2;
        Label propertiesLabel = new Label(buttonComposite, 0);
        propertiesLabel.setText(Messages.properties);
        propertiesLabel.setLayoutData((Object)labelDataProperties);
        CCombo propertiesCombo = new CCombo(buttonComposite, 2056);
        GridData propertiesComboData = new GridData(768);
        propertiesComboData.widthHint = 125;
        propertiesCombo.setLayoutData((Object)propertiesComboData);
        Button propertyInsertButton = new Button(buttonComposite, 8);
        propertyInsertButton.setLayoutData((Object)insertButtonData);
        propertyInsertButton.setText(Messages.insertButtonLabel);
        if (buttonIndex == 0) {
            propertyInsertButton.addSelectionListener((SelectionListener)new InsertButtonListener(propertiesCombo, scriptArea, scriptAreaWin, 2));
        } else {
            propertyInsertButton.addSelectionListener((SelectionListener)new InsertButtonListener(propertiesCombo, scriptArea, 2));
        }
        this.propertiesCombos[buttonIndex] = propertiesCombo;
        GridData labelDataDirectories = new GridData();
        labelDataDirectories.horizontalSpan = 2;
        Label directoryLabel = new Label(buttonComposite, 0);
        directoryLabel.setText(Messages.directory);
        directoryLabel.setLayoutData((Object)labelDataDirectories);
        CCombo directoriesCombo = new CCombo(buttonComposite, 2056);
        GridData directoriesComboData = new GridData(768);
        directoriesComboData.widthHint = 125;
        directoriesCombo.setLayoutData((Object)directoriesComboData);
        directoriesCombo.setItems(ToolIntegrationConstants.DIRECTORIES_PLACEHOLDERS_DISPLAYNAMES);
        Button directoryInsertButton = new Button(buttonComposite, 8);
        directoryInsertButton.setLayoutData((Object)insertButtonData);
        directoryInsertButton.setText(Messages.insertButtonLabel);
        if (scriptAreaWin != null) {
            directoryInsertButton.addSelectionListener((SelectionListener)new InsertButtonListener(directoriesCombo, scriptArea, scriptAreaWin, 4));
        } else {
            directoryInsertButton.addSelectionListener((SelectionListener)new InsertButtonListener(directoriesCombo, scriptArea, 4));
        }
        this.directoryCombos[buttonIndex] = directoriesCombo;
        if (buttonIndex == 2) {
            GridData labelDataAddProp = new GridData();
            labelDataAddProp.horizontalSpan = 2;
            Label addPropLabel = new Label(buttonComposite, 0);
            addPropLabel.setText("Additional Properties");
            addPropLabel.setLayoutData((Object)labelDataAddProp);
            CCombo addPropCombo = new CCombo(buttonComposite, 2056);
            GridData addPropComboData = new GridData(768);
            addPropComboData.widthHint = 125;
            addPropCombo.setLayoutData((Object)addPropComboData);
            addPropCombo.add(Messages.exitCodeLabel);
            addPropCombo.select(0);
            Button addPropInsertButton = new Button(buttonComposite, 8);
            addPropInsertButton.setLayoutData((Object)insertButtonData);
            addPropInsertButton.setText(Messages.insertButtonLabel);
            addPropInsertButton.addSelectionListener((SelectionListener)new InsertButtonListener(addPropCombo, scriptArea, 3));
        }
        if (buttonIndex > 0) {
            new Label(buttonComposite, 0).setText("");
            new Label(buttonComposite, 0).setText("");
            Button insertCopyCommand = new Button(buttonComposite, 8);
            GridData copyData = new GridData();
            insertCopyCommand.setLayoutData((Object)copyData);
            insertCopyCommand.setText("Insert copy of file/dir...");
            insertCopyCommand.addSelectionListener((SelectionListener)new CopyInputListener(scriptArea));
        }
        if (buttonIndex == 3) {
            this.mockScriptTabButtonComposite = buttonComposite;
        }
    }

    private void addScriptSelectButtonListener() {
        this.winEnabledButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ScriptConfigurationPage.this.textFields[4].setEnabled(ScriptConfigurationPage.this.winEnabledButton.getSelection());
                ScriptConfigurationPage.this.textFields[4].setEditable(ScriptConfigurationPage.this.winEnabledButton.getSelection());
                ScriptConfigurationPage.this.configurationMap.put("enableCommandScriptWindows", ScriptConfigurationPage.this.winEnabledButton.getSelection());
                ScriptConfigurationPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.linuxEnabledButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ScriptConfigurationPage.this.textFields[0].setEnabled(ScriptConfigurationPage.this.linuxEnabledButton.getSelection());
                ScriptConfigurationPage.this.textFields[0].setEditable(ScriptConfigurationPage.this.linuxEnabledButton.getSelection());
                ScriptConfigurationPage.this.configurationMap.put("enableCommandScriptLinux", ScriptConfigurationPage.this.linuxEnabledButton.getSelection());
                ScriptConfigurationPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void addAllEndpoints(CCombo endpointCombo, String key, int tabNumber) {
        endpointCombo.removeAll();
        List endpointList = (List)this.configurationMap.get(key);
        if (endpointList != null) {
            for (Map endpoint : endpointList) {
                if (tabNumber == 0 && (((String)endpoint.get("endpointDataType")).equals(DataType.Vector.name()) || ((String)endpoint.get("endpointDataType")).equals(DataType.Matrix.name()))) continue;
                endpointCombo.add((String)endpoint.get("endpointName"));
            }
            if (endpointCombo.getItemCount() > 0) {
                endpointCombo.select(0);
            }
        }
    }

    private String createAddPropertyPlaceHolder(String addPropPlaceholder) {
        return "${addProp:" + addPropPlaceholder + "}";
    }

    @Override
    public void setConfigMap(Map<String, Object> newConfigurationMap) {
        this.configurationMap = newConfigurationMap;
        this.updatePageValues();
    }

    private void updatePageValues() {
        this.updatePage();
        this.updatePageComplete();
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.displayHelp(HELP_CONTEXT_ID);
    }

    private class CopyInputListener
    implements SelectionListener {
        private final LineNumberStyledText text;

        CopyInputListener(LineNumberStyledText text) {
            this.text = text;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            WizardInsertCopyCommandDialog dialog;
            List endpointList = (List)ScriptConfigurationPage.this.configurationMap.get("inputs");
            LinkedList<String> endpointNames = new LinkedList<String>();
            if (endpointList != null) {
                for (Map endpoint : endpointList) {
                    if (((String)endpoint.get("endpointDataType")).equals(DataType.FileReference.name())) {
                        endpointNames.add("File : " + (String)endpoint.get("endpointName"));
                    }
                    if (!((String)endpoint.get("endpointDataType")).equals(DataType.DirectoryReference.name())) continue;
                    endpointNames.add("Directory : " + (String)endpoint.get("endpointName"));
                }
            }
            if ((dialog = new WizardInsertCopyCommandDialog(ScriptConfigurationPage.this.getShell(), endpointNames, ScriptConfigurationPage.this.directoryCombos[1].getItems())).open() == 0) {
                String command = dialog.getCopyCommand();
                if (!this.text.isDisposed()) {
                    this.text.insert(String.valueOf(command) + "\n");
                    this.text.setFocus();
                }
            }
        }
    }

    private class InsertButtonListener
    implements SelectionListener {
        private static final String QUOTE = "\"";
        private final CCombo combo;
        private final LineNumberStyledText text;
        private final int comboType;
        private LineNumberStyledText text2;

        InsertButtonListener(CCombo inputCombo, LineNumberStyledText scriptArea, int comboType) {
            this.combo = inputCombo;
            this.text = scriptArea;
            this.comboType = comboType;
        }

        InsertButtonListener(CCombo inputCombo, LineNumberStyledText scriptArea, LineNumberStyledText scriptArea2, int comboType) {
            this.combo = inputCombo;
            this.text = scriptArea;
            this.text2 = scriptArea2;
            this.comboType = comboType;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            String insertText = this.combo.getText();
            LineNumberStyledText currentText = this.text;
            if (ScriptConfigurationPage.this.winScriptHasFocus && this.text2 != null) {
                currentText = this.text2;
            }
            if (currentText.isEnabled()) {
                int distanceCaretPositionToTextLength;
                if (this.comboType == 0 && insertText != null && !insertText.isEmpty()) {
                    distanceCaretPositionToTextLength = currentText.getText().length() - currentText.getSelection().x;
                    String possibleQuotes = "";
                    List endpointList = (List)ScriptConfigurationPage.this.configurationMap.get("inputs");
                    Map endpoint = null;
                    for (Map ep : endpointList) {
                        if (!ep.get("endpointName").equals(insertText)) continue;
                        endpoint = ep;
                    }
                    if (endpoint != null && (endpoint.get("endpointDataType").equals(DataType.ShortText.name()) || endpoint.get("endpointDataType").equals(DataType.FileReference.name()) || endpoint.get("endpointDataType").equals(DataType.DirectoryReference.name()))) {
                        possibleQuotes = QUOTE;
                    }
                    currentText.insert(String.valueOf(possibleQuotes) + "${" + "in" + ":" + insertText + "}" + possibleQuotes);
                    currentText.setSelection(currentText.getText().length() - distanceCaretPositionToTextLength);
                }
                if (this.comboType == 1 && insertText != null && !insertText.isEmpty()) {
                    distanceCaretPositionToTextLength = currentText.getText().length() - currentText.getSelection().x;
                    currentText.insert("${out:" + insertText + "}");
                    currentText.setSelection(currentText.getText().length() - distanceCaretPositionToTextLength);
                }
                if (this.comboType == 2 && insertText != null && !insertText.isEmpty() && ScriptConfigurationPage.this.configurationMap.containsKey("toolProperties")) {
                    distanceCaretPositionToTextLength = currentText.getText().length() - currentText.getSelection().x;
                    Map properties = (Map)ScriptConfigurationPage.this.configurationMap.get("toolProperties");
                    for (String propTabName : properties.keySet()) {
                        Map proptab = (Map)properties.get(propTabName);
                        for (Map.Entry proptabEntry : proptab.entrySet()) {
                            Map property;
                            String propkey = (String)proptabEntry.getKey();
                            Object propertyObject = proptabEntry.getValue();
                            if (!(propertyObject instanceof Map) || !((String)(property = (Map)propertyObject).get("propertyDisplayName")).equals(insertText)) continue;
                            currentText.insert("\"${prop:" + propkey + "}" + QUOTE);
                        }
                    }
                    currentText.setSelection(currentText.getText().length() - distanceCaretPositionToTextLength);
                }
                if (this.comboType == 4 && insertText != null && !insertText.isEmpty()) {
                    distanceCaretPositionToTextLength = currentText.getText().length() - currentText.getSelection().x;
                    currentText.insert("\"${dir:" + ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[this.combo.getSelectionIndex()] + "}" + QUOTE);
                    currentText.setSelection(currentText.getText().length() - distanceCaretPositionToTextLength);
                }
                if (this.comboType == 3 && insertText != null && !insertText.isEmpty()) {
                    currentText.insert(ScriptConfigurationPage.this.createAddPropertyPlaceHolder("exitCode"));
                }
                currentText.setFocus();
            }
        }
    }

    private class TextAreaModifyListener
    implements ModifyListener {
        private final String key;

        TextAreaModifyListener(String key) {
            this.key = key;
        }

        public void modifyText(ModifyEvent arg0) {
            Object obj = arg0.getSource();
            if (obj instanceof Text) {
                ScriptConfigurationPage.this.configurationMap.put(this.key, ((Text)obj).getText());
            } else if (obj instanceof LineNumberStyledText) {
                ScriptConfigurationPage.this.configurationMap.put(this.key, ((LineNumberStyledText)obj).getText());
            }
            ScriptConfigurationPage.this.updatePageComplete();
        }
    }
}

