/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.api;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AuthorizationIdRules {
    protected static final String INTERNAL_ERROR_THE_NAME_MUST_NOT_BE_NULL = "Internal error: The name must not be null";
    protected static final String INVALID_KEY_IMPORT_DATA = "Invalid key import data: ";
    protected static final Pattern INVALID_CHARACTER_CHECK_PATTERN = Pattern.compile("[^a-zA-Z0-9_\\(\\)]");
    protected static final String INVALID_CHARACTERS_ERROR_MESSAGE = "Invalid character at position %d (\"%s\"): only the letters a-z, A-Z, digits, and the special characters _() are allowed";
    protected static final int MINIMUM_ID_LENGTH = 2;
    protected static final String MINIMUM_ID_LENGTH_ERROR_MESSAGE = "Group names must be at least 2 characters long";
    protected static final int MAXIMUM_ID_LENGTH = 32;
    protected static final String MAXIMUM_ID_LENGTH_ERROR_MESSAGE = "The maximum length for group names is 32 characters";
    protected static final Pattern GROUP_ID_RANDOM_PART_REGEXP = Pattern.compile("[0-9a-f]{16}");
    protected static final Pattern EXPECTED_IMPORT_STRING_PATTERN = Pattern.compile("[^:]+:[0-9a-f]+:[0-9]+:[\\w-_]{43}");

    private AuthorizationIdRules() {
    }

    public static Optional<String> validateAuthorizationGroupId(String input) {
        if (input == null) {
            return Optional.of(INTERNAL_ERROR_THE_NAME_MUST_NOT_BE_NULL);
        }
        if (input.contains(" ")) {
            return Optional.of("Group ids can not contain spaces; consider using underscores (\"_\") instead");
        }
        Matcher matcher = INVALID_CHARACTER_CHECK_PATTERN.matcher(input);
        if (matcher.find()) {
            return Optional.of(StringUtils.format((String)INVALID_CHARACTERS_ERROR_MESSAGE, (Object[])new Object[]{matcher.start(0) + 1, matcher.group(0)}));
        }
        if (input.length() < 2) {
            return Optional.of(MINIMUM_ID_LENGTH_ERROR_MESSAGE);
        }
        if (input.length() > 32) {
            return Optional.of(MAXIMUM_ID_LENGTH_ERROR_MESSAGE);
        }
        if (input.trim().length() != input.length()) {
            return Optional.of("Uncaught leading or training whitespace");
        }
        return Optional.empty();
    }

    public static Optional<String> validateAuthorizationGroupFullId(String input) {
        if (input == null) {
            return Optional.of(INTERNAL_ERROR_THE_NAME_MUST_NOT_BE_NULL);
        }
        if ((input = input.trim()).isEmpty()) {
            return Optional.of("Empty id string");
        }
        String[] parts = input.split(":");
        if (parts.length != 2) {
            return Optional.of("Expected a complete authorization group id, which consists of a valid authorization group name, a colon, and an auto-generated part consisting of 16 hex characters");
        }
        Optional<String> groupIdError = AuthorizationIdRules.validateAuthorizationGroupId(parts[0]);
        if (groupIdError.isPresent()) {
            return groupIdError;
        }
        if (!GROUP_ID_RANDOM_PART_REGEXP.matcher(parts[1]).matches()) {
            return Optional.of("The second part of the authorization group id is malformed; it is expected to be a sequence of 16 hex characters. ");
        }
        return Optional.empty();
    }

    public static Optional<String> validateAuthorizationGroupImportString(String input) {
        if (input == null) {
            return Optional.of(INTERNAL_ERROR_THE_NAME_MUST_NOT_BE_NULL);
        }
        if ((input = input.trim()).isEmpty()) {
            return Optional.of("No key import data found");
        }
        String[] parts = input.split(":");
        if (parts.length != 4) {
            return Optional.of("Invalid key import data: Valid keys consist of 4 colon-separated parts");
        }
        Optional<String> groupNameValidationError = AuthorizationIdRules.validateAuthorizationGroupId(parts[0]);
        if (groupNameValidationError.isPresent()) {
            return Optional.of("Invalid group id: " + groupNameValidationError.get());
        }
        if (parts[1].length() != 16) {
            return Optional.of("Invalid key import data: Invalid length of the generated group id part; was this group key generated with a pre-release version of RCE?");
        }
        if (!parts[2].equals("1")) {
            return Optional.of("Invalid key import data: Unrecognized key version; was this group key generated with an incompatible future version of RCE?");
        }
        if (!EXPECTED_IMPORT_STRING_PATTERN.matcher(input).matches()) {
            return Optional.of("Invalid key import data: Invalid data or key format");
        }
        return Optional.empty();
    }
}

