/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.forward;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.exception.SshChannelOpenException;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.forward.ForwardingTunnelEndpointsProvider;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.forward.TcpForwardingFilter;

public class TcpipServerChannel
extends AbstractServerChannel
implements ForwardingTunnelEndpointsProvider {
    private final TcpForwardingFilter.Type type;
    private IoConnector connector;
    private IoSession ioSession;
    private ChannelAsyncOutputStream out;
    private SshdSocketAddress tunnelEntrance;
    private SshdSocketAddress tunnelExit;
    private SshdSocketAddress originatorAddress;
    private SocketAddress localAddress;

    public TcpipServerChannel(TcpForwardingFilter.Type type, CloseableExecutorService executor) {
        super("", Collections.emptyList(), executor);
        this.type = Objects.requireNonNull(type, "No channel type specified");
    }

    public TcpForwardingFilter.Type getTcpipChannelType() {
        return this.type;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(SocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public SshdSocketAddress getTunnelEntrance() {
        return this.tunnelEntrance;
    }

    @Override
    public SshdSocketAddress getTunnelExit() {
        return this.tunnelExit;
    }

    public SshdSocketAddress getOriginatorAddress() {
        return this.originatorAddress;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        super.handleWindowAdjust(buffer);
        if (this.out != null) {
            this.out.onWindowExpanded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f;
        FactoryManager manager;
        Session session;
        SshdSocketAddress address;
        block11: {
            String hostToConnect = buffer.getString();
            int portToConnect = buffer.getInt();
            String originatorIpAddress = buffer.getString();
            int originatorPort = buffer.getInt();
            boolean debugEnabled = this.log.isDebugEnabled();
            if (debugEnabled) {
                this.log.debug("doInit({}) Receiving request for direct tcpip: hostToConnect={}, portToConnect={}, originatorIpAddress={}, originatorPort={}", new Object[]{this, hostToConnect, portToConnect, originatorIpAddress, originatorPort});
            }
            TcpForwardingFilter.Type channelType = this.getTcpipChannelType();
            switch (this.type) {
                case Direct: {
                    address = new SshdSocketAddress(hostToConnect, portToConnect);
                    break;
                }
                case Forwarded: {
                    Forwarder forwarder = this.service.getForwarder();
                    address = forwarder.getForwardedPort(portToConnect);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown server channel type: " + (Object)((Object)channelType));
                }
            }
            this.originatorAddress = new SshdSocketAddress(originatorIpAddress, originatorPort);
            this.tunnelEntrance = new SshdSocketAddress(hostToConnect, portToConnect);
            this.tunnelExit = address;
            session = this.getSession();
            manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
            TcpForwardingFilter filter = manager.getTcpForwardingFilter();
            f = new DefaultOpenFuture(this, this);
            try {
                if (address != null && filter != null && filter.canConnect(channelType, address, session)) break block11;
                if (debugEnabled) {
                    this.log.debug("doInit(" + this + ")[" + (Object)((Object)this.type) + "][haveFilter=" + (filter != null) + "] filtered out " + address);
                }
                try {
                    f.setException(new SshChannelOpenException(this.getChannelId(), 1, "Connection denied"));
                }
                finally {
                    super.close(true);
                }
                return f;
            }
            catch (Error e) {
                this.warn("doInit({})[{}] failed ({}) to consult forwarding filter: {}", session, (Object)channelType, e.getClass().getSimpleName(), e.getMessage(), e);
                throw new RuntimeSshException((Throwable)e);
            }
        }
        this.out = new ChannelAsyncOutputStream(this, 94){

            @Override
            protected CloseFuture doCloseGracefully() {
                CloseFuture result = super.doCloseGracefully();
                result.addListener(f -> {
                    try {
                        TcpipServerChannel.this.sendEof();
                    }
                    catch (IOException e) {
                        session.exceptionCaught(e);
                    }
                });
                return result;
            }
        };
        IoServiceFactory ioServiceFactory = manager.getIoServiceFactory();
        this.connector = ioServiceFactory.createConnector((IoHandler)new PortIoHandler());
        IoConnectFuture future = this.connector.connect((SocketAddress)address.toInetSocketAddress(), null, this.getLocalAddress());
        future.addListener(future1 -> this.handleChannelConnectResult(f, (IoConnectFuture)future1));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelConnectResult(OpenFuture f, IoConnectFuture future) {
        try {
            if (future.isConnected()) {
                this.handleChannelOpenSuccess(f, future.getSession());
                return;
            }
            Throwable problem = ExceptionUtils.peelException((Throwable)future.getException());
            if (problem != null) {
                this.handleChannelOpenFailure(f, problem);
            }
        }
        catch (RuntimeException t) {
            Throwable e = ExceptionUtils.peelException((Throwable)t);
            this.signalChannelOpenFailure(e);
            try {
                f.setException(e);
            }
            finally {
                this.notifyStateChanged(e.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelOpenSuccess(OpenFuture f, IoSession session) {
        this.ioSession = session;
        String changeEvent = session.toString();
        try {
            this.signalChannelOpenSuccess();
            f.setOpened();
            session.resumeRead();
        }
        catch (Throwable t) {
            Throwable e = ExceptionUtils.peelException((Throwable)t);
            changeEvent = e.getClass().getSimpleName();
            this.signalChannelOpenFailure(e);
            f.setException(e);
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
    }

    protected void handleChannelOpenFailure(OpenFuture f, Throwable problem) {
        this.signalChannelOpenFailure(problem);
        this.notifyStateChanged(problem.getClass().getSimpleName());
        try {
            if (problem instanceof ConnectException) {
                f.setException(new SshChannelOpenException(this.getChannelId(), 2, problem.getMessage(), problem));
            } else {
                f.setException(problem);
            }
        }
        finally {
            this.close(true);
        }
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        IoSession session = this.getIoSession();
        if (session != null) {
            session.shutdownOutputStream();
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close((Closeable)this.out).close(super.getInnerCloseable()).close((Closeable)new AbstractCloseable(){
            private final CloseableExecutorService executor;
            {
                this.executor = ThreadUtils.newCachedThreadPool((String)("TcpIpServerChannel-ConnectorCleanup[" + TcpipServerChannel.this.getSession() + "]"));
            }

            protected CloseFuture doCloseGracefully() {
                this.executor.submit(() -> TcpipServerChannel.this.connector.close(false));
                return null;
            }

            protected void doCloseImmediately() {
                this.executor.submit(() -> (CloseFuture)TcpipServerChannel.this.connector.close(true).addListener(f -> this.executor.close(true)));
                super.doCloseImmediately();
            }
        }).build();
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue((len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Data length exceeds int boundaries: %d", (long)len);
        ByteArrayBuffer buf = ByteArrayBuffer.getCompactClone((byte[])data, (int)off, (int)((int)len));
        this.ioSession.writeBuffer((Buffer)buf).addListener(arg_0 -> this.lambda$doWriteData$1((Buffer)buf, len, arg_0));
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        throw new UnsupportedOperationException((Object)((Object)this.getTcpipChannelType()) + "Tcpip channel does not support extended data");
    }

    protected void handleWriteDataSuccess(byte cmd, byte[] data, int off, int len) {
        Session session = this.getSession();
        try {
            Window wLocal = this.getLocalWindow();
            wLocal.consumeAndCheck(len);
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataSuccess({})[{}] failed ({}) to consume len={}: {}", new Object[]{this, SshConstants.getCommandMessageName((int)(cmd & 0xFF)), e.getClass().getSimpleName(), len, e.getMessage()});
            }
            session.exceptionCaught(e);
        }
    }

    protected void handleWriteDataFailure(byte cmd, byte[] data, int off, int len, Throwable t) {
        this.debug("handleWriteDataFailure({})[{}] failed ({}) to write len={}: {}", this, SshConstants.getCommandMessageName((int)(cmd & 0xFF)), t.getClass().getSimpleName(), len, t.getMessage(), t);
        if (this.ioSession.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] closing session={}", new Object[]{this, SshConstants.getCommandMessageName((int)(cmd & 0xFF)), this.ioSession});
            }
            this.close(false);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Ignoring writeDataFailure {} because ioSession {} is already closing ", (Object)t, (Object)this.ioSession);
        }
    }

    private /* synthetic */ void lambda$doWriteData$1(Buffer buf, long len, IoWriteFuture future) {
        if (future.isWritten()) {
            this.handleWriteDataSuccess((byte)94, buf.array(), 0, (int)len);
        } else {
            this.handleWriteDataFailure((byte)94, buf.array(), 0, (int)len, future.getException());
        }
    }

    class PortIoHandler
    implements IoHandler {
        PortIoHandler() {
        }

        public void messageReceived(IoSession session, Readable message) throws Exception {
            if (TcpipServerChannel.this.isClosing()) {
                if (TcpipServerChannel.this.log.isDebugEnabled()) {
                    TcpipServerChannel.this.log.debug("messageReceived({}) Ignoring write to channel {} in CLOSING state", (Object)session, (Object)TcpipServerChannel.this);
                }
            } else {
                int length = message.available();
                ByteArrayBuffer buffer = new ByteArrayBuffer(length, false);
                buffer.putBuffer(message);
                session.suspendRead();
                ThreadUtils.runAsInternal(() -> this.lambda$messageReceived$1((Buffer)buffer, session));
            }
        }

        public void sessionCreated(IoSession session) throws Exception {
            session.suspendRead();
        }

        public void sessionClosed(IoSession session) throws Exception {
            TcpipServerChannel.this.close(false);
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            boolean immediately;
            boolean bl = immediately = !session.isOpen();
            if (TcpipServerChannel.this.log.isDebugEnabled()) {
                TcpipServerChannel.this.log.debug("exceptionCaught({}) signal close immediately={} due to {}[{}]", new Object[]{TcpipServerChannel.this, immediately, cause.getClass().getSimpleName(), cause.getMessage()});
            }
            TcpipServerChannel.this.close(immediately);
        }

        private /* synthetic */ IoWriteFuture lambda$messageReceived$1(Buffer buffer, IoSession session) throws Exception {
            return (IoWriteFuture)TcpipServerChannel.this.out.writeBuffer(buffer).addListener(f -> {
                session.resumeRead();
                Throwable e = f.getException();
                if (e != null) {
                    TcpipServerChannel.this.log.warn("messageReceived({}) channel={} signal close immediately=true due to {}[{}]", new Object[]{session, TcpipServerChannel.this, e.getClass().getSimpleName(), e.getMessage()});
                    TcpipServerChannel.this.close(true);
                } else if (TcpipServerChannel.this.log.isTraceEnabled()) {
                    TcpipServerChannel.this.log.trace("messageReceived({}) channel={} message forwarded", (Object)session, (Object)TcpipServerChannel.this);
                }
            });
        }
    }

    public static abstract class TcpipFactory
    implements ChannelFactory,
    ExecutorServiceCarrier {
        private final TcpForwardingFilter.Type type;

        protected TcpipFactory(TcpForwardingFilter.Type type) {
            this.type = type;
        }

        public final TcpForwardingFilter.Type getType() {
            return this.type;
        }

        public final String getName() {
            return this.type.getName();
        }

        public CloseableExecutorService getExecutorService() {
            return null;
        }

        @Override
        public Channel createChannel(Session session) throws IOException {
            return new TcpipServerChannel(this.getType(), ThreadUtils.noClose((CloseableExecutorService)this.getExecutorService()));
        }
    }
}

