import result
import os,platform
import json 

def evaluate(number_evaluation, design_variables, grad_request = False):   
    print('*-------------------------------------------------------*')
    print('*-------- Start the Task -------------------------------*')
    currentResult = {}
    outputFilename = 'output.out'
    inputFilename = 'input.in'
    HomeDir=os.getcwd()
    WorkDir="workdir%04d" % (number_evaluation)
    completeDir = os.path.join(HomeDir, WorkDir)
    if not os.access(WorkDir,os.F_OK): os.mkdir(WorkDir)

    ___write_output_file(number_evaluation, design_variables, grad_request,  outputFilename, os, completeDir)
    ___call_RCE(outputFilename, HomeDir, os, completeDir)
    currentResult = ___read_evaluation(completeDir, inputFilename)
    
    os.chdir(HomeDir)
    import shutil
    shutil.rmtree(WorkDir)
    return currentResult

def finalize(optimal_evaluation_number):
    resultFilename = 'generic.result'
    outFile = open(os.path.join(os.path.join(os.getcwd()), resultFilename), 'w+')
    outFile.write("%s\n" % optimal_evaluation_number)
    outFile.close()
   
def ___write_output_file(nEval, desVar, gradRequest, outputFilename, os, completeDir):
    output = {}
    output["gradRequest"] = gradRequest
    output["iterationNumber"] = nEval
    output["designVar"] = desVar
    outputFile = os.path.join(completeDir, outputFilename)
    with open(outputFile, 'w') as outfile:
        json.dump(output, outfile, sort_keys=True, indent=4, ensure_ascii=False)
    print("Wrote output file for RCE:" + outputFile)

def ___call_RCE(outputFilename, HomeDir, os, completeDir):
    javaHomeFile = open(os.path.join(HomeDir, "javaHome.txt"), "r")
    javaHome = javaHomeFile.readline()
    if not "Linux" in platform.platform():
        Command = "\"" + javaHome + "/java.exe\" -jar de.rcenvironment.components.optimizer.simulator.jar %s %s " % (completeDir, outputFilename)
    else:
        Command = "\"" + javaHome + "/java\" -jar de.rcenvironment.components.optimizer.simulator.jar %s %s " % (completeDir, outputFilename)
    os.system(Command)

def ___read_evaluation(completeDir, inputFilename):
    result.___read_evaluation(completeDir, inputFilename);
    return result

