/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.MappingNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.MappingType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.viewers.TreeNode;

public class ComponentNode
extends TreeNode
implements Comparable<ComponentNode> {
    private List<MappingNode> childNodes = new ArrayList<MappingNode>();
    private String componentName;
    private WorkflowNodeIdentifier workflowNodeIdentifier;

    public ComponentNode(TreeNode root, WorkflowNodeIdentifier workflowNodeIdentifier, String componentName) {
        super((Object)root);
        this.workflowNodeIdentifier = workflowNodeIdentifier;
        this.componentName = componentName;
        this.setParent(root);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public WorkflowNodeIdentifier getWorkflowNodeIdentifier() {
        return this.workflowNodeIdentifier;
    }

    public TreeNode[] getChildren() {
        return (TreeNode[])this.childNodes.stream().toArray(MappingNode[]::new);
    }

    public boolean hasChildren() {
        return !this.childNodes.isEmpty();
    }

    public void addChildNode(MappingNode node) {
        this.childNodes.add(node);
    }

    public boolean hasChildNode(String name, MappingType mappingType) {
        return this.childNodes.stream().anyMatch(n -> n.getInternalName().equals(name) && n.getMappingType() == mappingType);
    }

    public void removeChildNode(String inputName, MappingType mappingType) {
        Optional<MappingNode> node = this.childNodes.stream().filter(n -> n.getInternalName().equals(inputName) && n.getMappingType() == mappingType).findFirst();
        if (node.isPresent()) {
            this.childNodes.remove(node.get());
        }
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.componentName == null ? 0 : this.componentName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentNode other = (ComponentNode)obj;
        return !(this.componentName == null ? other.componentName != null : !this.componentName.equals(other.componentName));
    }

    @Override
    public int compareTo(ComponentNode o) {
        return this.getComponentName().compareToIgnoreCase(o.getComponentName());
    }
}

