/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.headless.api;

import de.rcenvironment.core.communication.spi.CallbackMethod;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.headless.internal.ExtendedHeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.internal.ConsoleRowFormatter;
import de.rcenvironment.core.notification.DefaultNotificationSubscriber;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsoleRowSubscriber
extends DefaultNotificationSubscriber
implements Closeable {
    private static final String LOG_FILE_SUFFIX = ".log";
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final long serialVersionUID = 1233786794388388297L;
    private final transient File finalLogFileDestination;
    private final transient File tempLogFileLocation;
    private final transient ExtendedHeadlessWorkflowExecutionContext workflowExecutionContext;
    private final transient Log log = LogFactory.getLog(this.getClass());
    private final transient ConsoleRowFormatter consoleRowFormatter = new ConsoleRowFormatter();
    private transient BufferedWriter bufferedLogWriter;

    public ConsoleRowSubscriber(ExtendedHeadlessWorkflowExecutionContext context, File logDirectory) {
        this.workflowExecutionContext = context;
        String consoleLogName = "workflow";
        this.finalLogFileDestination = new File(logDirectory, String.valueOf(consoleLogName) + LOG_FILE_SUFFIX);
        if (this.finalLogFileDestination.exists()) {
            this.log.warn((Object)("Log file does already exists; overwriting: " + this.finalLogFileDestination.getAbsolutePath()));
            this.finalLogFileDestination.delete();
            if (this.finalLogFileDestination.exists()) {
                this.log.warn((Object)("Failed to delete existing log file " + this.finalLogFileDestination.getAbsolutePath()));
            }
        }
        this.tempLogFileLocation = new File(logDirectory, String.valueOf(consoleLogName) + LOG_FILE_SUFFIX + TEMP_FILE_SUFFIX);
        if (!this.tempLogFileLocation.exists()) {
            try {
                if (!this.tempLogFileLocation.createNewFile()) {
                    throw new IOException("createNewFile() returned false");
                }
            }
            catch (IOException iOException) {
                Logger.getAnonymousLogger().warning("Could not create " + this.tempLogFileLocation.getAbsolutePath());
            }
        }
        this.bufferedLogWriter = this.setupLogWriter(this.tempLogFileLocation);
    }

    public Class<?> getInterface() {
        return NotificationSubscriber.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMetaInformation(String content) {
        ConsoleRowSubscriber consoleRowSubscriber = this;
        synchronized (consoleRowSubscriber) {
            if (this.bufferedLogWriter != null) {
                try {
                    this.bufferedLogWriter.write(this.consoleRowFormatter.toMetaInformationLine(content));
                }
                catch (IOException iOException) {
                    this.log.error((Object)("Error inserting this text line into the workflow log: " + content));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallbackMethod
    public void processNotification(Notification n) {
        Serializable body = n.getBody();
        if (!(body instanceof ConsoleRow)) {
            this.log.error((Object)("Unexpected notification type on ConsoleRow channel: body class is " + body.getClass()));
            return;
        }
        ConsoleRow row = (ConsoleRow)body;
        ConsoleRowSubscriber consoleRowSubscriber = this;
        synchronized (consoleRowSubscriber) {
            if (this.bufferedLogWriter != null) {
                try {
                    this.bufferedLogWriter.write(this.consoleRowFormatter.toSingleWorkflowLogFileFormat(row));
                }
                catch (IOException e) {
                    this.log.error((Object)("Closing log file " + this.tempLogFileLocation + " after error; the file will not be moved to its final location"), (Throwable)e);
                    IOUtils.closeQuietly((Writer)this.bufferedLogWriter);
                    this.bufferedLogWriter = null;
                }
            } else {
                if (row.getType() == ConsoleRow.Type.LIFE_CYCLE_EVENT && (row.getPayload().equals(StringUtils.escapeAndConcat((String[])new String[]{ConsoleRow.WorkflowLifecyleEventType.NEW_STATE.name(), WorkflowState.DISPOSING.name()})) || row.getPayload().equals(StringUtils.escapeAndConcat((String[])new String[]{ConsoleRow.WorkflowLifecyleEventType.NEW_STATE.name(), WorkflowState.DISPOSED.name()})))) {
                    return;
                }
                this.log.warn((Object)("Workflow log writer is already closed; ignoring event " + row.getType() + ":" + row.getPayload()));
            }
        }
        if (row.getType() == ConsoleRow.Type.LIFE_CYCLE_EVENT) {
            this.log.debug((Object)("Received workflow life-cycle event: " + row.getPayload()));
            if (ConsoleRow.WorkflowLifecyleEventType.WORKFLOW_FINISHED.name().equals(row.getPayload())) {
                this.workflowExecutionContext.reportConsoleOutputTerminated();
            }
        }
        this.workflowExecutionContext.reportConsoleRowReceived(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ConsoleRowSubscriber consoleRowSubscriber = this;
        synchronized (consoleRowSubscriber) {
            if (this.bufferedLogWriter != null) {
                this.log.debug((Object)("Closing temporary log file " + this.tempLogFileLocation));
                try {
                    this.bufferedLogWriter.close();
                    if (!this.finalLogFileDestination.isFile() && this.tempLogFileLocation.renameTo(this.finalLogFileDestination) && this.finalLogFileDestination.isFile()) {
                        this.log.debug((Object)("Completed workflow log file " + this.finalLogFileDestination));
                    } else {
                        this.log.warn((Object)("Failed to move log file " + this.tempLogFileLocation + " to final destination " + this.finalLogFileDestination));
                    }
                }
                catch (IOException e) {
                    this.log.warn((Object)("Exception while closing log file " + this.tempLogFileLocation), (Throwable)e);
                }
                this.bufferedLogWriter = null;
            } else {
                this.log.warn((Object)"close() called on already-closed workflow log writer");
            }
        }
    }

    private BufferedWriter setupLogWriter(File logFile) {
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new FileWriter(logFile));
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to open log file " + logFile + " for writing"), (Throwable)e);
        }
        return fw;
    }
}

