/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.incubator;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class NumericalTextConstraintListener
implements VerifyListener {
    protected static final String SMALL_E = "e";
    protected static final String E = "E";
    private static final String MINUS = "-";
    private static final String DOT = ".";
    private final int function;

    public NumericalTextConstraintListener(int function) {
        this.function = function;
    }

    public void verifyText(VerifyEvent e) {
        Text text = (Text)e.getSource();
        String oldS = text.getText();
        String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
        boolean valid = true;
        if ((this.function & 1) > 0) {
            valid &= this.checkIfInputIsFloat(newS);
        }
        if ((this.function & 2) > 0) {
            valid &= this.checkIfInputIsInt(newS);
        }
        if ((this.function & 0x10) > 0 && valid) {
            valid &= this.checkIfGreaterZero(newS);
        }
        if ((this.function & 4) > 0 && valid) {
            valid &= this.checkIfGreaterOrEqualZero(newS);
        }
        if ((this.function & 8) > 0 && valid) {
            valid &= this.checkIfGreaterOrEqualOne(newS);
        }
        if ((newS.equals(DOT) || newS.equals("-.")) && (this.function & 1) > 0 && (this.function & 8) <= 0) {
            valid = true;
        }
        if (newS.isEmpty() && !oldS.isEmpty()) {
            valid = true;
        }
        if (newS.equals(MINUS) && (this.function & 0x1C) <= 0) {
            valid = true;
        }
        if (newS.endsWith(MINUS) && (oldS.endsWith(SMALL_E) || oldS.endsWith(E))) {
            valid = true;
        }
        if (!((this.function & 1) <= 0 || oldS.contains(E) || oldS.contains(SMALL_E) || oldS.endsWith(DOT) || !newS.endsWith(E) && !newS.endsWith(SMALL_E))) {
            valid = this.checkIfInputIsFloat(oldS);
        }
        if ((this.function & 1) > 0 && oldS.length() > newS.length() && (newS.endsWith(E) || newS.endsWith(SMALL_E))) {
            valid = this.checkIfInputIsFloat(oldS);
        }
        if (this.checkIfInputIsFloat(oldS) && (newS.endsWith("E-") || newS.endsWith("e-")) && oldS.length() > newS.length()) {
            valid = true;
        }
        if (oldS.endsWith("E-") || oldS.endsWith("e-") && (newS.endsWith(E) || newS.endsWith(SMALL_E))) {
            valid = true;
        }
        if (e.text.contains(" ") || e.text.endsWith("d") || e.text.endsWith("D") || e.text.endsWith("f") || e.text.endsWith("F")) {
            valid = false;
        }
        e.doit = valid;
    }

    private boolean checkIfGreaterOrEqualOne(String newS) {
        try {
            float result = Float.parseFloat(newS);
            return result >= 1.0f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean checkIfGreaterOrEqualZero(String newS) {
        try {
            float result = Float.parseFloat(newS);
            return result >= 0.0f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean checkIfGreaterZero(String newS) {
        try {
            float result = Float.parseFloat(newS);
            return result > 0.0f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean checkIfInputIsInt(String newS) {
        try {
            Long.parseLong(newS);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean checkIfInputIsFloat(String newS) {
        block3: {
            try {
                if (!String.valueOf(Double.parseDouble(newS)).equals("Infinity") && !String.valueOf(Double.parseDouble(newS)).equals("-Infinity")) break block3;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        Float.parseFloat(newS);
        return true;
    }
}

