/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.internal;

import de.rcenvironment.core.component.workflow.execution.api.FinalWorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.notification.DefaultNotificationSubscriber;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationSubscriber;
import java.util.function.Consumer;

final class WorkflowStateNotificationHandler
extends DefaultNotificationSubscriber {
    private static final long serialVersionUID = 8010635011182816802L;
    private final Consumer<WorkflowState> workflowFinishedNotifier;
    private final Runnable heartbeat;
    private final String workflowExecutionIdentifier;

    WorkflowStateNotificationHandler(String workflowExecutionIdentifier, Runnable heartbeat, Consumer<WorkflowState> workflowFinishedNotifier) {
        this.heartbeat = heartbeat;
        this.workflowFinishedNotifier = workflowFinishedNotifier;
        this.workflowExecutionIdentifier = workflowExecutionIdentifier;
    }

    public Class<?> getInterface() {
        return NotificationSubscriber.class;
    }

    protected void processNotification(Notification notification) {
        if (!notification.getHeader().getNotificationIdentifier().equals("rce.component.workflow.state:" + this.workflowExecutionIdentifier)) {
            return;
        }
        if (!(notification.getBody() instanceof String)) {
            return;
        }
        String notificationBody = (String)((Object)notification.getBody());
        if (!WorkflowState.isWorkflowStateValid((String)notificationBody)) {
            return;
        }
        WorkflowState newWorkflowState = WorkflowState.valueOf((String)notificationBody);
        if (WorkflowState.IS_ALIVE.equals((Object)newWorkflowState)) {
            this.heartbeat.run();
        }
        if (!FinalWorkflowState.isFinalWorkflowState((WorkflowState)newWorkflowState)) {
            return;
        }
        this.workflowFinishedNotifier.accept(newWorkflowState);
    }
}

