/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.validation.internal;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.api.ComponentValidatorListService;
import de.rcenvironment.core.component.validation.spi.ComponentValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class ComponentValidatorListServiceImpl
implements ComponentValidatorListService {
    private Map<String, ComponentValidator> validatorMap = new HashMap<String, ComponentValidator>();

    @Override
    public List<ComponentValidationMessage> validateComponentDescription(ComponentDescription componentDescription, boolean onWorkflowStart) {
        String identifier = componentDescription.getComponentInterface().getIdentifierAndVersion().split("/")[0];
        if (this.validatorMap.containsKey(identifier)) {
            return this.validatorMap.get(identifier).validate(componentDescription, onWorkflowStart);
        }
        LogFactory.getLog(this.getClass()).debug((Object)("There is no validator registered for the identifier: " + identifier + ". Default Validator used for: " + componentDescription.getName()));
        return this.validatorMap.get("de.rcenviornment.defaultComponentValidator").validate(componentDescription, onWorkflowStart);
    }

    public void addComponentValidator(ComponentValidator componentValidator) {
        this.validatorMap.put(componentValidator.getIdentifier(), componentValidator);
    }

    public void removeComponentValidator(ComponentValidator componentValidator) {
        this.validatorMap.remove(componentValidator.getIdentifier());
    }
}

