/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.api.LoopComponentConstants;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class FaultTolerantLoopSection
extends ValidatingWorkflowNodePropertySection
implements PropertyChangeListener {
    private static final String TEXT_DISCARD = "Discard the evaluation loop run and continue with next one";
    private static final String TEXT_RERUN_EVALUATION_LOOP = "Rerun the evaluation loop at the maximum of";
    private static final String TEXT_FINALLY_FAIL = "If an evaluation loop run was discarded, finally fail on loop termination (only applicable outside nested loops)";
    private static final String TEXT_ONLY_FAIL_LOOP = "Only fail the loop and forward failure to outer loop (only applicable if used in nested loop)";
    private boolean listenerRegistered = false;
    private Button failRadioButtonNAV;
    private Button discardAndContinueRadioButtonNAV;
    private Label labelDiscardAndContinue;
    private Button rerunAndDiscardRadioButtonNAV;
    private Label labelRerunAndDiscard;
    private Text rerunTimesAndFailTextNAV;
    private Button rerunAndFailRadioButtonNAV;
    private Text rerunTimesAndDiscardTextNAV;
    private Label rerunTimesAndDiscardLabelNAV;
    private Button failLoopIfAnyRunFailedCheckboxNAV;
    private Label labelFinallyFail;
    private Button onlyFailLoopCheckboxNAV;
    private Label labelOnlyFailLoop;
    private Button failRadioButtonCmpFlr;
    private Button discardAndContinueRadioButtonCmpFlr;
    private Label labelDiscardAndContinueCmpFlr;
    private boolean loopDriverSupportsDiscard;

    @Override
    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayout((Layout)new GridLayout(1, false));
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section sectionPropertiesNAV = factory.createSection(parent, 320);
        sectionPropertiesNAV.setLayoutData((Object)new GridData(768));
        sectionPropertiesNAV.setText("Fault-tolerance in case of 'not-a-value' received");
        Composite compositeNAV = factory.createFlatFormComposite(parent);
        compositeNAV.setLayout((Layout)new GridLayout(4, false));
        Label labelNAV = factory.createLabel(compositeNAV, "If a component in the loop sent 'not-a-value':");
        this.spanHorizontal((Control)labelNAV, 4);
        BehaviorInCaseOfFailureSelectionListenerNAV listenerNAV = new BehaviorInCaseOfFailureSelectionListenerNAV();
        this.failRadioButtonNAV = new Button(compositeNAV, 16);
        this.createLabel(compositeNAV, "Fail", true);
        this.failRadioButtonNAV.setData("faultTolerance-NAV_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail);
        this.failRadioButtonNAV.addSelectionListener((SelectionListener)listenerNAV);
        this.failRadioButtonNAV.setData("property.control", (Object)"faultTolerance-NAV_5e0ed1cd");
        this.discardAndContinueRadioButtonNAV = new Button(compositeNAV, 16);
        this.labelDiscardAndContinue = this.createLabel(compositeNAV, TEXT_DISCARD, true);
        this.discardAndContinueRadioButtonNAV.setData("faultTolerance-NAV_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard);
        this.discardAndContinueRadioButtonNAV.addSelectionListener((SelectionListener)listenerNAV);
        this.rerunAndFailRadioButtonNAV = new Button(compositeNAV, 16);
        this.createLabel(compositeNAV, TEXT_RERUN_EVALUATION_LOOP, false);
        this.rerunAndFailRadioButtonNAV.setData("faultTolerance-NAV_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndFail);
        this.rerunAndFailRadioButtonNAV.addSelectionListener((SelectionListener)listenerNAV);
        this.rerunTimesAndFailTextNAV = new Text(compositeNAV, 0x1000800);
        GridData gridData = new GridData(0x1000000);
        gridData.widthHint = 40;
        this.rerunTimesAndFailTextNAV.setLayoutData((Object)gridData);
        this.rerunTimesAndFailTextNAV.setData("property.control", (Object)"maxRerunBeforeFail-NAV_5e0ed1cd");
        this.rerunTimesAndFailTextNAV.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(18));
        factory.createLabel(compositeNAV, "time(s) and fail if maximum exceeded");
        this.rerunAndDiscardRadioButtonNAV = new Button(compositeNAV, 16);
        this.labelRerunAndDiscard = this.createLabel(compositeNAV, TEXT_RERUN_EVALUATION_LOOP, false);
        this.rerunAndDiscardRadioButtonNAV.setData("faultTolerance-NAV_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndDiscard);
        this.rerunAndDiscardRadioButtonNAV.addSelectionListener((SelectionListener)listenerNAV);
        this.rerunTimesAndDiscardTextNAV = new Text(compositeNAV, 0x1000800);
        gridData = new GridData();
        gridData.widthHint = 40;
        this.rerunTimesAndDiscardTextNAV.setLayoutData((Object)gridData);
        this.rerunTimesAndDiscardTextNAV.setData("property.control", (Object)"maxRerunBeforeDiscard-NAV_5e0ed1cd");
        this.rerunTimesAndDiscardTextNAV.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(18));
        this.rerunTimesAndDiscardLabelNAV = factory.createLabel(compositeNAV, "time(s) and discard if maximum exceeded");
        this.failLoopIfAnyRunFailedCheckboxNAV = new Button(compositeNAV, 32);
        this.labelFinallyFail = this.createLabel(compositeNAV, TEXT_FINALLY_FAIL, true);
        this.failLoopIfAnyRunFailedCheckboxNAV.setData("property.control", (Object)"finallyFailIfDiscarded-NAV_5e0ed1cd");
        this.onlyFailLoopCheckboxNAV = new Button(compositeNAV, 32);
        this.labelOnlyFailLoop = this.createLabel(compositeNAV, TEXT_ONLY_FAIL_LOOP, true);
        this.onlyFailLoopCheckboxNAV.setData("property.control", (Object)"failLoopOnly-NAV_5e0ed1cd");
        Section sectionPropertiesCmpFlr = factory.createSection(parent, 320);
        sectionPropertiesCmpFlr.setLayoutData((Object)new GridData(768));
        sectionPropertiesCmpFlr.setText("Fault-tolerance in case of component failure");
        Composite compositeCmpFlr = factory.createFlatFormComposite(parent);
        compositeCmpFlr.setLayout((Layout)new GridLayout(2, false));
        Label labelComponentFailure = factory.createLabel(compositeCmpFlr, "If a component in the loop fails:");
        this.spanHorizontal((Control)labelComponentFailure, 2);
        BehaviorInCaseOfFailureSelectionListenerCompFailure listenerCmpFlr = new BehaviorInCaseOfFailureSelectionListenerCompFailure();
        this.failRadioButtonCmpFlr = new Button(compositeCmpFlr, 16);
        this.createLabel(compositeCmpFlr, "Fail component", false);
        this.failRadioButtonCmpFlr.setData("loopFaultTolerance_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail);
        this.failRadioButtonCmpFlr.addSelectionListener((SelectionListener)listenerCmpFlr);
        this.failRadioButtonCmpFlr.setData("property.control", (Object)"loopFaultTolerance_5e0ed1cd");
        this.discardAndContinueRadioButtonCmpFlr = new Button(compositeCmpFlr, 16);
        this.labelDiscardAndContinueCmpFlr = this.createLabel(compositeCmpFlr, TEXT_DISCARD, false);
        this.discardAndContinueRadioButtonCmpFlr.setData("loopFaultTolerance_5e0ed1cd", (Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard);
        this.discardAndContinueRadioButtonCmpFlr.addSelectionListener((SelectionListener)listenerCmpFlr);
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.node != null && !this.listenerRegistered) {
            this.node.addPropertyChangeListener((PropertyChangeListener)this);
            this.listenerRegistered = true;
        }
    }

    @Override
    protected void beforeTearingDownModelBinding() {
        if (this.node != null) {
            this.node.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.listenerRegistered = false;
        super.beforeTearingDownModelBinding();
    }

    private Label createLabel(Composite parent, String labelText, boolean spanLabel) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setBackground(Display.getDefault().getSystemColor(1));
        if (spanLabel) {
            this.spanHorizontal((Control)label, 3);
        }
        return label;
    }

    private void spanHorizontal(Control control, int span) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        control.setLayoutData((Object)gridData);
    }

    @Override
    protected void setWorkflowNode(WorkflowNode workflowNode) {
        super.setWorkflowNode(workflowNode);
        LoopComponentConstants.LoopBehaviorInCaseOfFailure loopBehaviorInCaseOfFailureNAV = LoopComponentConstants.LoopBehaviorInCaseOfFailure.fromString((String)this.getProperty("faultTolerance-NAV_5e0ed1cd"));
        LoopComponentConstants.LoopBehaviorInCaseOfFailure loopBehaviorInCaseOfFailureCmpFlr = LoopComponentConstants.LoopBehaviorInCaseOfFailure.fromString((String)this.getProperty("loopFaultTolerance_5e0ed1cd"));
        this.loopDriverSupportsDiscard = workflowNode.getComponentDescription().getComponentInterface().getLoopDriverSupportsDiscard();
        this.failRadioButtonNAV.setSelection(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail));
        this.failRadioButtonCmpFlr.setSelection(loopBehaviorInCaseOfFailureCmpFlr.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail));
        this.rerunAndFailRadioButtonNAV.setSelection(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndFail));
        this.rerunTimesAndFailTextNAV.setEnabled(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndFail));
        Boolean isNestedLoop = Boolean.valueOf(this.getProperty("isNestedLoop_5e0ed1cd"));
        boolean onlyFailEnabled = (loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Fail) || loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndFail)) && isNestedLoop != false;
        this.onlyFailLoopCheckboxNAV.setEnabled(onlyFailEnabled);
        this.labelOnlyFailLoop.setEnabled(onlyFailEnabled);
        this.discardAndContinueRadioButtonNAV.setEnabled(this.loopDriverSupportsDiscard);
        this.labelDiscardAndContinue.setEnabled(this.loopDriverSupportsDiscard);
        this.discardAndContinueRadioButtonCmpFlr.setEnabled(this.loopDriverSupportsDiscard);
        this.labelDiscardAndContinueCmpFlr.setEnabled(this.loopDriverSupportsDiscard);
        this.rerunAndDiscardRadioButtonNAV.setEnabled(this.loopDriverSupportsDiscard);
        this.labelRerunAndDiscard.setEnabled(this.loopDriverSupportsDiscard);
        this.rerunTimesAndDiscardTextNAV.setEnabled(this.loopDriverSupportsDiscard);
        this.rerunTimesAndDiscardLabelNAV.setEnabled(this.loopDriverSupportsDiscard);
        boolean finallyFailEnabled = this.loopDriverSupportsDiscard && isNestedLoop == false;
        this.failLoopIfAnyRunFailedCheckboxNAV.setEnabled(finallyFailEnabled);
        this.labelFinallyFail.setEnabled(finallyFailEnabled);
        if (this.loopDriverSupportsDiscard) {
            this.discardAndContinueRadioButtonNAV.setSelection(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard));
            this.discardAndContinueRadioButtonCmpFlr.setSelection(loopBehaviorInCaseOfFailureCmpFlr.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard));
            this.rerunAndDiscardRadioButtonNAV.setSelection(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndDiscard));
            this.rerunTimesAndDiscardTextNAV.setEnabled(loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndDiscard));
            this.failLoopIfAnyRunFailedCheckboxNAV.setEnabled(this.failLoopIfAnyRunFailedCheckboxNAV.getEnabled() && (loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard) || loopBehaviorInCaseOfFailureNAV.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.RerunAndDiscard)));
        }
        this.setActivationOfCheckboxes();
    }

    private void setActivationOfCheckboxes() {
        boolean isNestedLoop = Boolean.valueOf(this.getProperty("isNestedLoop_5e0ed1cd"));
        this.failLoopIfAnyRunFailedCheckboxNAV.setEnabled(!isNestedLoop && (this.discardAndContinueRadioButtonNAV.getSelection() || this.rerunAndDiscardRadioButtonNAV.getSelection()));
        this.onlyFailLoopCheckboxNAV.setEnabled(isNestedLoop && (this.failRadioButtonNAV.getSelection() || this.rerunAndFailRadioButtonNAV.getSelection()));
        this.setSelectionOfCheckbox();
    }

    private void setSelectionOfCheckbox() {
        String prop;
        if (!this.failLoopIfAnyRunFailedCheckboxNAV.isEnabled()) {
            this.failLoopIfAnyRunFailedCheckboxNAV.setSelection(false);
            this.setProperty("finallyFailIfDiscarded-NAV_5e0ed1cd", "false");
        } else {
            prop = this.getProperty("finallyFailIfDiscarded-NAV_5e0ed1cd");
            this.failLoopIfAnyRunFailedCheckboxNAV.setSelection(Boolean.parseBoolean(prop));
        }
        if (!this.onlyFailLoopCheckboxNAV.isEnabled()) {
            this.onlyFailLoopCheckboxNAV.setSelection(false);
            this.setProperty("failLoopOnly-NAV_5e0ed1cd", "false");
        } else {
            prop = this.getProperty("failLoopOnly-NAV_5e0ed1cd");
            this.onlyFailLoopCheckboxNAV.setSelection(Boolean.parseBoolean(prop));
        }
    }

    @Override
    protected FaultToleranceController createController() {
        return new FaultToleranceController();
    }

    @Override
    protected FaultToleranceUpdater createUpdater() {
        return new FaultToleranceUpdater();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("properties.isNestedLoop_5e0ed1cd")) {
            this.setWorkflowNode(this.node);
        }
    }

    private class BehaviorInCaseOfFailureSelectionListenerCompFailure
    implements SelectionListener {
        private BehaviorInCaseOfFailureSelectionListenerCompFailure() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            Button button = (Button)event.getSource();
            FaultTolerantLoopSection.this.setProperty("loopFaultTolerance_5e0ed1cd", button.getData("loopFaultTolerance_5e0ed1cd").toString());
        }
    }

    private class BehaviorInCaseOfFailureSelectionListenerNAV
    implements SelectionListener {
        private BehaviorInCaseOfFailureSelectionListenerNAV() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            Button button = (Button)event.getSource();
            FaultTolerantLoopSection.this.setProperty("faultTolerance-NAV_5e0ed1cd", button.getData("faultTolerance-NAV_5e0ed1cd").toString());
            FaultTolerantLoopSection.this.rerunTimesAndFailTextNAV.setEnabled(button == FaultTolerantLoopSection.this.rerunAndFailRadioButtonNAV);
            FaultTolerantLoopSection.this.rerunTimesAndDiscardTextNAV.setEnabled(button == FaultTolerantLoopSection.this.rerunAndDiscardRadioButtonNAV);
        }
    }

    protected class FaultToleranceController
    extends WorkflowNodePropertySection.DefaultController {
        protected FaultToleranceController() {
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent event) {
        }

        @Override
        public void widgetSelected(SelectionEvent event) {
            Button button = (Button)event.getSource();
            if (button.getData("property.control") != null && (button.getData("property.control").equals("finallyFailIfDiscarded-NAV_5e0ed1cd") || button.getData("property.control").equals("failLoopOnly-NAV_5e0ed1cd"))) {
                super.widgetSelected(event);
            }
        }
    }

    protected class FaultToleranceUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected FaultToleranceUpdater() {
        }

        @Override
        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            if (control instanceof Text) {
                super.updateControl(control, propertyName, newValue, oldValue);
            }
            if (control instanceof Button && oldValue != null) {
                if (!propertyName.equals("finallyFailIfDiscarded-NAV_5e0ed1cd") && !propertyName.equals("failLoopOnly-NAV_5e0ed1cd")) {
                    FaultTolerantLoopSection.this.setWorkflowNode(FaultTolerantLoopSection.this.node);
                } else {
                    super.updateControl(control, propertyName, newValue, oldValue);
                }
            }
        }
    }
}

