/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.common.impl;

import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.monitoring.common.spi.PeriodicMonitoringDataContributor;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.objectbindings.api.ObjectBindingsConsumer;
import de.rcenvironment.toolkit.modules.objectbindings.api.ObjectBindingsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PeriodicMonitoringServiceImpl {
    private static final int DEFAULT_MONITORING_INTERVAL_SECS = 15;
    private ConfigurationService configurationService;
    private final Map<String, PeriodicMonitoringDataContributor> contributors = new HashMap<String, PeriodicMonitoringDataContributor>();
    private final Set<String> activeTopics = new HashSet<String>();
    private final Log log = LogFactory.getLog(this.getClass());
    private ScheduledFuture<?> taskFuture;
    private int intervalSec = 15;
    private ObjectBindingsService objectBindingsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        if (!CommandLineArguments.isNormalOperationRequested()) {
            this.log.debug((Object)"Not running in standard mode - not starting background monitoring");
            return;
        }
        Set<String> set = this.activeTopics;
        synchronized (set) {
            this.loadConfigurationData();
            this.logActiveTopics();
        }
        this.taskFuture = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedInterval("Periodic background monitoring task", (Runnable)new BackgroundTask(), TimeUnit.SECONDS.toMillis(this.intervalSec));
        this.objectBindingsService.setConsumer(PeriodicMonitoringDataContributor.class, (ObjectBindingsConsumer)new ObjectBindingsConsumer<PeriodicMonitoringDataContributor>(){

            public void addInstance(PeriodicMonitoringDataContributor instance) {
                PeriodicMonitoringServiceImpl.this.addContributor(instance);
            }

            public void removeInstance(PeriodicMonitoringDataContributor instance) {
                PeriodicMonitoringServiceImpl.this.removeContributor(instance);
            }
        });
    }

    public void deactivate() {
        if (this.taskFuture != null) {
            this.taskFuture.cancel(false);
            this.taskFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContributor(PeriodicMonitoringDataContributor contributor) {
        Map<String, PeriodicMonitoringDataContributor> map = this.contributors;
        synchronized (map) {
            for (String id : contributor.getTopicIds()) {
                this.contributors.put(id, contributor);
                this.logAvailableMonitoringId(id, contributor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContributor(PeriodicMonitoringDataContributor contributor) {
        Map<String, PeriodicMonitoringDataContributor> map = this.contributors;
        synchronized (map) {
            for (String id : contributor.getTopicIds()) {
                this.log.debug((Object)("Unregistering monitoring id " + id));
                this.contributors.remove(id);
            }
        }
    }

    public void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    public void bindObjectBindingsService(ObjectBindingsService newInstance) {
        this.objectBindingsService = newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigurationData() {
        Set<String> set = this.activeTopics;
        synchronized (set) {
            this.activeTopics.clear();
            ConfigurationSegment configurationSegment = this.configurationService.getConfigurationSegment("backgroundMonitoring");
            if (configurationSegment != null) {
                String topicsString = configurationSegment.getString("enabledIds", "");
                if (topicsString != null) {
                    String[] stringArray = topicsString.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String rawId = stringArray[n2];
                        String id = rawId.trim();
                        if (!id.isEmpty()) {
                            this.activeTopics.add(id);
                        }
                        ++n2;
                    }
                }
                this.intervalSec = configurationSegment.getInteger("intervalSeconds", Integer.valueOf(15));
                if (this.intervalSec < 1) {
                    this.log.warn((Object)StringUtils.format((String)"Resource monitoring interval (configuration value 'intervalSeconds') is invalid: it is %d seconds but must be >= 1 second; default value of %d seconds is applied", (Object[])new Object[]{this.intervalSec, 15}));
                    this.intervalSec = 15;
                }
                if (this.activeTopics.isEmpty()) {
                    this.log.debug((Object)"No monitoring topics configured");
                }
            } else {
                this.intervalSec = 15;
            }
        }
    }

    private void logAvailableMonitoringId(String id, PeriodicMonitoringDataContributor contributor) {
        this.log.debug((Object)StringUtils.format((String)"Monitoring topic available: \"%s\" (\"%s\")", (Object[])new Object[]{id, contributor.getTopicDescription(id)}));
    }

    private void logActiveTopics() {
        this.log.debug((Object)("Active monitoring topics: " + Arrays.toString(this.activeTopics.toArray())));
    }

    private final class BackgroundTask
    implements Runnable {
        private BackgroundTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<String> output;
            Set set = PeriodicMonitoringServiceImpl.this.activeTopics;
            synchronized (set) {
                if (PeriodicMonitoringServiceImpl.this.activeTopics.isEmpty()) {
                    return;
                }
                output = new ArrayList<String>();
                Map map = PeriodicMonitoringServiceImpl.this.contributors;
                synchronized (map) {
                    Iterator iter = PeriodicMonitoringServiceImpl.this.activeTopics.iterator();
                    while (iter.hasNext()) {
                        String id = (String)iter.next();
                        PeriodicMonitoringDataContributor contributor = (PeriodicMonitoringDataContributor)PeriodicMonitoringServiceImpl.this.contributors.get(id);
                        if (contributor != null) {
                            contributor.generateOutput(id, output);
                            continue;
                        }
                        PeriodicMonitoringServiceImpl.this.log.warn((Object)("No monitoring contributor found for configured monitoring id '" + id + "'; deactivating id"));
                        iter.remove();
                    }
                }
            }
            for (String line : output) {
                PeriodicMonitoringServiceImpl.this.log.info((Object)line);
            }
        }
    }
}

