/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.channel;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.configuration.ConnectionFilter;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.transport.spi.MessageChannelEndpointHandler;
import de.rcenvironment.core.communication.transport.spi.NetworkTransportProvider;
import de.rcenvironment.core.eventlog.api.EventLog;
import de.rcenvironment.core.eventlog.api.EventLogEntry;
import de.rcenvironment.core.eventlog.api.EventType;
import de.rcenvironment.core.utils.common.StringUtils;

public class ServerContactPoint {
    private static final String EVENT_LOG_VALUE_CONNECTION_TYPE = "localnet";
    private final NetworkContactPoint networkContactPoint;
    private final MessageChannelEndpointHandler endpointHandler;
    private final String expectedProtocolVersion;
    private final NetworkTransportProvider transportProvider;
    private final ConnectionFilter connectionFilter;
    private volatile boolean acceptingMessages = false;
    private volatile boolean simulatingBreakdown;

    public ServerContactPoint(NetworkTransportProvider transportProvider, NetworkContactPoint ncp, String expectedProtocolVersion, MessageChannelEndpointHandler endpointHandler, ConnectionFilter connectionFilter) {
        this.transportProvider = transportProvider;
        this.networkContactPoint = ncp;
        this.endpointHandler = endpointHandler;
        this.expectedProtocolVersion = expectedProtocolVersion;
        this.connectionFilter = connectionFilter;
    }

    public NetworkContactPoint getNetworkContactPoint() {
        return this.networkContactPoint;
    }

    public MessageChannelEndpointHandler getEndpointHandler() {
        return this.endpointHandler;
    }

    public String getExpectedProtocolVersion() {
        return this.expectedProtocolVersion;
    }

    public ConnectionFilter getConnectionFilter() {
        return this.connectionFilter;
    }

    public synchronized boolean isAcceptingMessages() {
        return this.acceptingMessages;
    }

    public String toString() {
        return StringUtils.format((String)"SCP (NCP='%s', acc=%s, simbr=%s)", (Object[])new Object[]{this.networkContactPoint, this.acceptingMessages, this.simulatingBreakdown});
    }

    public String getTransportId() {
        return this.getNetworkContactPoint().getTransportId();
    }

    public synchronized void start() throws CommunicationException {
        this.transportProvider.startServer(this);
        this.acceptingMessages = true;
        EventLog.append((EventLogEntry)EventLog.newEntry((EventType)EventType.SERVERPORT_OPENED).set("type", EVENT_LOG_VALUE_CONNECTION_TYPE).set("bind_ip", this.networkContactPoint.getHost()).set("port", this.networkContactPoint.getPort()));
    }

    public synchronized void shutDown() {
        this.acceptingMessages = false;
        this.transportProvider.stopServer(this);
        EventLog.append((EventLogEntry)EventLog.newEntry((EventType)EventType.SERVERPORT_CLOSED).set("type", EVENT_LOG_VALUE_CONNECTION_TYPE).set("bind_ip", this.networkContactPoint.getHost()).set("port", this.networkContactPoint.getPort()));
    }

    public boolean isSimulatingBreakdown() {
        return this.simulatingBreakdown;
    }

    public void setSimulatingBreakdown(boolean simulatingBreakdown) {
        this.simulatingBreakdown = simulatingBreakdown;
    }
}

