/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.update.api;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public final class PersistentComponentDescriptionUpdaterUtils {
    private static ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();

    private PersistentComponentDescriptionUpdaterUtils() {
    }

    public static PersistentComponentDescription updateAllDynamicEndpointsToIdentifier(String direction, String identifier, PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode dynEndpoints = node.get(direction);
        if (dynEndpoints != null) {
            for (JsonNode endpoint : dynEndpoints) {
                if (endpoint.get("epIdentifier") != null && !endpoint.get("epIdentifier").equals((Object)"null") && !endpoint.get("epIdentifier").isNull()) continue;
                ((ObjectNode)endpoint).remove("epIdentifier");
                ((ObjectNode)endpoint).set("epIdentifier", (JsonNode)TextNode.valueOf((String)identifier));
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription removeOuterLoopDoneEndpoints(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        PersistentComponentDescriptionUpdaterUtils.removeOuterLoopDoneEndpoint(node, "staticOutputs", "name", "Outer loop done");
        PersistentComponentDescriptionUpdaterUtils.removeOuterLoopDoneEndpoint(node, "dynamicInputs", "epIdentifier", "outerLoopDone");
        return new PersistentComponentDescription(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
    }

    private static void removeOuterLoopDoneEndpoint(JsonNode node, String endpointGroup, String identifyingKey, String identifyingValue) {
        if (node.has(endpointGroup)) {
            ArrayNode endpointsJsonNode = (ArrayNode)node.get(endpointGroup);
            Iterator elements = endpointsJsonNode.elements();
            while (elements.hasNext()) {
                ObjectNode endpointJsonNode = (ObjectNode)elements.next();
                if (!endpointJsonNode.get(identifyingKey).textValue().equals(identifyingValue)) continue;
                elements.remove();
                break;
            }
        }
    }

    public static PersistentComponentDescription removeEndpointCharacterInfoFromMetaData(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData(node, "staticInputs");
        PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData(node, "staticOutputs");
        PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData(node, "dynamicInputs");
        PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData(node, "dynamicOutputs");
        return new PersistentComponentDescription(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
    }

    private static void removeEndpointCharacterInfoFromMetaData(JsonNode node, String endpointGroup) {
        if (node.has(endpointGroup)) {
            ArrayNode endpointsJsonNode = (ArrayNode)node.get(endpointGroup);
            Iterator elements = endpointsJsonNode.elements();
            block0: while (elements.hasNext()) {
                JsonNode endpointJsonNode = (JsonNode)elements.next();
                if (!endpointJsonNode.has("metadata")) continue;
                JsonNode metaDataJsonNode = endpointJsonNode.get("metadata");
                Iterator metaDataFields = metaDataJsonNode.fields();
                while (metaDataFields.hasNext()) {
                    Map.Entry nextMetaDataField = (Map.Entry)metaDataFields.next();
                    if (!((String)nextMetaDataField.getKey()).equals("loopEndpointType_5e0ed1cd")) continue;
                    metaDataFields.remove();
                    continue block0;
                }
            }
        }
    }

    public static PersistentComponentDescription reassignEndpointIdentifiers(PersistentComponentDescription description, String endpointGroup, String epIdentifier, String epIdentifierToReplace, String epNameSuffix) throws JsonProcessingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        if (node.has(endpointGroup)) {
            ArrayNode endpointsJsonNode = (ArrayNode)node.get(endpointGroup);
            Iterator elements = endpointsJsonNode.elements();
            while (elements.hasNext()) {
                JsonNode endpointJsonNode = (JsonNode)elements.next();
                if (!endpointJsonNode.has("epIdentifier") || !endpointJsonNode.get("epIdentifier").textValue().equals(epIdentifier) || !endpointJsonNode.get("name").textValue().endsWith(epNameSuffix)) continue;
                ((ObjectNode)endpointJsonNode).put("epIdentifier", epIdentifierToReplace);
            }
        }
        return new PersistentComponentDescription(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateFaultToleranceOfLoopDriver(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode configJsonNode = node.get("configuration");
        if (configJsonNode instanceof ObjectNode) {
            String configKeyFinallyFailIfDiscarded;
            String configKeyFailLoopOnly;
            String configKeyMaxRerunBeforeDiscard;
            String configKeyMaxRerunBeforeFail;
            ObjectNode configObjectNode = (ObjectNode)configJsonNode;
            String confgKeyFaultToleranceNAV = "loopFaultTolerance_5e0ed1cd";
            if (configObjectNode.has(confgKeyFaultToleranceNAV)) {
                String faultToleranceNAV = configObjectNode.get(confgKeyFaultToleranceNAV).textValue();
                configObjectNode.put(confgKeyFaultToleranceNAV, "Fail");
                configObjectNode.put("faultTolerance-NAV_5e0ed1cd", faultToleranceNAV);
            }
            if (configObjectNode.has(configKeyMaxRerunBeforeFail = "loopRerunAndFail_5e0ed1cd")) {
                String faultToleranceNAV = configObjectNode.get(configKeyMaxRerunBeforeFail).textValue();
                configObjectNode.remove(configKeyMaxRerunBeforeFail);
                configObjectNode.put("maxRerunBeforeFail-NAV_5e0ed1cd", faultToleranceNAV);
            }
            if (configObjectNode.has(configKeyMaxRerunBeforeDiscard = "loopRerunAndDiscard_5e0ed1cd")) {
                String faultToleranceNAV = configObjectNode.get(configKeyMaxRerunBeforeDiscard).textValue();
                configObjectNode.remove(configKeyMaxRerunBeforeDiscard);
                configObjectNode.put("maxRerunBeforeDiscard-NAV_5e0ed1cd", faultToleranceNAV);
            }
            if (configObjectNode.has(configKeyFailLoopOnly = "failLoop_5e0ed1cd")) {
                String faultToleranceNAV = configObjectNode.get(configKeyFailLoopOnly).textValue();
                configObjectNode.remove(configKeyFailLoopOnly);
                configObjectNode.put("failLoopOnly-NAV_5e0ed1cd", faultToleranceNAV);
            }
            if (configObjectNode.has(configKeyFinallyFailIfDiscarded = "finallyFail_5e0ed1cd")) {
                String faultToleranceNAV = configObjectNode.get(configKeyFinallyFailIfDiscarded).textValue();
                configObjectNode.remove(configKeyFinallyFailIfDiscarded);
                configObjectNode.put("finallyFailIfDiscarded-NAV_5e0ed1cd", faultToleranceNAV);
            }
        }
        return new PersistentComponentDescription(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateSchedulingInformation(PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser jsonParser = jsonFactory.createParser(description.getComponentDescriptionAsString());
        JsonNode node = (JsonNode)mapper.readTree(jsonParser);
        jsonParser.close();
        PersistentComponentDescriptionUpdaterUtils.updateInputNode(node.get("dynamicInputs"));
        PersistentComponentDescriptionUpdaterUtils.updateInputNode(node.get("staticInputs"));
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        return description;
    }

    public static PersistentComponentDescription updateIsNestedLoop(PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser jsonParser = jsonFactory.createParser(description.getComponentDescriptionAsString());
        JsonNode node = (JsonNode)mapper.readTree(jsonParser);
        jsonParser.close();
        String oldConfigKey = "isNestedLoop";
        ObjectNode configurationsNode = (ObjectNode)node.get("configuration");
        if (configurationsNode != null && configurationsNode.has(oldConfigKey)) {
            boolean isNestedLoop = configurationsNode.get(oldConfigKey).asBoolean();
            configurationsNode.remove(oldConfigKey);
            configurationsNode.put("isNestedLoop_5e0ed1cd", isNestedLoop);
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        return description;
    }

    private static void updateInputNode(JsonNode inputNode) {
        block14: {
            if (inputNode == null) break block14;
            Iterator nodeIterator = inputNode.elements();
            while (nodeIterator.hasNext()) {
                String usage;
                JsonNode dynInputNode = (JsonNode)nodeIterator.next();
                ObjectNode jsonNode = (ObjectNode)dynInputNode.get("metadata");
                JsonNode usageJsonNode = jsonNode.get("usage");
                if (usageJsonNode == null) continue;
                switch (usage = usageJsonNode.textValue()) {
                    case "required": {
                        jsonNode.put("inputHandling_73b1056e", EndpointDefinition.InputDatumHandling.Single.name());
                        jsonNode.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
                        break;
                    }
                    case "initial": {
                        jsonNode.put("inputHandling_73b1056e", EndpointDefinition.InputDatumHandling.Constant.name());
                        jsonNode.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
                        break;
                    }
                    case "optional": {
                        jsonNode.put("inputHandling_73b1056e", EndpointDefinition.InputDatumHandling.Single.name());
                        jsonNode.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.NotRequired.name());
                        break;
                    }
                }
                jsonNode.remove("usage");
            }
        }
    }

    public static PersistentComponentDescription addStaticInput(PersistentComponentDescription description, String inputName) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode staticInputs = (ArrayNode)node.get("staticInputs");
        if (staticInputs == null) {
            staticInputs = JsonNodeFactory.instance.arrayNode();
            ((ObjectNode)node).set("staticInputs", (JsonNode)staticInputs);
        }
        ObjectNode staticCPACSIn = JsonNodeFactory.instance.objectNode();
        ObjectNode metaDataNode = JsonNodeFactory.instance.objectNode();
        metaDataNode.set("usage", (JsonNode)TextNode.valueOf((String)"initial"));
        staticCPACSIn.set("name", (JsonNode)TextNode.valueOf((String)inputName));
        staticCPACSIn.set("datatype", (JsonNode)TextNode.valueOf((String)"FileReference"));
        staticCPACSIn.set("metadata", (JsonNode)metaDataNode);
        staticCPACSIn.set("identifier", (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
        staticInputs.add((JsonNode)staticCPACSIn);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription addStaticOutput(PersistentComponentDescription description, String outputName, String dataType) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode staticOutputs = (ArrayNode)node.get("staticOutputs");
        if (staticOutputs == null) {
            staticOutputs = JsonNodeFactory.instance.arrayNode();
            ((ObjectNode)node).set("staticOutputs", (JsonNode)staticOutputs);
        }
        ObjectNode newOutput = JsonNodeFactory.instance.objectNode();
        newOutput.set("name", (JsonNode)TextNode.valueOf((String)outputName));
        newOutput.set("datatype", (JsonNode)TextNode.valueOf((String)dataType));
        newOutput.set("metadata", (JsonNode)JsonNodeFactory.instance.objectNode());
        newOutput.set("identifier", (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
        staticOutputs.add((JsonNode)newOutput);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription addStaticOutput(PersistentComponentDescription description, String outputName) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode staticOutputs = (ArrayNode)node.get("staticOutputs");
        if (staticOutputs == null) {
            staticOutputs = JsonNodeFactory.instance.arrayNode();
            ((ObjectNode)node).set("staticOutputs", (JsonNode)staticOutputs);
        }
        ObjectNode staticCPACSOut = JsonNodeFactory.instance.objectNode();
        staticCPACSOut.set("name", (JsonNode)TextNode.valueOf((String)outputName));
        staticCPACSOut.set("datatype", (JsonNode)TextNode.valueOf((String)"FileReference"));
        staticCPACSOut.set("metadata", (JsonNode)JsonNodeFactory.instance.objectNode());
        staticCPACSOut.set("identifier", (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
        staticOutputs.add((JsonNode)staticCPACSOut);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription addDynamicInput(PersistentComponentDescription description, String inputName, String dataType, ObjectNode metaData, JsonNode identifier, String epIdentifier) throws IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode dynamicInputs = (ArrayNode)node.get("dynamicInputs");
        if (dynamicInputs == null) {
            dynamicInputs = JsonNodeFactory.instance.arrayNode();
            ((ObjectNode)node).set("dynamicInputs", (JsonNode)dynamicInputs);
        }
        ObjectNode newInput = JsonNodeFactory.instance.objectNode();
        newInput.set("name", (JsonNode)TextNode.valueOf((String)inputName));
        newInput.set("datatype", (JsonNode)TextNode.valueOf((String)dataType));
        newInput.set("metadata", (JsonNode)metaData);
        newInput.set("identifier", identifier);
        newInput.set("epIdentifier", (JsonNode)TextNode.valueOf((String)epIdentifier));
        dynamicInputs.add((JsonNode)newInput);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription addDynamicOutput(PersistentComponentDescription description, String outputName, String dataType, ObjectNode metaData, JsonNode identifier, String epIdentifier) throws IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode dynamicOutputs = (ArrayNode)node.get("dynamicOutputs");
        if (dynamicOutputs == null) {
            dynamicOutputs = JsonNodeFactory.instance.arrayNode();
            ((ObjectNode)node).set("dynamicOutputs", (JsonNode)dynamicOutputs);
        }
        ObjectNode newOutput = JsonNodeFactory.instance.objectNode();
        newOutput.set("name", (JsonNode)TextNode.valueOf((String)outputName));
        newOutput.set("datatype", (JsonNode)TextNode.valueOf((String)dataType));
        newOutput.set("metadata", (JsonNode)metaData);
        newOutput.set("identifier", identifier);
        newOutput.set("epIdentifier", (JsonNode)TextNode.valueOf((String)epIdentifier));
        dynamicOutputs.add((JsonNode)newOutput);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateConsumeCPACSFlag(PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode staticInputs = (ArrayNode)node.get("staticInputs");
        ObjectNode configuration = (ObjectNode)node.get("configuration");
        if (configuration.get("consumeCPACS") != null && Boolean.valueOf(configuration.get("consumeCPACS").textValue()).booleanValue()) {
            for (JsonNode staticInput : staticInputs) {
                if (staticInput.get("name").textValue().equals("Directory")) continue;
                ObjectNode metadata = (ObjectNode)staticInput.get("metadata");
                metadata.set("usage", (JsonNode)TextNode.valueOf((String)"required"));
            }
        }
        configuration.remove("consumeCPACS");
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateDynamicInputsOptional(PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode dynamicInputs = (ArrayNode)node.get("dynamicInputs");
        if (dynamicInputs != null) {
            for (JsonNode dynamicInput : dynamicInputs) {
                if (dynamicInput.get("name").textValue().equals("Directory")) continue;
                ((ObjectNode)dynamicInput.get("metadata")).set("usage", (JsonNode)TextNode.valueOf((String)"optional"));
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateConsumeDirectoryFlag(PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode dynamicInputs = (ArrayNode)node.get("dynamicInputs");
        ObjectNode configuration = (ObjectNode)node.get("configuration");
        if (configuration.get("consumeDirectory") != null && Boolean.valueOf(configuration.get("consumeDirectory").textValue()).booleanValue()) {
            for (JsonNode dynamicInput : dynamicInputs) {
                if (!dynamicInput.get("name").textValue().equals("Directory")) continue;
                ObjectNode metadata = (ObjectNode)dynamicInput.get("metadata");
                metadata.set("usage", (JsonNode)TextNode.valueOf((String)"required"));
            }
        } else if (configuration.get("consumeDirectory") != null && !configuration.get("consumeDirectory").booleanValue()) {
            for (JsonNode dynamicInput : dynamicInputs) {
                if (!dynamicInput.get("name").textValue().equals("Directory")) continue;
                ObjectNode metadata = (ObjectNode)dynamicInput.get("metadata");
                metadata.set("usage", (JsonNode)TextNode.valueOf((String)"initial"));
            }
        }
        configuration.remove("consumeDirectory");
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateDirectoryEndpointId(String direction, PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode dynEndpoints = node.get(direction);
        if (dynEndpoints != null) {
            for (JsonNode endpoint : dynEndpoints) {
                if (!endpoint.get("name").textValue().equals("Directory")) continue;
                ((ObjectNode)endpoint).remove("epIdentifier");
                ((ObjectNode)endpoint).set("epIdentifier", (JsonNode)TextNode.valueOf((String)"directory"));
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }
}

