/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.hostbased;

import java.net.InetAddress;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import org.apache.sshd.client.auth.hostbased.HostKeyIdentityProvider;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class UserAuthHostBased
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "hostbased";
    protected Iterator<? extends Map.Entry<KeyPair, ? extends Collection<X509Certificate>>> keys;
    protected Map.Entry<KeyPair, ? extends Collection<X509Certificate>> keyInfo;
    protected final HostKeyIdentityProvider clientHostKeys;
    private List<NamedFactory<Signature>> factories;
    private String clientUsername;
    private String clientHostname;

    public UserAuthHostBased(HostKeyIdentityProvider clientHostKeys) {
        super(NAME);
        this.clientHostKeys = clientHostKeys;
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.keys = HostKeyIdentityProvider.iteratorOf((SessionContext)session, (HostKeyIdentityProvider)this.clientHostKeys);
    }

    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    public String getClientUsername() {
        return this.clientUsername;
    }

    public void setClientUsername(String clientUsername) {
        this.clientUsername = clientUsername;
    }

    public String getClientHostname() {
        return this.clientHostname;
    }

    public void setClientHostname(String clientHostname) {
        this.clientHostname = clientHostname;
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        String name = this.getName();
        boolean debugEnabled = this.log.isDebugEnabled();
        String clientUsername = this.resolveClientUsername(session);
        String clientHostname = this.resolveClientHostname(session);
        HostBasedAuthenticationReporter reporter = session.getHostBasedAuthenticationReporter();
        Map.Entry<KeyPair, ? extends Collection<X509Certificate>> entry = this.keyInfo = this.keys != null && this.keys.hasNext() ? this.keys.next() : null;
        if (this.keyInfo == null) {
            if (debugEnabled) {
                this.log.debug("sendAuthDataRequest({})[{}][{}] no more keys to send", new Object[]{session, service, name});
            }
            if (reporter != null) {
                reporter.signalAuthenticationExhausted(session, service, clientUsername, clientHostname);
            }
            return false;
        }
        KeyPair kp = this.keyInfo.getKey();
        PublicKey pub = kp.getPublic();
        String keyType = KeyUtils.getKeyType((Key)pub);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendAuthDataRequest({})[{}][{}] current key details: type={}, fingerprint={}", new Object[]{session, service, name, keyType, KeyUtils.getFingerPrint((PublicKey)pub)});
        }
        Collection factories = ValidateUtils.checkNotNullAndNotEmpty((Collection)SignatureFactoriesManager.resolveSignatureFactories((SignatureFactoriesManager)this, (SignatureFactoriesManager)session), (String)"No signature factories for session=%s", (Object[])new Object[]{session});
        Signature verifier = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create((Collection)factories, (String)keyType)), (String)"No signer could be located for key type=%s", (Object)keyType);
        byte[] id = session.getSessionId();
        String username = session.getUsername();
        if (debugEnabled) {
            this.log.debug("sendAuthDataRequest({})[{}][{}] client={}@{}", new Object[]{session, service, name, clientUsername, clientHostname});
        }
        Buffer buffer = session.createBuffer((byte)50, id.length + username.length() + service.length() + clientUsername.length() + clientHostname.length() + keyType.length() + 256 + 64);
        buffer.clear();
        buffer.putRawPublicKey(pub);
        Collection<X509Certificate> certs = this.keyInfo.getValue();
        if (GenericUtils.size(certs) > 0) {
            for (X509Certificate c : certs) {
                buffer.putRawBytes(c.getEncoded());
            }
        }
        verifier.initSigner((SessionContext)session, kp.getPrivate());
        byte[] keyBytes = buffer.getCompactData();
        buffer = session.prepareBuffer((byte)50, BufferUtils.clear((Buffer)buffer));
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putString(keyType);
        buffer.putBytes(keyBytes);
        buffer.putString(clientHostname);
        buffer.putString(clientUsername);
        byte[] signature = this.appendSignature(session, service, keyType, pub, keyBytes, clientHostname, clientUsername, verifier, buffer);
        if (reporter != null) {
            reporter.signalAuthenticationAttempt(session, service, kp, clientHostname, clientUsername, signature);
        }
        session.writePacket(buffer);
        return true;
    }

    protected byte[] appendSignature(ClientSession session, String service, String keyType, PublicKey key, byte[] keyBytes, String clientHostname, String clientUsername, Signature verifier, Buffer buffer) throws Exception {
        byte[] id = session.getSessionId();
        String username = session.getUsername();
        String name = this.getName();
        ByteArrayBuffer bs = new ByteArrayBuffer(id.length + username.length() + service.length() + name.length() + keyType.length() + keyBytes.length + clientHostname.length() + clientUsername.length() + 256 + 64, false);
        bs.putBytes(id);
        bs.putByte((byte)50);
        bs.putString(username);
        bs.putString(service);
        bs.putString(name);
        bs.putString(keyType);
        bs.putBytes(keyBytes);
        bs.putString(clientHostname);
        bs.putString(clientUsername);
        verifier.update((SessionContext)session, bs.array(), bs.rpos(), bs.available());
        byte[] signature = verifier.sign((SessionContext)session);
        if (this.log.isTraceEnabled()) {
            this.log.trace("appendSignature({})[{}][{}] type={}, fingerprint={}, client={}@{}: signature={}", new Object[]{session, service, name, keyType, KeyUtils.getFingerPrint((PublicKey)key), clientUsername, clientHostname, BufferUtils.toHex((byte[])signature)});
        }
        bs.clear();
        bs.putString(keyType);
        bs.putBytes(signature);
        buffer.putBytes(bs.array(), bs.rpos(), bs.available());
        return signature;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName((int)cmd));
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession session, String service, Buffer buffer) throws Exception {
        HostBasedAuthenticationReporter reporter = session.getHostBasedAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationSuccess(session, service, this.keyInfo == null ? null : this.keyInfo.getKey(), this.resolveClientHostname(session), this.resolveClientUsername(session));
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession session, String service, boolean partial, List<String> serverMethods, Buffer buffer) throws Exception {
        HostBasedAuthenticationReporter reporter = session.getHostBasedAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationFailure(session, service, this.keyInfo == null ? null : this.keyInfo.getKey(), this.resolveClientHostname(session), this.resolveClientUsername(session), partial, serverMethods);
        }
    }

    protected String resolveClientUsername(ClientSession session) {
        String value = this.getClientUsername();
        return GenericUtils.isEmpty((CharSequence)value) ? OsUtils.getCurrentUser() : value;
    }

    protected String resolveClientHostname(ClientSession session) {
        String value = this.getClientHostname();
        if (GenericUtils.isEmpty((CharSequence)value)) {
            value = SshdSocketAddress.toAddressString((InetAddress)SshdSocketAddress.getFirstExternalNetwork4Address());
        }
        return GenericUtils.isEmpty((CharSequence)value) ? "127.0.0.1" : value;
    }
}

