/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.impl;

import de.rcenvironment.core.communication.uplink.client.session.api.UplinkConnection;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSession;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSessionService;
import de.rcenvironment.core.utils.common.testutils.ThroughputLimiter;
import de.rcenvironment.core.utils.common.testutils.ThroughputLimitingInputStream;
import de.rcenvironment.core.utils.common.testutils.ThroughputLimitingOutputStream;
import de.rcenvironment.core.utils.testing.LocalTCPTestConnection;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.logging.LogFactory;

public class LocalServiceUplinkConnectionImpl
implements UplinkConnection {
    private final AsyncTaskService asyncTaskService;
    private final ServerSideUplinkSessionService sessionService;
    private LocalTCPTestConnection localTestConnection;
    private InputStream clientSideInputStream;
    private OutputStream serverSideOutputStream;
    private InputStream serverSideInputStream;
    private OutputStream clientSideOutputStream;
    private final AtomicInteger simulatedConnectionCounter = new AtomicInteger();
    private ThroughputLimiter outgoingThroughputLimiter;
    private ThroughputLimiter incomingThroughputLimiter;

    public LocalServiceUplinkConnectionImpl(AsyncTaskService asyncTaskService, ServerSideUplinkSessionService sessionService, ThroughputLimiter outgoingThroughputLimiter, ThroughputLimiter incomingThroughputLimiter) {
        this.asyncTaskService = asyncTaskService;
        this.sessionService = sessionService;
        this.outgoingThroughputLimiter = outgoingThroughputLimiter;
        this.incomingThroughputLimiter = incomingThroughputLimiter;
    }

    @Override
    public void open(Consumer<String> errorConsumer) throws IOException {
        this.localTestConnection = new LocalTCPTestConnection();
        this.clientSideInputStream = this.localTestConnection.getClientSideInputStream();
        this.clientSideOutputStream = this.localTestConnection.getClientSideOutputStream();
        this.serverSideOutputStream = this.localTestConnection.getServerSideOutputStream();
        this.serverSideInputStream = this.localTestConnection.getServerSideInputStream();
        if (this.outgoingThroughputLimiter != null) {
            this.clientSideOutputStream = new ThroughputLimitingOutputStream(this.clientSideOutputStream, this.outgoingThroughputLimiter);
        }
        if (this.incomingThroughputLimiter != null) {
            this.clientSideInputStream = new ThroughputLimitingInputStream(this.clientSideInputStream, this.incomingThroughputLimiter);
        }
        String testConnectionId = Integer.toString(this.simulatedConnectionCounter.incrementAndGet());
        String loginAccountName = "test";
        String sessionContextInfoString = "local test connection #" + testConnectionId;
        ServerSideUplinkSession serverSideSession = this.sessionService.createServerSideSession(this.localTestConnection.getServerSideEndpoint(), loginAccountName, sessionContextInfoString);
        this.asyncTaskService.execute("Local service uplink connection: Running the server-side session", serverSideSession::runSession);
    }

    public InputStream getInputStream() {
        return this.clientSideInputStream;
    }

    public OutputStream getOutputStream() {
        return this.clientSideOutputStream;
    }

    public void close() {
        this.localTestConnection.getClientSideEndpoint().close();
    }

    public void simulateClientSideEOF() {
        try {
            this.clientSideInputStream.close();
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).debug((Object)("Caught an exception while closing the C->R stream to simulate EOF: " + e.toString()));
        }
    }
}

