/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.handlers;

import de.rcenvironment.core.gui.integration.workflowintegration.editor.WorkflowFileEditorInput;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class WorkflowFileIntegrationEditorHandler
extends AbstractHandler {
    private static final Log LOG = LogFactory.getLog(WorkflowFileIntegrationEditorHandler.class);

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        StructuredSelection selection = (StructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection.getFirstElement() instanceof IFile) {
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("de.rcenvironment.rce.gui.workflowintegration.Editor");
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IFile workflowFile = (IFile)selection.getFirstElement();
            File tempFile = null;
            try {
                try {
                    tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("workflow_to_integrate_*.wf");
                    Files.copy(workflowFile.getLocation().toFile().toPath(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    WorkflowFileEditorInput editorInput = new WorkflowFileEditorInput(workflowFile);
                    Optional<String> validationMessage = editorInput.validate();
                    if (validationMessage.isPresent()) {
                        LOG.warn((Object)StringUtils.format((String)"Error opening the workflow integration editor.\n%s", (Object[])new Object[]{validationMessage.get()}));
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error opening the integration editor", (String)("Could not open the workflow integration editor.\n" + validationMessage.get()));
                    } else {
                        activePage.openEditor((IEditorInput)editorInput, desc.getId());
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Error during creation of a temporary workflow file.", (Throwable)e);
                    try {
                        if (tempFile != null) {
                            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(tempFile);
                        }
                    }
                    catch (IOException e2) {
                        LOG.error((Object)e2.getStackTrace());
                    }
                }
                catch (PartInitException e) {
                    LOG.error((Object)"Error opening the workflow integration editor.", (Throwable)e);
                    try {
                        if (tempFile != null) {
                            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(tempFile);
                        }
                    }
                    catch (IOException e3) {
                        LOG.error((Object)e3.getStackTrace());
                    }
                }
            }
            finally {
                try {
                    if (tempFile != null) {
                        TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(tempFile);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e.getStackTrace());
                }
            }
        }
        return null;
    }
}

