import os
import json

def get_algorithm():
    return config.get("algorithm")

def get_base_values():
    return config.get("baseValues")

def get_constraint_names():
    return config.get("constraints")

def get_design_variable_count():
    return config.get("designVariableCount")

def get_design_variable_names():
    return config.get("designVariables")

def get_design_variable_max_values():
    return config.get("maxValuesVariables")

def get_design_variable_min_values():
    return config.get("minValuesVariables")

def get_constraint_max_values():
    return config.get("maxValuesConstraints")

def get_constraint_min_values():
    return config.get("minValuesConstraints")

def get_design_variable_max_value(variable_name):
    if (not config.get("maxValuesVariables").get(variable_name) is None):
        return config.get("maxValuesVariables").get(variable_name)
    return None

def get_design_variable_min_value(variable_name):
    if (not config.get("minValuesVariables").get(variable_name) is None):
        return config.get("minValuesVariables").get(variable_name)
    return None

def get_constraint_max_value(constraint_name):
    if (not config.get("maxValuesConstraints").get(constraint_name) is None):
        return config.get("maxValuesConstraints").get(constraint_name)
    return None

def get_constraint_min_value(constraint_name):
    if (not config.get("minValuesConstraints").get(constraint_name) is None):
        return config.get("minValuesConstraints").get(constraint_name)
    return None

def get_objective_names():
    return config.get("objectives")

def get_objective_weights():
    return config.get("objectivesWeights")

def get_optimization_targets():
    return config.get("optimizationTargets")

def get_optimization_target(objective_name):
    if (not config.get("optimizationTargets").get(objective_name) is None):
        return config.get("optimizationTargets").get(objective_name)
    return None

def get_property(property_name):
    if (not config.get("algorithmSettings").get(property_name) is None):
        return config.get("algorithmSettings").get(property_name).get("value")
    return None

def get_property_keys():
    return config.get("algorithmSettings").keys()

def get_properties():
    return config.get("algorithmSettings")

def get_start_value(variable_name):
    return config.get("initValues").get(variable_name)

def get_start_values():
    return config.get("initValues")

def get_step_values():
    return config.get("stepValues")

def is_discrete_variable(variable_name):
    return config.get("discreteValues").get(variable_name)

def ___read_configuration():
    homeDir=os.getcwd()
    global config
    config = {}
    try:
        with open(os.path.join(homeDir, "source/configuration.json")) as data_file:
            config = json.load(data_file)
    except IOError as e: 
        print("Could not read result file" + str(e))
    return config
        
___read_configuration()