/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function.internal;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInstallationBuilder;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentInterfaceBuilder;
import de.rcenvironment.core.component.model.api.ComponentRevisionBuilder;
import de.rcenvironment.core.component.model.configuration.api.ComponentConfigurationModelFactory;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.endpoint.api.ComponentEndpointModelFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.workflow.execution.function.InputAdapterComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

class InputAdapterNodeBuilder {
    private LogicalNodeId hostId;
    private String inputDirectoryAbsolutePath;
    private Map<String, DataType> externalInputs = new HashMap<String, DataType>();

    InputAdapterNodeBuilder() {
    }

    public InputAdapterNodeBuilder setHostId(LogicalNodeId hostIdParam) {
        this.hostId = hostIdParam;
        return this;
    }

    public InputAdapterNodeBuilder setInputDirectory(String inputDirectoryAbsolutePathParam) {
        this.inputDirectoryAbsolutePath = inputDirectoryAbsolutePathParam;
        return this;
    }

    public InputAdapterNodeBuilder addExternalInputName(String externalInputName, DataType externalInputType) {
        this.externalInputs.put(externalInputName, externalInputType);
        return this;
    }

    public WorkflowNode build() {
        Objects.requireNonNull(this.hostId);
        Objects.requireNonNull(this.inputDirectoryAbsolutePath);
        HashMap<String, String> readOnlyConfiguration = new HashMap<String, String>();
        readOnlyConfiguration.put("toolName", "inputAdapter");
        readOnlyConfiguration.put("version", "1.0");
        readOnlyConfiguration.put("hostId", this.hostId.toString());
        readOnlyConfiguration.put("hostName", "awesomeHostName");
        readOnlyConfiguration.put("isWorkflow", Boolean.TRUE.toString());
        readOnlyConfiguration.put("inputFolder", this.inputDirectoryAbsolutePath);
        ConfigurationDefinition configuration = ComponentConfigurationModelFactory.createConfigurationDefinition(new LinkedList(), new LinkedList(), new LinkedList(), readOnlyConfiguration);
        HashSet inputAdapterInputs = new HashSet();
        EndpointDefinitionsProvider inputAdapterProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(inputAdapterInputs);
        HashSet<EndpointDefinition> inputAdapterOutputs = new HashSet<EndpointDefinition>();
        for (Map.Entry<String, DataType> externalInput : this.externalInputs.entrySet()) {
            EndpointDefinition singleEndpointDefinition = EndpointDefinition.outputBuilder().name(externalInput.getKey()).allowedDatatype(externalInput.getValue()).defaultDatatype(externalInput.getValue()).build();
            inputAdapterOutputs.add(singleEndpointDefinition);
        }
        EndpointDefinitionsProvider outputAdapterProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(inputAdapterOutputs);
        ComponentInterface componentInterface = new ComponentInterfaceBuilder().setIdentifier("InputAdapter").setIcon16(new byte[0]).setIcon32(new byte[0]).setGroupName("Dummy Tools").setVersion("0.0").setInputDefinitionsProvider(inputAdapterProvider).setOutputDefinitionsProvider(outputAdapterProvider).setConfigurationDefinition(configuration).setConfigurationExtensionDefinitions(new HashSet()).setColor(ComponentConstants.COMPONENT_COLOR_STANDARD).setShape(ComponentConstants.COMPONENT_SHAPE_STANDARD).setSize(ComponentConstants.COMPONENT_SIZE_STANDARD).setDisplayName("Input Adapter").build();
        ComponentInstallation ci = new ComponentInstallationBuilder().setComponentRevision(new ComponentRevisionBuilder().setComponentInterface(componentInterface).setClassName(InputAdapterComponent.class.getCanonicalName()).build()).setNodeId(this.hostId).setInstallationId(componentInterface.getIdentifierAndVersion()).build();
        ComponentDescription componentDescription = new ComponentDescription(ci);
        WorkflowNode nodeToAdd = new WorkflowNode(componentDescription);
        nodeToAdd.setEnabled(true);
        nodeToAdd.setChecked(false);
        nodeToAdd.setImitiationModeActive(false);
        nodeToAdd.setInit(true);
        nodeToAdd.setName("Input Adapter");
        return nodeToAdd;
    }
}

