/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow.internal;

import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class EndpointAdapterToJsonConverter {
    private static final String ENDPOINT_DATA_TYPE_KEY = "endpointDataType";
    private static final String REQUIRED = "Required";
    private final EndpointAdapters endpointAdapterDefinitions;

    EndpointAdapterToJsonConverter(EndpointAdapters endpointAdapterDefinitions) {
        this.endpointAdapterDefinitions = endpointAdapterDefinitions;
    }

    public List<Map<String, Object>> toInputDefinitions() {
        return this.endpointAdapterDefinitions.stream().filter(EndpointAdapter::isInputAdapter).map(this::toInputDefinition).collect(Collectors.toList());
    }

    private Map<String, Object> toInputDefinition(EndpointAdapter definition) {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("endpointFileName", "");
        inputMap.put(ENDPOINT_DATA_TYPE_KEY, definition.getDataType().name());
        inputMap.put("inputExecutionConstraint", String.valueOf(definition.getInputExecutionConstraint()));
        inputMap.put("defaultInputExecutionConstraint", String.valueOf(definition.getInputExecutionConstraint()));
        inputMap.put("defaultInputHandling", String.valueOf(definition.getInputDatumHandling()));
        inputMap.put("inputHandling", String.valueOf(definition.getInputDatumHandling()));
        inputMap.put("endpointName", definition.getExternalName());
        inputMap.put("endpointFolder", "");
        return inputMap;
    }

    public List<Map<String, Object>> toOutputDefinitions() {
        return this.endpointAdapterDefinitions.stream().filter(EndpointAdapter::isOutputAdapter).map(this::toOutputDefinition).collect(Collectors.toList());
    }

    private Map<String, Object> toOutputDefinition(EndpointAdapter definition) {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        outputMap.put("inputHandling", "-");
        outputMap.put("endpointFileName", "");
        outputMap.put(ENDPOINT_DATA_TYPE_KEY, definition.getDataType().name());
        outputMap.put("endpointName", definition.getExternalName());
        outputMap.put("inputExecutionConstraint", REQUIRED);
        outputMap.put("endpointFolder", "");
        return outputMap;
    }

    public List<Map<String, Object>> toEndpointAdapterDefinitions() {
        return this.endpointAdapterDefinitions.stream().map(this::toEndpointAdapterConfiguration).collect(Collectors.toList());
    }

    private Map<String, Object> toEndpointAdapterConfiguration(EndpointAdapter definition) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        if (definition.isInputAdapter()) {
            returnValue.put("type", "INPUT");
            returnValue.put("inputHandling", definition.getInputDatumHandling());
            returnValue.put("inputExecutionConstraint", definition.getInputExecutionConstraint());
        } else {
            returnValue.put("type", "OUTPUT");
        }
        returnValue.put("internalName", definition.getInternalName());
        returnValue.put("externalName", definition.getExternalName());
        returnValue.put("identifier", definition.getWorkflowNodeIdentifier());
        return returnValue;
    }
}

