/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.screen;

import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalPosition;

public class ScreenWriter {
    private final Screen targetScreen;
    private final TerminalPosition currentPosition;
    private Terminal.Color foregroundColor = Terminal.Color.DEFAULT;
    private Terminal.Color backgroundColor = Terminal.Color.DEFAULT;

    public ScreenWriter(Screen targetScreen) {
        this.targetScreen = targetScreen;
        this.currentPosition = new TerminalPosition(0, 0);
    }

    public Terminal.Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Terminal.Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Terminal.Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Terminal.Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void fillScreen(char c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.targetScreen.getTerminalSize().getColumns(); ++i) {
            sb.append(c);
        }
        String line = sb.toString();
        for (int i = 0; i < this.targetScreen.getTerminalSize().getRows(); ++i) {
            this.drawString(0, i, line, new ScreenCharacterStyle[0]);
        }
    }

    public void drawString(int x, int y, String string, ScreenCharacterStyle ... styles) {
        this.currentPosition.setColumn(x);
        this.currentPosition.setRow(y);
        this.targetScreen.putString(x, y, string, this.foregroundColor, this.backgroundColor, styles);
        this.currentPosition.setColumn(this.currentPosition.getColumn() + string.length());
    }

    public int hashCode() {
        return this.targetScreen.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ScreenWriter)) {
            return false;
        }
        return this.targetScreen.equals(((ScreenWriter)obj).targetScreen);
    }
}

