/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractInteractableComponent;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;

public abstract class CommonCheckBox
extends AbstractInteractableComponent {
    private final Label label;

    public CommonCheckBox(String label) {
        this.label = new Label(label);
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        TerminalSize labelSize = this.label.getPreferredSize();
        labelSize.setColumns(labelSize.getColumns() + 4);
        return labelSize;
    }

    @Override
    public void repaint(TextGraphics graphics) {
        graphics.applyTheme(Theme.Category.CHECKBOX);
        if (this.hasFocus()) {
            graphics.applyTheme(Theme.Category.CHECKBOX_SELECTED);
        } else {
            graphics.applyTheme(Theme.Category.CHECKBOX);
        }
        char check = ' ';
        if (this.isSelected()) {
            check = this.getSelectionCharacter();
        }
        graphics.drawString(0, 0, this.surroundCharacter(check), new ScreenCharacterStyle[0]);
        graphics.applyTheme(Theme.Category.CHECKBOX);
        graphics.drawString(3, 0, " ", new ScreenCharacterStyle[0]);
        TextGraphics subArea = graphics.subAreaGraphics(new TerminalPosition(4, 0));
        this.label.repaint(subArea);
        this.setHotspot(graphics.translateToGlobalCoordinates(new TerminalPosition(1, 0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactable.Result keyboardInteraction(Key key) {
        try {
            switch (key.getKind()) {
                case ArrowDown: {
                    Interactable.Result result = Interactable.Result.NEXT_INTERACTABLE_DOWN;
                    return result;
                }
                case Tab: 
                case ArrowRight: {
                    Interactable.Result result = Interactable.Result.NEXT_INTERACTABLE_RIGHT;
                    return result;
                }
                case ArrowUp: {
                    Interactable.Result result = Interactable.Result.PREVIOUS_INTERACTABLE_UP;
                    return result;
                }
                case ReverseTab: 
                case ArrowLeft: {
                    Interactable.Result result = Interactable.Result.PREVIOUS_INTERACTABLE_LEFT;
                    return result;
                }
                case Enter: {
                    this.onActivated();
                    Interactable.Result result = Interactable.Result.EVENT_HANDLED;
                    return result;
                }
            }
            if (key.getCharacter() == ' ' || key.getCharacter() == 'x') {
                this.onActivated();
                Interactable.Result result = Interactable.Result.EVENT_HANDLED;
                return result;
            }
            Interactable.Result result = Interactable.Result.EVENT_NOT_HANDLED;
            return result;
        }
        finally {
            this.invalidate();
        }
    }

    public abstract boolean isSelected();

    protected abstract char getSelectionCharacter();

    protected abstract String surroundCharacter(char var1);

    protected abstract void onActivated();

    public void select() {
        this.onActivated();
    }
}

