/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.execute.AbstractUpdateBehavior;
import de.rcenvironment.core.gui.workflow.execute.CheckboxLabelProvider;
import de.rcenvironment.core.gui.workflow.execute.ColorPalette;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.TableBehaviour;
import de.rcenvironment.core.gui.workflow.execute.TreeNode;
import de.rcenvironment.core.gui.workflow.execute.WorkflowNodeTargetPlatformLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class TreeBehaviour
extends AbstractUpdateBehavior {
    private TreeViewer treeViewer;
    private List<InstanceNodeSessionId> missingTargetInstancesList;

    public TreeBehaviour(TreeViewer tree, WorkflowNodeTargetPlatformLabelProvider instanceProvider, CheckboxLabelProvider checkboxProvider) {
        super(instanceProvider, checkboxProvider);
        this.treeViewer = tree;
    }

    @Override
    public void updateInstanceColumn(ViewerCell cell) {
        TreeNode treeNodeCell = (TreeNode)cell.getElement();
        if (treeNodeCell.isChildElement()) {
            this.updateChild(cell);
        } else {
            this.updateFather(cell);
        }
        this.checkIfDisableMasterBtn();
        this.prepareValuesForMasterCombo();
    }

    @Override
    public void updateCheckBoxColumn(ViewerCell cell) {
        TreeNode node = (TreeNode)cell.getElement();
        TreeEditor editor = new TreeEditor(this.treeViewer.getTree());
        TreeItem item = (TreeItem)cell.getItem();
        Button btn = new Button((Composite)this.treeViewer.getTree(), 32);
        this.synchronizeButtons();
        if (node.isChildElement()) {
            btn.setBackground(ColorPalette.getInstance().getFirstRowColor());
            if (node.getWorkflowNode().isChecked()) {
                btn.setSelection(true);
            } else {
                btn.setSelection(false);
            }
            if (this.editingSupport.getValues(node.getWorkflowNode()).size() <= 1) {
                btn.setEnabled(false);
            } else {
                btn.setEnabled(true);
            }
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeBehaviour.this.saveIndexOfComboBeforeRefresh();
                    Button sourceButton = (Button)e.getSource();
                    TreeNode sourceNode = (TreeNode)sourceButton.getData("CHECK_BOX");
                    sourceNode.getWorkflowNode().setChecked(sourceButton.getSelection());
                    boolean selected = TreeBehaviour.this.checkifSameNodeChildrenSelected(sourceNode);
                    TreeNode treeNodeFather = sourceNode.getFatherNode();
                    Button btnFather = TreeBehaviour.this.findExactButtonForTreeNode(treeNodeFather);
                    if (selected) {
                        if (!btnFather.getSelection()) {
                            btnFather.setSelection(true);
                        }
                    } else if (btnFather.getSelection()) {
                        btnFather.setSelection(false);
                    }
                    if (!TreeBehaviour.this.checkifAllChildrenSelected()) {
                        TreeBehaviour.this.treeViewer.getTree().getColumn(0).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_UNCHECKED));
                        TableBehaviour.allCheckboxesClicked = false;
                    }
                    TreeBehaviour.this.synchronizeButtons();
                    TreeBehaviour.this.prepareValuesForMasterCombo();
                    TreeBehaviour.this.checkIfDisableMasterBtn();
                    TreeBehaviour.this.setSavedComboIndex();
                }
            });
        } else {
            btn.setBackground(ColorPalette.getInstance().getSecondRowColor());
            boolean checkedAllChildren = true;
            boolean allChildrenDisabled = true;
            for (TreeNode treeNode : node.getChildrenNodes()) {
                if (!treeNode.getWorkflowNode().isChecked()) {
                    checkedAllChildren = false;
                }
                if (this.editingSupport.getValues(treeNode.getWorkflowNode()).size() <= 1) continue;
                allChildrenDisabled = false;
            }
            if (checkedAllChildren) {
                btn.setSelection(true);
            } else {
                btn.setSelection(false);
            }
            if (allChildrenDisabled) {
                btn.setEnabled(false);
            }
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeBehaviour.this.saveIndexOfComboBeforeRefresh();
                    Button b = (Button)e.getSource();
                    TreeNode treeNode = (TreeNode)b.getData("CHECK_BOX");
                    for (TreeNode node : treeNode.getChildrenNodes()) {
                        node.getWorkflowNode().setChecked(b.getSelection());
                    }
                    for (Button button : TreeBehaviour.this.btnList) {
                        TreeNode treeN = (TreeNode)button.getData("CHECK_BOX");
                        if (!treeN.isChildElement()) continue;
                        button.setSelection(treeN.getWorkflowNode().isChecked());
                    }
                    if (!TreeBehaviour.this.checkifAllChildrenSelected()) {
                        TreeBehaviour.this.treeViewer.getTree().getColumn(0).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_UNCHECKED));
                        TableBehaviour.allCheckboxesClicked = false;
                    }
                    TreeBehaviour.this.prepareValuesForMasterCombo();
                    TreeBehaviour.this.checkIfDisableMasterBtn();
                    TreeBehaviour.this.setSavedComboIndex();
                }
            });
        }
        this.btnList.add(btn);
        btn.setData("CHECK_BOX", (Object)node);
        btn.setData("EDITOR", (Object)editor);
        editor.grabHorizontal = true;
        editor.setEditor((Control)btn, item, 0);
        this.isCheckBoxColumnEnabled();
        if (!this.columnImageActive) {
            this.treeViewer.getTree().getColumn(0).setImage(this.checkDisabled);
        } else {
            this.treeViewer.getTree().getColumn(0).setImage(this.uncheckedImg);
        }
    }

    private void updateChild(ViewerCell cell) {
        final TreeNode treeNodeCell = (TreeNode)cell.getElement();
        final CCombo combo = new CCombo((Composite)this.treeViewer.getTree(), 8);
        TreeItem item = (TreeItem)cell.getItem();
        TreeEditor editor = new TreeEditor(this.treeViewer.getTree());
        editor.grabHorizontal = true;
        editor.horizontalAlignment = 1;
        Color firstRow = ColorPalette.getInstance().getFirstRowColor();
        cell.getViewerRow().setBackground(0, firstRow);
        cell.getViewerRow().setBackground(1, firstRow);
        cell.getViewerRow().setBackground(2, firstRow);
        combo.setData((Object)treeNodeCell);
        combo.setData("EDITOR", (Object)editor);
        combo.setBackground(firstRow);
        combo.addListener(11, new Listener(){

            public void handleEvent(Event argEvent) {
                if (combo != null) {
                    combo.setText(combo.getText());
                }
            }
        });
        if (!this.comboList.contains(combo)) {
            this.comboList.add(combo);
        }
        editor.setEditor((Control)combo, item, 2);
        treeNodeCell.setCombo(combo);
        if (this.editingSupport.getValues(treeNodeCell.getWorkflowNode()).size() > 0) {
            for (String value : this.editingSupport.getValues(treeNodeCell.getWorkflowNode())) {
                combo.add(value);
            }
        } else {
            combo.setEnabled(false);
            combo.setText("No target instance available");
        }
        Integer selectionIndex = (Integer)this.editingSupport.getValue(treeNodeCell.getWorkflowNode());
        if (selectionIndex != null) {
            combo.select(selectionIndex.intValue());
        } else {
            combo.select(0);
        }
        if (this.editingSupport.getHasVersionErrorMap().containsKey(treeNodeCell.getWorkflowNode()) && this.editingSupport.getHasVersionErrorMap().get(treeNodeCell.getWorkflowNode()).booleanValue()) {
            combo.select(0);
        }
        this.instanceProvider.handleSelection(combo, treeNodeCell.getWorkflowNode());
        this.checkForSameSelection(treeNodeCell.getFatherNode());
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeBehaviour.this.instanceProvider.handleSelection(combo, treeNodeCell.getWorkflowNode());
                treeNodeCell.getFatherNode().getCombo().setText(Messages.combomultiple);
                TreeBehaviour.this.instanceProvider.getPage().prepareErrorStatement();
                TreeBehaviour.this.checkForSameSelection(treeNodeCell.getFatherNode());
            }
        });
    }

    private void checkForSameSelection(TreeNode father) {
        List<TreeNode> children = father.getChildrenNodes();
        boolean noChildrenWithDifferentInst = false;
        ArrayList<CCombo> combos = new ArrayList<CCombo>();
        for (TreeNode treeNode : children) {
            if (treeNode.getCombo() == null) continue;
            combos.add(treeNode.getCombo());
        }
        if (combos.size() == 1) {
            noChildrenWithDifferentInst = true;
        } else {
            int i = 0;
            while (i < combos.size() - 1) {
                if (((CCombo)combos.get(i)).getSelectionIndex() != ((CCombo)combos.get(i + 1)).getSelectionIndex()) {
                    noChildrenWithDifferentInst = false;
                    break;
                }
                noChildrenWithDifferentInst = true;
                ++i;
            }
        }
        if (noChildrenWithDifferentInst) {
            LogicalNodeId nodeId = father.getChildrenNodes().get(0).getWorkflowNode().getComponentDescription().getNode();
            father.getCombo().setText(nodeId.getAssociatedDisplayName());
            if (this.missingTargetInstancesList != null) {
                for (InstanceNodeSessionId missingID : this.missingTargetInstancesList) {
                    String temp = missingID.toString();
                    String missing = temp.substring(1, temp.indexOf(Messages.bracket) - 2);
                    if (!father.getCombo().getText().contains(missing)) continue;
                    father.getCombo().setText("Contains missing instance");
                }
            }
        } else {
            father.getCombo().setText(Messages.combomultiple);
        }
    }

    private void updateFather(ViewerCell cell) {
        TreeNode treeNodeCell = (TreeNode)cell.getElement();
        final CCombo combo = new CCombo((Composite)this.treeViewer.getTree(), 4);
        TreeItem item = (TreeItem)cell.getItem();
        TreeEditor editor = new TreeEditor(this.treeViewer.getTree());
        editor.grabHorizontal = true;
        editor.horizontalAlignment = 1;
        Color secondRow = ColorPalette.getInstance().getSecondRowColor();
        cell.getViewerRow().setBackground(0, secondRow);
        cell.getViewerRow().setBackground(1, secondRow);
        cell.getViewerRow().setBackground(2, secondRow);
        combo.setData((Object)treeNodeCell);
        combo.setData("EDITOR", (Object)editor);
        combo.setBackground(secondRow);
        combo.setEditable(false);
        combo.addListener(11, new Listener(){

            public void handleEvent(Event argEvent) {
                if (combo != null) {
                    combo.setText(combo.getText());
                }
            }
        });
        if (!this.comboList.contains(combo)) {
            this.comboList.add(combo);
        }
        editor.setEditor((Control)combo, item, 2);
        treeNodeCell.setCombo(combo);
        for (String value : this.editingSupport.getValues(treeNodeCell.getChildrenNodes().get(0).getWorkflowNode())) {
            combo.add(value);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CCombo comboSource = (CCombo)e.getSource();
                TreeNode cell = (TreeNode)comboSource.getData();
                for (TreeNode treeNode : cell.getChildrenNodes()) {
                    if (treeNode.getCombo() == null) continue;
                    treeNode.getCombo().select(combo.getSelectionIndex());
                    TreeBehaviour.this.instanceProvider.handleSelection(treeNode.getCombo(), treeNode.getWorkflowNode());
                }
            }
        });
        boolean noAvailableChildren = true;
        boolean allChildrenDisabled = true;
        for (TreeNode treeNode : treeNodeCell.getChildrenNodes()) {
            int size = this.editingSupport.getValues(treeNode.getWorkflowNode()).size();
            if (size > 0) {
                noAvailableChildren = false;
            }
            if (size <= 1) continue;
            allChildrenDisabled = false;
        }
        if (noAvailableChildren) {
            combo.setEnabled(false);
            combo.setText("No instances available");
        }
        if (allChildrenDisabled) {
            combo.setEnabled(false);
        }
    }

    @Override
    public void refreshColumns() {
        this.treeViewer.getTree().removeAll();
        this.checkProvider.clearButtonList();
        this.instanceProvider.clearComboList();
        this.treeViewer.getTree().setRedraw(false);
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        if (this.columnImageActive) {
            if (TableBehaviour.allCheckboxesClicked) {
                this.treeViewer.getTree().getColumn(0).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_CHECKED));
            } else {
                this.treeViewer.getTree().getColumn(0).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_UNCHECKED));
            }
        }
        this.treeViewer.getTree().setRedraw(true);
        this.treeViewer.getTree().redraw();
        this.treeViewer.getTree().update();
        this.checkIfDisableMasterBtn();
    }

    @Override
    public boolean useFilter(String filterText, Object element) {
        TreeNode node = (TreeNode)element;
        if (filterText == null) {
            return true;
        }
        if (filterText.equals("")) {
            return true;
        }
        String filterTextSmall = filterText.toLowerCase();
        if (!node.isChildElement()) {
            return this.checkifShowFatherInstance(node, filterTextSmall);
        }
        String componentName = node.getWorkflowNode().getName().toLowerCase();
        String temp = node.getWorkflowNode().getComponentDescription().getNode().toString().toLowerCase();
        String targetInstance = temp.replaceFirst("\"", "");
        return targetInstance.contains(filterTextSmall) || componentName.contains(filterTextSmall);
    }

    private boolean checkifShowFatherInstance(TreeNode node, String filterTextSmall) {
        boolean hasChildinFilter = false;
        for (TreeNode treeNode : node.getChildrenNodes()) {
            String temp = treeNode.getWorkflowNode().getComponentDescription().getNode().toString().toLowerCase();
            String instanceName = temp.replaceFirst("\"", "");
            String componentName = treeNode.getWorkflowNode().getName().toLowerCase();
            if (instanceName.contains(filterTextSmall) || componentName.contains(filterTextSmall)) {
                hasChildinFilter = true;
                break;
            }
            hasChildinFilter = false;
        }
        return hasChildinFilter;
    }

    private Button findExactButtonForTreeNode(TreeNode treeNodeFather) {
        for (Button button : this.btnList) {
            TreeNode node = (TreeNode)button.getData("CHECK_BOX");
            if (node.isChildElement() || !treeNodeFather.getComponentName().equals(node.getComponentName())) continue;
            return button;
        }
        return null;
    }

    private boolean checkifSameNodeChildrenSelected(TreeNode sourceNode) {
        boolean areChildrenSelected = true;
        for (TreeNode otherchildNode : sourceNode.getFatherNode().getChildrenNodes()) {
            if (otherchildNode.getWorkflowNode().isChecked()) continue;
            areChildrenSelected = false;
        }
        return areChildrenSelected;
    }

    private boolean checkifAllChildrenSelected() {
        boolean isAllSelected = true;
        ArrayList<Button> allEnabledBtns = new ArrayList<Button>();
        for (Button b : this.btnList) {
            if (!b.isEnabled()) continue;
            allEnabledBtns.add(b);
        }
        for (Button button : allEnabledBtns) {
            TreeNode temp = (TreeNode)button.getData("CHECK_BOX");
            if (!temp.isChildElement() || temp.getWorkflowNode().isChecked()) continue;
            isAllSelected = false;
        }
        if (this.columnImageActive && isAllSelected && this.btnList.size() > 0) {
            TableBehaviour.allCheckboxesClicked = true;
            this.treeViewer.getTree().getColumn(0).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_CHECKED));
        }
        return isAllSelected;
    }

    private void synchronizeButtons() {
        for (Button b : this.btnList) {
            TreeNode node = (TreeNode)b.getData("CHECK_BOX");
            if (!node.isChildElement()) continue;
            b.setSelection(node.getWorkflowNode().isChecked());
        }
    }

    public void setMissingTargetInstancesList(List<InstanceNodeSessionId> missingTargetInstancesList) {
        this.missingTargetInstancesList = missingTargetInstancesList;
    }
}

