/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.notification;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.utils.common.ComparatorUtils;
import java.io.Serializable;
import java.util.Date;

public class NotificationHeader
implements Comparable<NotificationHeader>,
Serializable {
    private static final long serialVersionUID = -7059564485221275362L;
    private long number;
    private Date timestamp = new Date();
    private String notificationId = null;
    private InstanceNodeSessionId publishPlatform = null;

    public NotificationHeader(String notificationIdentifier, long edition, InstanceNodeSessionId publisherPlatform) {
        this.notificationId = notificationIdentifier;
        this.number = edition;
        this.publishPlatform = publisherPlatform;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getNumber() {
        return this.number;
    }

    public String getNotificationIdentifier() {
        return this.notificationId;
    }

    public InstanceNodeSessionId getPublishPlatform() {
        return this.publishPlatform;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.notificationId);
        builder.append("[");
        builder.append(this.number);
        builder.append("]");
        builder.append("@");
        builder.append(this.publishPlatform);
        builder.append(" - ");
        builder.append(this.timestamp);
        return new String(builder);
    }

    @Override
    public int compareTo(NotificationHeader header) {
        Date otherTimestamp = header.getTimestamp();
        int result = ComparatorUtils.compareLong((long)this.timestamp.getTime(), (long)otherTimestamp.getTime());
        if (result != 0) {
            return result;
        }
        return ComparatorUtils.compareLong((long)this.number, (long)header.getNumber());
    }

    public boolean equals(Object object) {
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

