/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.model.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkGraphNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.Map;

public final class NetworkGraphNodeImpl
implements NetworkGraphNode {
    private final InstanceNodeSessionId nodeId;
    private final Map<String, String> nodeProperties;
    private volatile boolean isLocalNode = false;

    public NetworkGraphNodeImpl(InstanceNodeSessionId nodeId, Map<String, String> nodeProperties) {
        if (nodeId == null) {
            throw new NullPointerException(StringUtils.format((String)"%s / %s", (Object[])new Object[]{nodeId, nodeProperties}));
        }
        this.nodeId = nodeId;
        this.nodeProperties = nodeProperties;
    }

    public NetworkGraphNodeImpl(InstanceNodeSessionId nodeId) {
        this.nodeId = nodeId;
        this.nodeProperties = new HashMap<String, String>();
        this.nodeProperties.put("displayName", "<" + nodeId.getInstanceNodeSessionIdString() + ">");
    }

    @Override
    public InstanceNodeSessionId getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getDisplayName() {
        String result = null;
        if (this.nodeProperties != null) {
            this.nodeProperties.get("displayName");
        }
        if (result == null) {
            result = "<unknown>";
        }
        return result;
    }

    @Override
    public boolean isLocalNode() {
        return this.isLocalNode;
    }

    public void setIsLocalNode(boolean isLocalNode) {
        this.isLocalNode = isLocalNode;
    }

    public String toString() {
        return StringUtils.format((String)"%s ('%s')", (Object[])new Object[]{this.nodeId.getInstanceNodeSessionIdString(), this.getDisplayName()});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetworkGraphNodeImpl)) {
            return false;
        }
        return this.nodeId.equals(((NetworkGraphNodeImpl)obj).nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }
}

