/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.java.en.Given;
import de.rcenvironment.core.instancemanagement.InstanceConfigurationOperationSequence;
import de.rcenvironment.core.instancemanagement.InstanceManagementService;
import de.rcenvironment.core.instancemanagement.internal.DeploymentOperationsImpl;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationException;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.PrefixingTextOutForwarder;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import de.rcenvironment.extras.testscriptrunner.definitions.helper.StepDefinitionConstants;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.TestContext;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.exec.OS;
import org.junit.Assert;

public class InstanceInstantiationStepDefinitions
extends InstanceManagementStepDefinitionBase {
    private final DeploymentOperationsImpl deploymentOperations = new DeploymentOperationsImpl();

    public InstanceInstantiationStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @Given(value="^(?:the )?(same )?(running )?instance[s]? \"([^\"]*)\" using (?:the (default|legacy|base) build|build \"([^\"]*)\")(?: with im master role \"([^\"]*)\")?$")
    public void givenInstancesUsingBuild(String keepProfile, String autoStartPhrase, String instanceList, String buildShort, String buildExplicit, String imMasterRole) throws Exception {
        boolean wipeProfile = keepProfile == null;
        PrefixingTextOutForwarder imOperationOutputReceiver = this.getTextoutReceiverForIMOperations();
        String installationId = this.parseInstallationId(buildShort, buildExplicit, imOperationOutputReceiver);
        TestContext.setTestedInstanceInstallationRoot(installationId);
        List<String> instanceDefinitionParts = this.parseCommaSeparatedList(instanceList);
        ArrayList<String> instanceIds = new ArrayList<String>();
        for (String instanceDefinition : instanceDefinitionParts) {
            Matcher matcher = StepDefinitionConstants.INSTANCE_DEFINITION_PATTERN.matcher(instanceDefinition);
            if (!matcher.matches()) {
                Assert.fail((String)("Invalid instance definition part: " + instanceDefinition));
            }
            String instanceId = matcher.group(1);
            instanceIds.add(instanceId);
            String optionString = matcher.group(2);
            if (optionString == null) {
                optionString = "";
            }
            ManagedInstance instance = new ManagedInstance(instanceId, installationId, INSTANCE_MANAGEMENT_SERVICE);
            this.executionContext.putInstance(instanceId, instance);
            this.executionContext.addInstance(instance);
            this.printToCommandConsole(StringUtils.format((String)"Configuring test instance \"%s\"", (Object[])new Object[]{instanceId}));
            int imSshPortNumber = PORT_NUMBER_GENERATOR.incrementAndGet();
            while (!this.isPortAvailable(imSshPortNumber)) {
                imSshPortNumber = PORT_NUMBER_GENERATOR.incrementAndGet();
            }
            instance.setServerPort("ssh", 0, imSshPortNumber);
            this.configureInstance(imOperationOutputReceiver, instanceId, optionString, imSshPortNumber, wipeProfile, imMasterRole);
        }
        if (autoStartPhrase != null) {
            this.printToCommandConsole(StringUtils.format((String)"Auto-starting instance(s) \"%s\"", (Object[])new Object[]{instanceList}));
            INSTANCE_MANAGEMENT_SERVICE.startInstance(installationId, instanceIds, (TextOutputReceiver)imOperationOutputReceiver, TimeUnit.SECONDS.toMillis(60L), false, "");
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPortAvailable(int imSshPortNumber) {
        ServerSocket socket = null;
        socket = new ServerSocket(imSshPortNumber);
        socket.setReuseAddress(true);
        if (socket == null) return true;
        try {
            socket.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {
                if (socket == null) return false;
            }
            catch (Throwable throwable) {
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                socket.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    private void configureInstance(PrefixingTextOutForwarder imOperationOutputReceiver, String instanceId, String optionString, int imSshPortNumber, boolean wipe, String imMasterRole) throws InstanceConfigurationException, IOException {
        InstanceConfigurationOperationSequence setupSequence = INSTANCE_MANAGEMENT_SERVICE.newConfigurationOperationSequence();
        setupSequence = wipe ? setupSequence.wipeConfiguration() : setupSequence.resetConfiguration();
        if (optionString.contains("Relay")) {
            setupSequence = setupSequence.setRelayFlag(true);
        }
        if (optionString.contains("WorkflowHost") || optionString.contains("WfHost") || optionString.contains("WFHost")) {
            setupSequence = setupSequence.setWorkflowHostFlag(true);
        }
        Matcher idMatcher = StepDefinitionConstants.INSTANCE_DEFINITION_ID_SUBPATTERN.matcher(optionString);
        String customNodeId = null;
        if (idMatcher.find()) {
            customNodeId = idMatcher.group(1);
        }
        setupSequence = imMasterRole == null ? setupSequence.enableImSshAccessWithDefaultRole(imSshPortNumber) : setupSequence.enableImSshAccessWithRole(imSshPortNumber, imMasterRole);
        setupSequence = setupSequence.setName(instanceId);
        if (customNodeId != null) {
            setupSequence = setupSequence.setCustomNodeId(customNodeId);
        }
        INSTANCE_MANAGEMENT_SERVICE.applyInstanceConfigurationOperations(instanceId, setupSequence, (TextOutputReceiver)imOperationOutputReceiver);
    }

    private String parseInstallationId(String buildShort, String buildExplicit, PrefixingTextOutForwarder imOperationOutputReceiver) throws IOException {
        block13: {
            if (buildShort == null) break block13;
            String buildUnderTestId = this.executionContext.getBuildUnderTestId();
            switch (buildShort) {
                case "default": {
                    return this.parseInstallationId(imOperationOutputReceiver, buildUnderTestId);
                }
                case "legacy": {
                    return this.installPreviousBuild(9, "_legacy", "https://software.dlr.de/updates/rce/9.x/products/standard/releases/latest/zip/rce-9.1.1.201907260521-standard-*.x86_64.zip", imOperationOutputReceiver);
                }
                case "base": {
                    return this.installPreviousBuild(10, "_base_major", "https://software.dlr.de/updates/rce/10.x/products/standard/releases/10.0.0/zip/rce-10.0.0.201911221509-standard-*.x86_64.zip", imOperationOutputReceiver);
                }
            }
            Assert.fail((String)StringUtils.format((String)"%s is not a supported as a shortcut leading to an actual installation id", (Object[])new Object[]{buildShort}));
            return "";
        }
        return this.parseInstallationId(imOperationOutputReceiver, buildExplicit);
    }

    private String installPreviousBuild(int version, String installationFolderName, String url, PrefixingTextOutForwarder imOperationOutputReceiver) throws IOException {
        File targetDir;
        File downloadFile = new File(INSTANCE_MANAGEMENT_SERVICE.getDownloadsCacheDir(), "/" + installationFolderName + version + ".zip");
        String replacement = OS.isFamilyWindows() ? "win32" : "linux";
        url = url.replace("*", replacement);
        if (!downloadFile.exists()) {
            this.deploymentOperations.setUserOutputReceiver((TextOutputReceiver)imOperationOutputReceiver);
            this.deploymentOperations.downloadFile(url, downloadFile, true, true, (int)TimeUnit.SECONDS.toMillis(60L));
        }
        if (!(targetDir = new File(INSTANCE_MANAGEMENT_SERVICE.getInstallationsRootDir(), String.valueOf(installationFolderName) + "/" + version)).exists()) {
            this.deploymentOperations.installFromProductZip(downloadFile, targetDir);
        }
        return String.valueOf(installationFolderName) + "/" + version;
    }

    private String parseInstallationId(PrefixingTextOutForwarder imOperationOutputReceiver, String buildOrInstallationId) throws IOException {
        if (INSTANCE_MANAGEMENT_SERVICE.isSpecialInstallationId(buildOrInstallationId)) {
            return buildOrInstallationId;
        }
        String installationId = this.deriveImplicitInstallationIdFromBuildId(buildOrInstallationId);
        this.printToCommandConsole(StringUtils.format((String)"Setting up installation \"%s\" using build \"%s\"", (Object[])new Object[]{installationId, buildOrInstallationId}));
        INSTANCE_MANAGEMENT_SERVICE.setupInstallationFromUrlQualifier(installationId, buildOrInstallationId, InstanceManagementService.InstallationPolicy.IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT, (TextOutputReceiver)imOperationOutputReceiver, TimeUnit.SECONDS.toMillis(60L));
        return installationId;
    }

    private String deriveImplicitInstallationIdFromBuildId(String buildId) {
        return buildId.replaceAll("[^\\w]", "_");
    }
}

