/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.gui.palette.ComponentKnowledgeUpdateListener;
import de.rcenvironment.core.gui.palette.PaletteViewConstants;
import de.rcenvironment.core.gui.palette.ToolGroupAssignment;
import de.rcenvironment.core.gui.palette.toolidentification.ToolIdentification;
import de.rcenvironment.core.gui.palette.toolidentification.ToolType;
import de.rcenvironment.core.gui.palette.view.PaletteView;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.AccessibleComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.ComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.GroupNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Display;

public class PaletteViewContentProvider
implements ITreeContentProvider {
    private PaletteView paletteView;
    private PaletteTreeNode rootNode;
    private ToolGroupAssignment assignment;
    private ServiceRegistryPublisherAccess serviceRegistryAccess;
    private LogicalNodeId localNode;
    private Set<DistributedComponentEntry> currentToolInstallations;

    public PaletteViewContentProvider(PaletteView paletteView) {
        this.paletteView = paletteView;
        this.assignment = new ToolGroupAssignment();
        this.serviceRegistryAccess = this.getServiceRegistryPublisherAccess();
        DistributedComponentKnowledgeService distributedComponentKnowledgeService = (DistributedComponentKnowledgeService)this.serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class);
        this.localNode = this.getLocalNodeId();
        this.currentToolInstallations = this.getCurrentToolInstallations(distributedComponentKnowledgeService);
        this.registerChangeListeners();
    }

    protected Set<DistributedComponentEntry> getCurrentToolInstallations(DistributedComponentKnowledgeService distributedComponentKnowledgeService) {
        return new HashSet<DistributedComponentEntry>(ComponentUtils.eliminateComponentInterfaceDuplicates((Collection)distributedComponentKnowledgeService.getCurrentSnapshot().getAllInstallations(), (LogicalNodeId)this.localNode));
    }

    protected LogicalNodeId getLocalNodeId() {
        return ((PlatformService)ServiceRegistry.createAccessFor((Object)this).getService(PlatformService.class)).getLocalDefaultLogicalNodeId();
    }

    protected Set<DistributedComponentEntry> getCurrentToolInstallations() {
        return this.currentToolInstallations;
    }

    protected void setCurrentToolInstallations(Set<DistributedComponentEntry> currentToolInstallations) {
        this.currentToolInstallations = currentToolInstallations;
    }

    private LogicalNodeId getLocalNode() {
        return this.localNode;
    }

    public ToolGroupAssignment getAssignment() {
        return this.assignment;
    }

    protected void setAssignment(ToolGroupAssignment assignment) {
        this.assignment = assignment;
    }

    public PaletteView getPaletteView() {
        return this.paletteView;
    }

    protected void registerChangeListeners() {
        this.serviceRegistryAccess.registerService(DistributedComponentKnowledgeListener.class, (Object)new ComponentKnowledgeUpdateListener(this));
    }

    public Object[] getChildren(Object parent) {
        if (!(parent instanceof PaletteTreeNode) || parent instanceof AccessibleComponentNode) {
            return new PaletteTreeNode[0];
        }
        PaletteTreeNode node = (PaletteTreeNode)parent;
        if (!node.hasChildren()) {
            return node.getChildren();
        }
        PaletteTreeNode[] children = (PaletteTreeNode[])node.getChildren();
        children = (PaletteTreeNode[])Arrays.stream(children).filter(child -> !child.isOfflineComponent()).map(PaletteTreeNode.class::cast).toArray(PaletteTreeNode[]::new);
        ArrayList<PaletteTreeNode> childList = new ArrayList<PaletteTreeNode>();
        PaletteTreeNode[] paletteTreeNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                PaletteTreeNode child2;
                block6: {
                    child2 = paletteTreeNodeArray[n2];
                    if (!child2.isGroup()) break block6;
                    boolean addToList = false;
                    boolean bl = addToList = this.containsAnyToolNodes(child2, true) || this.getPaletteView().isShowEmptyGroups() && child2.getGroupNode().isCustomGroup();
                    if (!addToList) break block7;
                }
                childList.add(child2);
            }
            ++n2;
        }
        return childList.toArray();
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public Object getParent(Object object) {
        if (object instanceof PaletteTreeNode) {
            return ((PaletteTreeNode)object).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof PaletteTreeNode && ((PaletteTreeNode)object).isGroup()) {
            PaletteTreeNode node = (PaletteTreeNode)object;
            if (node.getChildren() == null) {
                return false;
            }
            return Arrays.stream(node.getChildren()).anyMatch(GroupNode.class::isInstance) || this.containsAnyToolNodes(node, true);
        }
        return false;
    }

    protected void setRootNode(PaletteTreeNode root) {
        this.rootNode = root;
    }

    private Optional<PaletteTreeNode> getDefaultGroup(ToolIdentification toolIdentification) {
        for (DistributedComponentEntry entry : this.getCurrentToolInstallations()) {
            String toolID = entry.getComponentInterface().getIdentifierAndVersion();
            if (!toolIdentification.getToolID().equals(toolID)) continue;
            String groupPath = entry.getComponentInstallation().getComponentInterface().getGroupName();
            if (!groupPath.equals(toolIdentification.getType().getTopLevelGroupName())) {
                groupPath = String.valueOf(toolIdentification.getType().getTopLevelGroupName()) + "/" + groupPath;
            }
            return Optional.of(this.getOrCreateGroupNode(this.assignment.createPathArray(groupPath)));
        }
        return Optional.empty();
    }

    public void resetGroup(ComponentNode node) {
        if (node == null) {
            return;
        }
        this.assignment.getCustomizedAssignments().remove(node.getToolIdentification());
        PaletteTreeNode parent = node.getPaletteParent();
        parent.removeChild(node);
        Optional<PaletteTreeNode> optional = this.getDefaultGroup(node.getToolIdentification());
        if (optional.isPresent()) {
            PaletteTreeNode defaultGroup = optional.get();
            defaultGroup.addChild(node);
            node.setParent(defaultGroup);
        }
    }

    private AccessibleComponentNode createToolNode(PaletteTreeNode parent, DistributedComponentEntry toolEntry, ToolIdentification toolIdentification) {
        AccessibleComponentNode nodeToAdd = PaletteTreeNode.createToolNode(parent, toolEntry, toolIdentification);
        nodeToAdd.setParent(parent);
        return nodeToAdd;
    }

    public boolean toolIsPresent(String toolName) {
        return this.getCurrentToolInstallations().stream().map(DistributedComponentEntry::getDisplayName).anyMatch(toolName::equals);
    }

    public void updateGroup(AccessibleComponentNode node, PaletteTreeNode group) {
        if (node.getParent().equals((Object)group)) {
            return;
        }
        ToolIdentification identification = ToolIdentification.createToolIdentification(node.getComponentEntry());
        this.assignment.getCustomizedAssignments().remove(identification);
        this.assignment.getCustomizedAssignments().put(identification, this.assignment.createPathArray(group.getQualifiedGroupName()));
        PaletteTreeNode parent = node.getPaletteParent();
        parent.removeChild(node);
        group.addChild(node);
        node.setParent(group);
    }

    protected List<GroupNode> getAllGroupNodes() {
        return this.getRootNode().getAllSubGroups();
    }

    public PaletteTreeNode getRootNode() {
        return this.rootNode;
    }

    public PaletteTreeNode getOrCreateGroupNode(String[] pathArray) {
        Optional<PaletteTreeNode> optional = this.getExistingGroupNode(pathArray);
        if (optional.isPresent()) {
            return optional.get();
        }
        if (pathArray.length > 1) {
            PaletteTreeNode parent = this.getOrCreateGroupNode(Arrays.copyOfRange(pathArray, 0, pathArray.length - 1));
            String nodeName = pathArray[pathArray.length - 1];
            PaletteTreeNode newGroupNode = PaletteTreeNode.createGroupNode(parent, nodeName);
            parent.addChild(newGroupNode);
            return newGroupNode;
        }
        PaletteTreeNode root = this.getRootNode();
        PaletteTreeNode newGroupNode = PaletteTreeNode.createGroupNode(root, pathArray[0]);
        root.addChild(newGroupNode);
        return newGroupNode;
    }

    public PaletteTreeNode createGroupNode(PaletteTreeNode parent, String groupName) {
        PaletteTreeNode node = PaletteTreeNode.createGroupNode(parent, groupName);
        parent.addChild(node);
        return node;
    }

    private Optional<PaletteTreeNode> getExistingGroupNode(String[] pathArray) {
        List<GroupNode> currentGroups = this.getAllGroupNodes();
        for (PaletteTreeNode paletteTreeNode : currentGroups) {
            if (!paletteTreeNode.getQualifiedGroupName().equals(this.assignment.createQualifiedGroupName(pathArray))) continue;
            return Optional.of(paletteTreeNode);
        }
        return Optional.empty();
    }

    private void addTool(ToolIdentification toolIdentification, DistributedComponentEntry entry) {
        String[] pathArray;
        if (this.assignment.getCustomizedAssignments().containsKey(toolIdentification)) {
            pathArray = this.assignment.getCustomizedAssignments().get(toolIdentification);
        } else {
            String groupPath = entry.getComponentInstallation().getComponentInterface().getGroupName();
            if (groupPath == null) {
                groupPath = toolIdentification.getType().getTopLevelGroupName();
            } else if (!groupPath.equals(toolIdentification.getType().getTopLevelGroupName())) {
                groupPath = String.valueOf(toolIdentification.getType().getTopLevelGroupName()) + "/" + groupPath;
            }
            pathArray = this.assignment.createPathArray(groupPath);
        }
        this.addChildToTree(entry, pathArray, toolIdentification);
    }

    private void removeChildFromTreeViewer(ToolIdentification identification, boolean refreshGroupNode) {
        List<ComponentNode> nodeList = this.getAllComponentNodes(this.getRootNode());
        nodeList.stream().filter(node -> node.getToolIdentification().equals(identification)).forEach(node -> {
            PaletteTreeNode parent = node.getPaletteParent();
            parent.removeChild((TreeNode)node);
            if (refreshGroupNode) {
                this.refreshPaletteTreeViewer(parent);
                this.removeEmptyToolIntegrationGroups(parent);
            }
        });
    }

    private void addChildToTree(DistributedComponentEntry entry, String[] pathArray, ToolIdentification toolIdentification) {
        PaletteTreeNode groupNode = this.getOrCreateGroupNode(pathArray);
        AccessibleComponentNode toolNode = this.createToolNode(groupNode, entry, toolIdentification);
        if (!this.getAllComponentNodes(this.getRootNode()).contains(toolNode)) {
            groupNode.addChild(toolNode);
        }
    }

    public List<ComponentNode> getAllComponentNodes(PaletteTreeNode node) {
        ArrayList<ComponentNode> nodeList = new ArrayList<ComponentNode>();
        if (node.getChildren() == null) {
            return nodeList;
        }
        TreeNode[] treeNodeArray = node.getChildren();
        int n = treeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode child = treeNodeArray[n2];
            if (child instanceof ComponentNode) {
                nodeList.add((ComponentNode)child);
            } else {
                nodeList.addAll(this.getAllComponentNodes((PaletteTreeNode)child));
            }
            ++n2;
        }
        return nodeList;
    }

    public void refreshPaletteView(Collection<DistributedComponentEntry> newState) {
        Display.getDefault().asyncExec(() -> {
            AccessibleComponentNode node;
            Object o;
            List newToolInstallations = ComponentUtils.eliminateComponentInterfaceDuplicates((Collection)newState, (LogicalNodeId)this.getLocalNode());
            HashSet<DistributedComponentEntry> installationsToRemove = new HashSet<DistributedComponentEntry>();
            HashSet<DistributedComponentEntry> installationsToAdd = new HashSet<DistributedComponentEntry>();
            installationsToRemove.addAll(this.getCurrentToolInstallations());
            installationsToRemove.removeAll(newToolInstallations);
            installationsToAdd.addAll(newToolInstallations);
            installationsToAdd.removeAll(this.getCurrentToolInstallations());
            this.getCurrentToolInstallations().clear();
            this.getCurrentToolInstallations().addAll(newToolInstallations);
            Optional<WorkflowEditor> editor = this.paletteView.getWorkflowEditor();
            if (editor.isPresent() && !editor.get().getViewer().getEditDomain().getActiveTool().equals(this.paletteView.getSelectionTool()) && (o = this.paletteView.getPaletteTreeViewer().getStructuredSelection().getFirstElement()) instanceof AccessibleComponentNode && installationsToRemove.contains((node = (AccessibleComponentNode)o).getComponentEntry())) {
                this.paletteView.selectSelectionToolNode();
            }
            this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
            Object[] expandedElements = this.paletteView.getPaletteTreeViewer().getExpandedElements();
            this.updateTree(installationsToAdd, installationsToRemove);
            this.paletteView.getPaletteTreeViewer().refresh();
            this.paletteView.getPaletteTreeViewer().setExpandedElements(expandedElements);
            this.paletteView.getPaletteTreeViewer().refresh();
            this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
            if (this.paletteView.getOrganizeGroupsDialog() != null) {
                this.paletteView.getOrganizeGroupsDialog().refreshTree();
            }
        });
    }

    public void updateTree(Set<DistributedComponentEntry> toolInstallationsToAdd, Set<DistributedComponentEntry> toolsToRemove) {
        if (toolsToRemove != null) {
            for (DistributedComponentEntry entry : toolsToRemove) {
                ToolIdentification identification = ToolIdentification.createToolIdentification(entry);
                this.removeChildFromTreeViewer(identification, true);
            }
        }
        for (DistributedComponentEntry entry : toolInstallationsToAdd) {
            ToolIdentification toolIdentification = ToolIdentification.createToolIdentification(entry);
            if (this.getAssignment().getCustomizedAssignments().containsKey(toolIdentification)) {
                this.removeChildFromTreeViewer(toolIdentification, false);
            }
            this.addTool(toolIdentification, entry);
        }
        for (ToolIdentification toolIdentification : this.getAssignment().getCustomizedAssignments().keySet()) {
            if (this.containsComponent(this.getRootNode(), toolIdentification)) continue;
            PaletteTreeNode node = this.getOrCreateGroupNode(this.getAssignment().getCustomizedAssignments().get(toolIdentification));
            node.addChild(PaletteTreeNode.createOfflineComponentNode(node, toolIdentification));
        }
    }

    private boolean containsComponent(TreeNode node, ToolIdentification identification) {
        ComponentNode componentNode;
        if (node instanceof ComponentNode && (componentNode = (ComponentNode)node).getToolIdentification().equals(identification)) {
            return true;
        }
        if (!node.hasChildren()) {
            return false;
        }
        TreeNode[] treeNodeArray = node.getChildren();
        int n = treeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode child = treeNodeArray[n2];
            if (this.containsComponent(child, identification)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean containsAnyToolNodes(PaletteTreeNode node, boolean exludeOfflineTools) {
        if (!node.isGroup()) {
            return node.isAccessibleComponent() || node.isOfflineComponent() && !exludeOfflineTools;
        }
        PaletteTreeNode[] children = (PaletteTreeNode[])node.getChildren();
        if (children == null) {
            return false;
        }
        boolean hasToolNodes = false;
        PaletteTreeNode[] paletteTreeNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            PaletteTreeNode child = paletteTreeNodeArray[n2];
            hasToolNodes = this.containsAnyToolNodes(child, exludeOfflineTools);
            if (hasToolNodes) break;
            ++n2;
        }
        return hasToolNodes;
    }

    protected PaletteTreeNode[] getSuitableGroups(AccessibleComponentNode[] nodes, boolean hideOwnGroup) {
        List<GroupNode> groupList = this.getRootNode().getAllSubGroups();
        groupList.removeIf(group -> ToolType.STANDARD_COMPONENT.getTopLevelGroupName().equals(group.getQualifiedGroupName()));
        groupList.removeIf(group -> Arrays.asList(PaletteViewConstants.RCE_STANDARD_GROUPS).contains(group.getQualifiedGroupName()));
        List selectedToolTypes = Arrays.stream(nodes).map(ComponentNode::getType).distinct().collect(Collectors.toList());
        selectedToolTypes.stream().forEach(type -> {
            boolean bl = groupList.removeIf(group -> !this.getTopLevelGroup((PaletteTreeNode)group).isCustomGroup() && !group.getQualifiedGroupName().startsWith(type.getTopLevelGroupName()));
        });
        if (hideOwnGroup && Arrays.stream(nodes).map(ComponentNode::getType).sorted().distinct().toArray().length == 1) {
            groupList.removeIf(group -> group.equals(nodes[0].getParent()));
        }
        return (PaletteTreeNode[])groupList.stream().sorted().toArray(PaletteTreeNode[]::new);
    }

    private GroupNode getTopLevelGroup(PaletteTreeNode node) {
        if (node.getPaletteParent().equals(this.getRootNode())) {
            return (GroupNode)node;
        }
        return this.getTopLevelGroup(node.getPaletteParent());
    }

    public void deleteGroup(PaletteTreeNode node) {
        if (node.hasChildren()) {
            TreeNode[] treeNodeArray = node.getChildren();
            int n = treeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode child = treeNodeArray[n2];
                if (child instanceof PaletteTreeNode) {
                    this.deleteGroup((PaletteTreeNode)child);
                }
                ++n2;
            }
        }
        PaletteTreeNode parent = node.getPaletteParent();
        parent.removeChild(node);
        this.refreshPaletteTreeViewer(parent);
        this.removeEmptyToolIntegrationGroups(parent);
    }

    public void refreshPaletteTreeViewer(PaletteTreeNode parent) {
        this.getPaletteView().getPaletteTreeViewer().refresh((Object)parent);
    }

    public boolean isExpandable(GroupNode node) {
        if (node.getChildren() == null) {
            return false;
        }
        TreeNode[] children = node.getChildren();
        return Arrays.stream(children).filter(PaletteTreeNode.class::isInstance).map(PaletteTreeNode.class::cast).anyMatch(child -> child.isGroup() || this.containsAnyToolNodes((PaletteTreeNode)child, true));
    }

    protected void addAllParentGroupNodes(PaletteTreeNode node, List<PaletteTreeNode> nodes) {
        if (node.getParent() == null) {
            return;
        }
        PaletteTreeNode parent = node.getPaletteParent();
        if (parent.isGroup()) {
            nodes.add(parent);
            this.addAllParentGroupNodes(parent, nodes);
        }
    }

    protected void setExpandedState(TreeNode[] nodes, boolean expanded) {
        if (nodes == null) {
            return;
        }
        Arrays.stream(nodes).filter(GroupNode.class::isInstance).map(GroupNode.class::cast).forEach(node -> {
            this.setExpandedState((PaletteTreeNode)node, expanded);
            this.setExpandedState(node.getChildren(), expanded);
        });
    }

    public void setExpandedState(PaletteTreeNode node, boolean expanded) {
        this.getPaletteView().getPaletteTreeViewer().setExpandedState((Object)node, expanded);
        this.getPaletteView().getPaletteTreeViewer().update((Object)node, new String[]{"org.eclipse.jface.image"});
    }

    protected void removeEmptyToolIntegrationGroups(PaletteTreeNode node) {
        if (!node.hasChildren() && node.isGroup() && !node.getGroupNode().isCustomGroup()) {
            PaletteTreeNode parent = node.getPaletteParent();
            this.deleteGroup(node);
            this.removeEmptyToolIntegrationGroups(parent);
        }
    }

    public void dispose() {
        this.serviceRegistryAccess.dispose();
    }

    protected ServiceRegistryPublisherAccess getServiceRegistryPublisherAccess() {
        return ServiceRegistry.createPublisherAccessFor((Object)this);
    }

    public boolean getExpandedState(PaletteTreeNode node) {
        return this.getPaletteView().getPaletteTreeViewer().getExpandedState((Object)node);
    }
}

