/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.ComponentMonitorStrategy;
import org.picocontainer.InjectionFactory;
import org.picocontainer.Injector;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.lifecycle.NullLifecycleStrategy;

public abstract class AbstractInjectionFactory
implements InjectionFactory,
Serializable {
    public void verify(PicoContainer container) {
    }

    public final void accept(PicoVisitor visitor) {
        visitor.visitComponentFactory(this);
    }

    protected ComponentAdapter wrapLifeCycle(Injector injector, LifecycleStrategy lifecycleStrategy) {
        if (lifecycleStrategy instanceof NullLifecycleStrategy) {
            return injector;
        }
        return new LifecycleAdapter(injector, lifecycleStrategy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifecycleAdapter
    implements Injector,
    LifecycleStrategy,
    ComponentMonitorStrategy,
    Serializable {
        private final Injector delegate;
        private final LifecycleStrategy lifecycleStrategy;

        public LifecycleAdapter(Injector delegate, LifecycleStrategy lifecycleStrategy) {
            this.delegate = delegate;
            this.lifecycleStrategy = lifecycleStrategy;
        }

        @Override
        public Object getComponentKey() {
            return this.delegate.getComponentKey();
        }

        @Override
        public Class getComponentImplementation() {
            return this.delegate.getComponentImplementation();
        }

        @Override
        public Object getComponentInstance(PicoContainer container) throws PicoCompositionException {
            return this.delegate.getComponentInstance(container);
        }

        @Override
        public Object getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            return this.delegate.getComponentInstance(container, into);
        }

        @Override
        public void verify(PicoContainer container) throws PicoCompositionException {
            this.delegate.verify(container);
        }

        @Override
        public void accept(PicoVisitor visitor) {
            this.delegate.accept(visitor);
        }

        @Override
        public ComponentAdapter getDelegate() {
            return this.delegate;
        }

        @Override
        public ComponentAdapter findAdapterOfType(Class adapterType) {
            return this.delegate.findAdapterOfType(adapterType);
        }

        @Override
        public String getDescriptor() {
            return "LifecycleAdapter";
        }

        public String toString() {
            return this.getDescriptor() + ":" + this.delegate.toString();
        }

        @Override
        public void start(Object component) {
            this.lifecycleStrategy.start(component);
        }

        @Override
        public void stop(Object component) {
            this.lifecycleStrategy.stop(component);
        }

        @Override
        public void dispose(Object component) {
            this.lifecycleStrategy.dispose(component);
        }

        @Override
        public boolean hasLifecycle(Class<?> type) {
            return this.lifecycleStrategy.hasLifecycle(type);
        }

        @Override
        public boolean isLazy(ComponentAdapter<?> adapter) {
            return this.lifecycleStrategy.isLazy(adapter);
        }

        @Override
        public void changeMonitor(ComponentMonitor monitor) {
            if (this.delegate instanceof ComponentMonitorStrategy) {
                ((ComponentMonitorStrategy)((Object)this.delegate)).changeMonitor(monitor);
            }
        }

        @Override
        public ComponentMonitor currentMonitor() {
            if (this.delegate instanceof ComponentMonitorStrategy) {
                return ((ComponentMonitorStrategy)((Object)this.delegate)).currentMonitor();
            }
            return null;
        }

        public Object decorateComponentInstance(PicoContainer container, Type into, Object instance) {
            return this.delegate.decorateComponentInstance(container, into, instance);
        }
    }
}

