/*
 * Copyright 2006-2022 DLR, Germany
 * 
 * SPDX-License-Identifier: EPL-1.0
 * 
 * https://rcenvironment.de/
 */

package de.rcenvironment.core.component.model.configuration.api;

/**
 * Constants used in JSON files to describe endpoint meta data.
 * 
 * @author Doreen Seider
 */
public final class PlaceholdersMetaDataConstants {

    /** placeholder data type suffix. */
    public static final String DATA_TYPE = "_datatype_799ef365";
    
    /** Type of meta datum. */
    public static final String TYPE_TEXT = "text";

    /** Type of meta datum. */
    public static final String TYPE_BOOL = "bool";

    /** Type of meta datum. */
    public static final String TYPE_INT = "int";

    /** Type of meta datum. */
    public static final String TYPE_FLOAT = "float";
    
    /** Type of meta datum. */
    public static final String TYPE_FILE = "file";
    
    /** Type of meta datum. */
    public static final String TYPE_DIR = "dir";

    private PlaceholdersMetaDataConstants() {}

}
